/*
 * Decompiled with CFR 0.152.
 */
package org.staccato.functions;

import org.jfugue.midi.MidiTools;
import org.staccato.StaccatoParserContext;
import org.staccato.SubparserFunction;

public class ControllerFunction
implements SubparserFunction {
    private static ControllerFunction instance;
    public static String[] NAMES;

    public static ControllerFunction getInstance() {
        if (instance == null) {
            instance = new ControllerFunction();
        }
        return instance;
    }

    private ControllerFunction() {
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public void apply(String parameters, StaccatoParserContext context) {
        String[] params = parameters.split(",");
        if (params.length == 2) {
            int controllerNumber = 0;
            String controllerId = params[0].trim();
            if (controllerId.matches("\\d+")) {
                controllerNumber = Integer.parseInt(controllerId);
            } else {
                if (controllerId.charAt(0) == '[') {
                    controllerId = controllerId.substring(1, controllerId.length() - 1);
                }
                controllerNumber = (Integer)context.getDictionary().get(controllerId);
            }
            if (controllerNumber > 127) {
                context.getParser().fireControllerEventParsed(MidiTools.getLSB(controllerNumber), MidiTools.getLSB(Integer.parseInt(params[1].trim())));
                context.getParser().fireControllerEventParsed(MidiTools.getMSB(controllerNumber), MidiTools.getMSB(Integer.parseInt(params[1].trim())));
            } else {
                context.getParser().fireControllerEventParsed((byte)controllerNumber, Byte.parseByte(params[1].trim()));
            }
        }
    }

    static {
        NAMES = new String[]{"CE", "CON", "CONTROLLER", "CONTROLLEREVENT"};
    }
}

