// Timer
function itcGetTimeRemaining(endtime) {
    var t = endtime - +new Date(),
        seconds = Math.floor((t / 1000) % 60),
        minutes = Math.floor((t / 1000 / 60) % 60);
    return {
        total: t,
        minutes: minutes,
        seconds: seconds
    };
}

function itcInitializeClock(id, endtime) {
    if (!document.getElementById(id)) {
        id = 'congratulation_bartimer';
    }
    var clock = document.getElementById(id),
        minutesSpan = clock.querySelector('[data-itc-bar-minutes]'),
        secondsSpan = clock.querySelector('[data-itc-bar-seconds]');
    // minutesSpan = clock.querySelector('.minutes'),
    // secondsSpan = clock.querySelector('.seconds');

    function updateClock() {
        var t = itcGetTimeRemaining(endtime);

        minutesSpan.innerHTML = ('0' + t.minutes).slice(-2) + ' : ';
        secondsSpan.innerHTML = ('0' + t.seconds).slice(-2);

        if (t.total <= 0) {
            var bar, popup;

            bar = document.querySelector('[data-itc-bar]');
            popup = document.querySelector('.itc_popup .itc_outter-popup');

            if (popup) popup.parentElement.removeChild(popup);

            if (bar) {
                bar.parentElement.removeChild(bar);
                localStorage.removeItem('itc-bar-folded');
            }
        }
    }

    updateClock();

    var timeinterval = setInterval(updateClock, 1000);
}

//Events for popup and bar
function itcClose(target, button, finishDiscount, fold) {
    button.addEventListener('click', function() {
        if (button.dataset.itcCloseBar === '') {
            button.closest('[data-itc-bar]').remove();
            if (finishDiscount) finishDiscount();
            if (!itc_triggers.discounts.track_get_discount) itc_triggers.discounts = null;
            localStorage.removeItem('itc-bar-folded');
            return;
        }
        if (fold) {
            localStorage.setItem('itc-bar-folded', true);
            itcToggleBarState();
            return;
        }

        target.parentElement.removeChild(target);
        if (finishDiscount) finishDiscount();
        if (!itc_triggers.discounts.track_get_discount) itc_triggers.discounts = null;
        //itc_triggers.discounts.show_html = false;
        //localStorage.setItem('itc_' + window.location.hostname, itc_triggers);
    });
}

//Outter popup and bar settings
function itcSetting() {
    var closeBar = document.querySelector('[data-itc-hide-bar]');
    // var closeBar = document.querySelector('.itc_close-bar');
    var adminBar = document.getElementById('admin_bar_iframe');
    var popup = document.querySelector('.itc_popup .itc_outter-popup'),
        copy = document.querySelector('.itc_outter-btn'),
        barHtml = JSON.parse(localStorage.getItem('itc_html_bar')),
        bar = document.querySelector('[data-itc-bar]');
    // bar = document.querySelector('.itc_bar .itc_outter-bar');

    if (copy) {
        copy.addEventListener('click', function(e) {
            try {
                if (!itc_triggers || !itc_triggers.discounts) return;
                trackGetDiscount();
                itcCopyToClipboard(itc_triggers.discounts.code);
                itc_triggers.discounts.click_get_discount = true;
                itc_triggers.discounts.show_html = true;
                localStorage.setItem('itc_' + location.hostname, JSON.stringify(itc_triggers));
                setTimeout(function() {
                    popup && popup.remove();
                    bar && bar.remove();

                    itcShowBar(barHtml);
                }, 500);
            } catch (e) {
                return;
            }
        });
    }

    function trackGetDiscount() {
        var params, url, triggerId, discontId, res;
        itc_triggers.discounts.track_get_discount = true;
        itc_triggers.discounts.discount_created = true;
        url = '/cart.js';

        callback = function() {
            res = JSON.parse(this.response);
            triggerId = encodeURIComponent(itc_triggers.discounts.trigger_id);
            discontId = encodeURIComponent(itc_triggers.discounts.discount_id);

            params = '?id=' + triggerId + '&discount_id=' + discontId + '&cart_token=' + res.token;
            url = 'https://' + itc_application_url + '/events/create_shopify_discount' + params;

            callback = function() {
                res = JSON.parse(this.response);

                if (!res.status) itc_triggers.discounts = null;
                else itcAjax('GET', '/discount/'+itc_triggers.discounts.code);
            };

            itcAjax('GET', url, callback);
        };

        itcAjax('GET', url, callback);
    }

    function noEditableText(blockSelector) {
        if (blockSelector) {
            var editable = blockSelector.querySelectorAll('[contenteditable="true"]');

            Array.prototype.forEach.call(editable, function(item) {
                item.setAttribute('contenteditable', false);
            });
        }
    }

    function popupHeight() {
        if (popup) {
            var heightPopup = popup.firstElementChild.offsetHeight,
                heightDocument = document.documentElement.clientHeight;

            if (heightPopup + 50 > heightDocument) {
                popup.firstElementChild.classList.add('fix-height');
            }
        }
    }

    noEditableText(popup);
    noEditableText(bar);

    popupHeight();
}

function itcToggleBarState() {
    var isFolded = JSON.parse(localStorage.getItem('itc-bar-folded'));

    var bar = document.querySelector('[data-itc-bar]');
    var hide = bar.querySelector('[data-itc-hide-bar]');
    var show = bar.querySelector('[data-itc-show-bar]');
    var text = bar.querySelector('[data-itc-bar-text]');
    var timer = bar.querySelector('[data-itc-bar-content]');
    var minutes = bar.querySelector('[data-itc-bar-minutes]');
    var seconds = bar.querySelector('[data-itc-bar-seconds]');
    var close = bar.querySelector('[data-itc-close-bar]');

    if (!close) {
        show.classList.toggle('hidden', !isFolded);
    }

    bar.classList.toggle('folded', isFolded);
    hide.classList.toggle('hidden', isFolded);
    text && text.classList.toggle('hidden', isFolded);
    timer.classList.toggle('folded', isFolded);
    minutes.classList.toggle('folded', isFolded);
    seconds.classList.toggle('folded', isFolded);
}
