/*
 * Decompiled with CFR 0.152.
 */
package org.staccato;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfugue.pattern.Pattern;
import org.jfugue.pattern.PatternProducer;

public interface Instruction {
    public String onInstructionReceived(String[] var1);

    public static interface Splitter {
        public Map<String, String> splitInstructionParameter(String var1);
    }

    public static class LastIsValueToSplit
    implements Instruction {
        private String instruction;
        private Splitter splitter;

        public LastIsValueToSplit(String instruction, Splitter splitter) {
            this.instruction = instruction;
            this.splitter = splitter;
        }

        @Override
        public String onInstructionReceived(String[] instructions) {
            Map<String, String> map = this.splitter.splitInstructionParameter(instructions[instructions.length - 1]);
            for (String key : map.keySet()) {
                this.instruction = this.instruction.replace(key, map.get(key));
            }
            return this.instruction;
        }
    }

    public static class LastIsValue
    implements Instruction {
        public static char REPLACE_CHAR = (char)36;
        private String instruction;

        public LastIsValue(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public String onInstructionReceived(String[] instructions) {
            StringBuilder buddy = new StringBuilder();
            int posDollar = this.instruction.indexOf(REPLACE_CHAR);
            buddy.append(this.instruction.substring(0, posDollar));
            buddy.append(instructions[instructions.length - 1]);
            buddy.append(this.instruction.substring(posDollar + 1, this.instruction.length()));
            return buddy.toString();
        }
    }

    public static class Switch
    implements Instruction {
        public static char REPLACE_CHAR = (char)36;
        private String instruction;
        private String offValue;
        private String onValue;

        public Switch(String instruction, String offValue, String onValue) {
            this.instruction = instruction;
            this.offValue = offValue;
            this.onValue = onValue;
        }

        public Switch(String instruction, int offValue, int onValue) {
            this(instruction, Integer.toString(offValue), Integer.toString(onValue));
        }

        public Switch(String instruction, Pattern offValue, Pattern onValue) {
            this(instruction, offValue.toString(), onValue.toString());
        }

        @Override
        public String onInstructionReceived(String[] instructions) {
            StringBuilder buddy = new StringBuilder();
            int posDollar = this.instruction.indexOf(REPLACE_CHAR);
            buddy.append(this.instruction.substring(0, posDollar));
            if (instructions[instructions.length - 1].equalsIgnoreCase("ON")) {
                buddy.append(this.onValue);
            } else if (instructions[instructions.length - 1].equalsIgnoreCase("OFF")) {
                buddy.append(this.offValue);
            } else {
                buddy.append(REPLACE_CHAR);
            }
            buddy.append(this.instruction.substring(posDollar + 1, this.instruction.length()));
            return buddy.toString();
        }
    }

    public static class Choice
    implements Instruction {
        private List<String> choices = new ArrayList<String>();

        public Choice(String ... choices) {
            for (String choice : choices) {
                this.choices.add(choice);
            }
        }

        public Choice(int ... choices) {
            for (int choice : choices) {
                this.choices.add(Integer.toString(choice));
            }
        }

        public Choice(PatternProducer ... choices) {
            for (PatternProducer pattern : choices) {
                this.choices.add(pattern.getPattern().toString());
            }
        }

        public List<String> getChoices() {
            return this.choices;
        }

        @Override
        public String onInstructionReceived(String[] instructions) {
            int choice = Integer.decode(instructions[instructions.length - 1]);
            return this.choices.get(choice);
        }
    }
}

