USE SUCOS_VENDAS;

DROP TABLE IF EXISTS ITENS_NOTAS_FISCAIS;
DROP TABLE IF EXISTS NOTAS_FISCAIS;
DROP TABLE IF EXISTS TABELA_DE_CLIENTES;
DROP TABLE IF EXISTS TABELA_DE_PRODUTOS;
DROP TABLE IF EXISTS TABELA_DE_VENDEDORES;

CREATE TABLE TABELA_DE_CLIENTES(
	CPF varchar(11) NOT NULL,
	NOME varchar(100) NULL,
	ENDERECO_1 varchar(150) NULL,
	ENDERECO_2 varchar(150) NULL,
	BAIRRO varchar(50) NULL,
	CIDADE varchar(50) NULL,
	ESTADO varchar(2) NULL,
	CEP varchar(8) NULL,
	DATA_DE_NASCIMENTO date NULL,
	IDADE smallint NULL,
	SEXO varchar(1) NULL,
	LIMITE_DE_CREDITO float NULL,
	VOLUME_DE_COMPRA float NULL,
	PRIMEIRA_COMPRA bit NULL,
	PRIMARY KEY (CPF));
	
CREATE TABLE TABELA_DE_PRODUTOS(
	CODIGO_DO_PRODUTO varchar(10) NOT NULL,
	NOME_DO_PRODUTO varchar(50) NULL,
	EMBALAGEM varchar(20) NULL,
	TAMANHO varchar(10) NULL,
	SABOR varchar(20) NULL,
	PRECO_DE_LISTA float NOT NULL,
    PRIMARY KEY(CODIGO_DO_PRODUTO));
	
CREATE TABLE TABELA_DE_VENDEDORES(
	MATRICULA varchar(5) NOT NULL,
	NOME varchar(100) NULL,
	PERCENTUAL_COMISSAO float NULL,
	DATA_ADMISSAO date NULL,
	DE_FERIAS bit NULL,
	BAIRRO varchar(50) NULL,
 PRIMARY KEY(MATRICULA));
 
 CREATE TABLE NOTAS_FISCAIS(
	CPF varchar(11) NOT NULL,
	MATRICULA varchar(5) NOT NULL,
	DATA_VENDA date NULL,
	NUMERO int NOT NULL,
	IMPOSTO float NOT NULL,
    PRIMARY KEY (NUMERO),
	FOREIGN KEY (MATRICULA) REFERENCES TABELA_DE_VENDEDORES(MATRICULA),
	FOREIGN KEY (CPF) REFERENCES TABELA_DE_CLIENTES(CPF));

CREATE TABLE ITENS_NOTAS_FISCAIS(
	NUMERO int NOT NULL,
	CODIGO_DO_PRODUTO varchar(10) NOT NULL,
	QUANTIDADE int NOT NULL,
	PRECO float NOT NULL,
	PRIMARY KEY (NUMERO, CODIGO_DO_PRODUTO),
	FOREIGN KEY (CODIGO_DO_PRODUTO) REFERENCES TABELA_DE_PRODUTOS (CODIGO_DO_PRODUTO),
	FOREIGN KEY (NUMERO) REFERENCES NOTAS_FISCAIS (NUMERO));