/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class FilterStringGroupScalarGreaterEqualStringGroupColumnBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected byte[] value;

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inputColVector = (BytesColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        byte[][] vector = inputColVector.vector;
        int[] length = inputColVector.length;
        int[] start = inputColVector.start;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) < 0) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) < 0) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) < 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) < 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + FilterStringGroupScalarGreaterEqualStringGroupColumnBase.displayUtf8Bytes(this.value) + ", col " + this.colNum;
    }
}

