/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroOutputField;
import org.pentaho.hadoop.shim.api.format.IPentahoAvroOutputFormat;
import org.pentaho.hadoop.shim.api.format.IPentahoOutputFormat;
import org.pentaho.hadoop.shim.common.format.avro.PentahoAvroRecordWriter;

public class PentahoAvroOutputFormat
implements IPentahoAvroOutputFormat {
    private String outputFilename;
    private List<? extends IAvroOutputField> fields;
    private CodecFactory codecFactory;
    private String nameSpace;
    private String recordName;
    private String docValue;
    private String schemaFilename;
    private Schema schema = null;
    ObjectNode schemaObjectNode = null;

    public IPentahoOutputFormat.IPentahoRecordWriter createRecordWriter() throws Exception {
        this.validate();
        if (this.fields == null || StringUtils.isEmpty((String)this.nameSpace) || StringUtils.isEmpty((String)this.recordName) || StringUtils.isEmpty((String)this.outputFilename)) {
            throw new Exception("Invalid state.  One of the following required fields is null:  'nameSpace', 'recordNum', or 'outputFileName");
        }
        Schema schema = this.getSchema();
        this.writeAvroSchemaToFile(this.schemaFilename);
        GenericDatumWriter datumWriter = new GenericDatumWriter(schema);
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)datumWriter);
        dataFileWriter.setCodec(this.codecFactory);
        dataFileWriter.create(schema, KettleVFS.getOutputStream((String)this.outputFilename, (boolean)false));
        return new PentahoAvroRecordWriter((DataFileWriter<GenericRecord>)dataFileWriter, schema, this.fields);
    }

    private void validate() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/mm/dd HH:mm:ss");
        String date = dateFormat.format(new Date());
        StringBuffer errors = new StringBuffer();
        if (StringUtils.isEmpty((String)this.outputFilename)) {
            errors.append("\n");
            errors.append(date + " - Please set Folder/File name");
        }
        if (StringUtils.isEmpty((String)this.nameSpace)) {
            errors.append("\n");
            errors.append(date + " - Please set the Avro Schema Namespace");
        }
        if (StringUtils.isEmpty((String)this.recordName)) {
            errors.append("\n");
            errors.append(date + " - Please set the Avro Schema Record name.");
        }
        if (!StringUtils.isEmpty((String)errors.toString())) {
            throw new Exception(errors.toString());
        }
    }

    public void setFields(List<? extends IAvroOutputField> fields) throws Exception {
        this.fields = fields;
        this.schema = null;
        this.schemaObjectNode = null;
    }

    public void setOutputFile(String file, boolean override) throws Exception {
        if (!override && KettleVFS.fileExists((String)file)) {
            throw new FileAlreadyExistsException(file);
        }
        this.outputFilename = file;
    }

    public void setCompression(IPentahoAvroOutputFormat.COMPRESSION compression) {
        switch (compression) {
            case SNAPPY: {
                this.codecFactory = CodecFactory.snappyCodec();
                break;
            }
            case DEFLATE: {
                this.codecFactory = CodecFactory.deflateCodec((int)-1);
                break;
            }
            default: {
                this.codecFactory = CodecFactory.nullCodec();
            }
        }
    }

    public void setNameSpace(String namespace) {
        this.nameSpace = namespace;
        this.schema = null;
        this.schemaObjectNode = null;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
        this.schema = null;
        this.schemaObjectNode = null;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
        this.schema = null;
        this.schemaObjectNode = null;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }

    protected Schema getSchema() {
        ObjectNode schemaObjectNode;
        if (this.schema == null && (schemaObjectNode = this.getSchemaObjectNode()) != null) {
            this.schema = new Schema.Parser().parse(schemaObjectNode.toString());
        }
        return this.schema;
    }

    protected ObjectNode getSchemaObjectNode() {
        if (this.schemaObjectNode == null && this.fields != null) {
            ObjectMapper mapper = new ObjectMapper();
            this.schemaObjectNode = mapper.createObjectNode();
            this.schemaObjectNode.put("namespace", this.nameSpace);
            this.schemaObjectNode.put("type", "record");
            this.schemaObjectNode.put("name", this.recordName);
            this.schemaObjectNode.put("doc", this.docValue);
            ArrayNode fieldNodes = mapper.createArrayNode();
            for (IAvroOutputField iAvroOutputField : this.fields) {
                if (iAvroOutputField.getAvroType() == null) {
                    throw new RuntimeException("Field: " + iAvroOutputField.getFormatFieldName() + " has undefined type. ");
                }
                AvroSpec.DataType type = iAvroOutputField.getAvroType();
                ObjectNode fieldNode = mapper.createObjectNode();
                fieldNode.put("name", iAvroOutputField.getFormatFieldName());
                if (type.isPrimitiveType()) {
                    if (iAvroOutputField.getAllowNull()) {
                        ArrayNode arrayNode = mapper.createArrayNode().add(AvroSpec.DataType.NULL.getType());
                        arrayNode.add(type.getType());
                        fieldNode.putPOJO("type", (Object)arrayNode);
                    } else {
                        fieldNode.put("type", type.getType());
                    }
                } else {
                    ObjectNode typeNode = mapper.createObjectNode();
                    typeNode.put("logicalType", type.getLogicalType());
                    typeNode.put("type", type.getBaseType());
                    if (AvroSpec.DataType.DECIMAL == type) {
                        typeNode.put("precision", iAvroOutputField.getPrecision());
                        typeNode.put("scale", iAvroOutputField.getScale());
                    }
                    if (iAvroOutputField.getAllowNull()) {
                        ArrayNode arrayNode = mapper.createArrayNode().add(AvroSpec.DataType.NULL.getType());
                        arrayNode.add((JsonNode)typeNode);
                        fieldNode.set("type", (JsonNode)arrayNode);
                    } else {
                        fieldNode.set("type", (JsonNode)typeNode);
                    }
                }
                if (iAvroOutputField.getDefaultValue() != null) {
                    fieldNode.put("default", iAvroOutputField.getDefaultValue());
                }
                fieldNodes.add((JsonNode)fieldNode);
            }
            this.schemaObjectNode.putPOJO("fields", (Object)fieldNodes);
        }
        return this.schemaObjectNode;
    }

    protected void writeAvroSchemaToFile(String schemaFilename) throws KettleFileException, IOException {
        ObjectNode schemaObjectNode = this.getSchemaObjectNode();
        if (schemaObjectNode != null && schemaFilename != null) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
            writer.writeValue(KettleVFS.getOutputStream((String)schemaFilename, (boolean)false), (Object)schemaObjectNode);
        }
    }
}

