/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableCalc;
import org.apache.calcite.adapter.enumerable.EnumerableFilter;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;

public class EnumerableFilterToCalcRule
extends RelOptRule {
    EnumerableFilterToCalcRule() {
        super(EnumerableFilterToCalcRule.operand(EnumerableFilter.class, EnumerableFilterToCalcRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        EnumerableFilter filter = (EnumerableFilter)call.rel(0);
        RelNode rel = filter.getInput();
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RelDataType inputRowType = rel.getRowType();
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        programBuilder.addIdentity();
        programBuilder.addCondition(filter.getCondition());
        RexProgram program = programBuilder.getProgram();
        EnumerableCalc calc = new EnumerableCalc(filter.getCluster(), filter.getTraitSet(), rel, program, (List<RelCollation>)ImmutableList.of());
        call.transformTo(calc);
    }
}

