/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.DelegatingScope;
import org.apache.calcite.sql.validate.SqlMoniker;
import org.apache.calcite.sql.validate.SqlMonikerImpl;
import org.apache.calcite.sql.validate.SqlMonikerType;
import org.apache.calcite.sql.validate.SqlValidatorNamespace;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorTable;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListScope
extends DelegatingScope {
    protected final List<Pair<String, SqlValidatorNamespace>> children = new ArrayList<Pair<String, SqlValidatorNamespace>>();

    public ListScope(SqlValidatorScope parent) {
        super(parent);
    }

    @Override
    public void addChild(SqlValidatorNamespace ns, String alias) {
        assert (alias != null);
        this.children.add(Pair.of(alias, ns));
    }

    public List<SqlValidatorNamespace> getChildren() {
        return Pair.right(this.children);
    }

    protected SqlValidatorNamespace getChild(String alias) {
        if (alias == null) {
            if (this.children.size() != 1) {
                throw Util.newInternal("no alias specified, but more than one table in from list");
            }
            return (SqlValidatorNamespace)this.children.get((int)0).right;
        }
        int i = this.validator.catalogReader.match(Pair.left(this.children), alias);
        if (i >= 0) {
            return (SqlValidatorNamespace)this.children.get((int)i).right;
        }
        return null;
    }

    protected SqlValidatorNamespace getChild(List<String> names) {
        int i = this.findChild(names);
        return i < 0 ? null : (SqlValidatorNamespace)this.children.get((int)i).right;
    }

    protected int findChild(List<String> names) {
        for (int i = 0; i < this.children.size(); ++i) {
            SqlValidatorTable table2;
            SqlValidatorTable table;
            Pair<String, SqlValidatorNamespace> child = this.children.get(i);
            if (child.left != null) {
                if (!this.validator.catalogReader.matches((String)child.left, Util.last(names))) continue;
                if (names.size() == 1) {
                    return i;
                }
            }
            if ((table = ((SqlValidatorNamespace)child.right).getTable()) == null || (table2 = this.validator.catalogReader.getTable(names)) == null || !table.getQualifiedName().equals(table2.getQualifiedName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void findAllColumnNames(List<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            this.addColumnNames((SqlValidatorNamespace)pair.right, result);
        }
        this.parent.findAllColumnNames(result);
    }

    @Override
    public void findAliases(Collection<SqlMoniker> result) {
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            result.add(new SqlMonikerImpl((String)pair.left, SqlMonikerType.TABLE));
        }
        this.parent.findAliases(result);
    }

    @Override
    public Pair<String, SqlValidatorNamespace> findQualifyingTableName(String columnName, SqlNode ctx) {
        int count = 0;
        Pair<String, SqlValidatorNamespace> tableName = null;
        for (Pair<String, SqlValidatorNamespace> child : this.children) {
            RelDataType rowType = ((SqlValidatorNamespace)child.right).getRowType();
            if (this.validator.catalogReader.field(rowType, columnName) == null) continue;
            tableName = child;
            ++count;
        }
        switch (count) {
            case 0: {
                return this.parent.findQualifyingTableName(columnName, ctx);
            }
            case 1: {
                return tableName;
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }

    @Override
    public SqlValidatorNamespace resolve(List<String> names, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        int i = this.findChild(names);
        if (i >= 0) {
            if (ancestorOut != null) {
                ancestorOut[0] = this;
            }
            if (offsetOut != null) {
                offsetOut[0] = i;
            }
            return (SqlValidatorNamespace)this.children.get((int)i).right;
        }
        return this.parent.resolve(names, ancestorOut, offsetOut);
    }

    @Override
    public RelDataType resolveColumn(String columnName, SqlNode ctx) {
        int found = 0;
        RelDataType type = null;
        for (Pair<String, SqlValidatorNamespace> pair : this.children) {
            SqlValidatorNamespace childNs = (SqlValidatorNamespace)pair.right;
            RelDataType childRowType = childNs.getRowType();
            RelDataTypeField field = this.validator.catalogReader.field(childRowType, columnName);
            if (field == null) continue;
            ++found;
            type = field.getType();
        }
        switch (found) {
            case 0: {
                return null;
            }
            case 1: {
                return type;
            }
        }
        throw this.validator.newValidationError(ctx, Static.RESOURCE.columnAmbiguous(columnName));
    }
}

