/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUserDefinedTableMacro
extends SqlFunction {
    private final TableMacro tableMacro;

    public SqlUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, TableMacro tableMacro) {
        super(Util.last(opName.names), opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
        this.tableMacro = tableMacro;
    }

    public TranslatableTable getTable(RelDataTypeFactory typeFactory, List<SqlNode> operandList) {
        List<Object> arguments = SqlUserDefinedTableMacro.convertArguments(typeFactory, operandList, this.tableMacro, this.getNameAsId(), true);
        return this.tableMacro.apply(arguments);
    }

    public static List<Object> convertArguments(RelDataTypeFactory typeFactory, List<SqlNode> operandList, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        ArrayList<Object> arguments = new ArrayList<Object>(operandList.size());
        for (Pair<FunctionParameter, SqlNode> pair : Pair.zip(function.getParameters(), operandList)) {
            if (SqlUtil.isNullLiteral((SqlNode)pair.right, true)) {
                arguments.add(null);
                continue;
            }
            if (SqlUtil.isLiteral((SqlNode)pair.right)) {
                Object o = ((SqlLiteral)pair.right).getValue();
                Object o2 = SqlUserDefinedTableMacro.coerce(o, ((FunctionParameter)pair.left).getType(typeFactory));
                arguments.add(o2);
                continue;
            }
            arguments.add(null);
            if (!failOnNonLiteral) continue;
            throw new IllegalArgumentException("All arguments of call to macro " + opName + " should be literal. Actual argument #" + ((FunctionParameter)pair.left).getOrdinal() + " (" + ((FunctionParameter)pair.left).getName() + ") is not literal: " + pair.right);
        }
        return arguments;
    }

    private static Object coerce(Object o, RelDataType type) {
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            return null;
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = RexToLixTranslator.convert((Expression)Expressions.constant((Object)o), clazz);
        bb.add((Statement)Expressions.return_(null, (Expression)expr));
        FunctionExpression convert = Expressions.lambda((BlockStatement)bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }
}

