/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XConfiguration;

public class OozieJobInfo {
    public static final String BUNDLE_ID = "bundle.id";
    public static final String BUNDLE_NAME = "bundle.name";
    public static final String COORD_NAME = "coord.name";
    public static final String COORD_ID = "coord.id";
    public static final String COORD_NOMINAL_TIME = "coord.nominal.time";
    public static final String WORKFLOW_ID = "wf.id";
    public static final String WORKFLOW_NAME = "wf.name";
    public static final String WORKFLOW_DEPTH = "wf.depth";
    public static final String WORKFLOW_SUPER_PARENT = "wf.superparent.id";
    public static final String ACTION_TYPE = "action.type";
    public static final String ACTION_NAME = "action.name";
    public static final String JOB_INFO_KEY = "oozie.job.info";
    public static final String CONF_JOB_INFO = "oozie.action.jobinfo.enable";
    public static final String SEPARATOR = ",";
    private ActionExecutor.Context context;
    XConfiguration contextConf;
    private WorkflowAction action;
    private Configuration actionConf;
    private static boolean jobInfo = ConfigurationService.getBoolean("oozie.action.jobinfo.enable");

    public OozieJobInfo(Configuration actionConf, ActionExecutor.Context context, WorkflowAction action) throws IOException {
        this.context = context;
        this.contextConf = new XConfiguration(new StringReader(context.getWorkflow().getConf()));
        this.action = action;
        this.actionConf = actionConf;
    }

    public static boolean isJobInfoEnabled() {
        return jobInfo;
    }

    @VisibleForTesting
    public static void setJobInfo(boolean jobInfo) {
        OozieJobInfo.jobInfo = jobInfo;
    }

    public String getJobInfo() throws IOException {
        StringBuffer sb = new StringBuffer();
        this.addBundleInfo(sb);
        this.addCoordInfo(sb);
        this.addWorkflowInfo(sb);
        this.addActionInfo(sb);
        this.addCustomInfo(sb);
        return sb.toString();
    }

    private void addBundleInfo(StringBuffer sb) throws IOException {
        this.addJobInfo(sb, BUNDLE_ID, this.contextConf.get("oozie.bundle.id"));
        this.addJobInfo(sb, BUNDLE_NAME, this.contextConf.get(BUNDLE_NAME));
    }

    private void addCoordInfo(StringBuffer sb) throws IOException {
        this.addJobInfo(sb, COORD_NAME, this.contextConf.get(COORD_NAME));
        this.addJobInfo(sb, COORD_NOMINAL_TIME, this.contextConf.get(COORD_NOMINAL_TIME));
        this.addJobInfo(sb, COORD_ID, this.contextConf.get(COORD_ID));
    }

    private void addWorkflowInfo(StringBuffer sb) {
        this.addJobInfo(sb, WORKFLOW_ID, this.context.getWorkflow().getId());
        this.addJobInfo(sb, WORKFLOW_NAME, this.context.getWorkflow().getAppName());
        this.addJobInfo(sb, WORKFLOW_DEPTH, this.contextConf.get("oozie.action.subworkflow.depth", "0"));
        this.addJobInfo(sb, WORKFLOW_SUPER_PARENT, this.computeSuperParent());
    }

    private void addActionInfo(StringBuffer sb) {
        this.addJobInfo(sb, ACTION_NAME, this.action.getName());
        this.addJobInfo(sb, ACTION_TYPE, this.action.getType());
    }

    private void addCustomInfo(StringBuffer sb) throws IOException {
        this.addfromConf(this.actionConf, sb);
    }

    public void addfromConf(Configuration conf, StringBuffer sb) {
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith("oozie.job.info.")) continue;
            this.addJobInfo(sb, ((String)entry.getKey()).substring("oozie.job.info.".length()), (String)entry.getValue());
        }
    }

    private void addJobInfo(StringBuffer sb, String key, String value) {
        if (value != null) {
            sb.append(key).append("=").append(value).append(SEPARATOR);
        }
    }

    private String computeSuperParent() {
        String superParentId = this.contextConf.get("oozie.wf.superparent.id");
        if (superParentId == null) {
            if (this.context.getWorkflow().getParentId() != null) {
                return this.context.getWorkflow().getParentId();
            }
            return this.context.getWorkflow().getId();
        }
        return superParentId;
    }
}

