/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class BundleJobsGetPausedJPAExecutor
implements JPAExecutor<List<BundleJobBean>> {
    private int limit;

    public BundleJobsGetPausedJPAExecutor(int limit) {
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "BundleJobsGetPausedJPAExecutor";
    }

    @Override
    public List<BundleJobBean> execute(EntityManager em) throws JPAExecutorException {
        List bjBeans;
        try {
            Query q = em.createNamedQuery("GET_BUNDLE_JOBS_PAUSED");
            if (this.limit > 0) {
                q.setMaxResults(this.limit);
            }
            bjBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return bjBeans;
    }
}

