/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class RSyntaxUtilities
implements SwingConstants {
    private static final int LETTER_MASK = 2;
    private static final int HEX_CHARACTER_MASK = 16;
    private static final int LETTER_OR_DIGIT_MASK = 32;
    private static final int BRACKET_MASK = 64;
    private static final int JAVA_OPERATOR_MASK = 128;
    private static final int[] dataTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 128, 0, 0, 0, 128, 128, 0, 64, 64, 128, 128, 0, 128, 0, 128, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 128, 0, 128, 128, 128, 128, 0, 58, 58, 58, 58, 58, 58, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 64, 0, 64, 128, 0, 0, 50, 50, 50, 50, 50, 50, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 64, 128, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Segment charSegment = new Segment();
    private static final char[] JS_KEYWORD_RETURN = new char[]{'r', 'e', 't', 'u', 'r', 'n'};

    public static Map getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static Color getFoldedLineBottomColor(RSyntaxTextArea rSyntaxTextArea) {
        Color color = Color.gray;
        Gutter gutter = RSyntaxUtilities.getGutter(rSyntaxTextArea);
        if (gutter != null) {
            color = gutter.getFoldIndicatorForeground();
        }
        return color;
    }

    public static Gutter getGutter(RTextArea rTextArea) {
        Gutter gutter = null;
        Container container = rTextArea.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane rTextScrollPane = (RTextScrollPane)container;
            gutter = rTextScrollPane.getGutter();
        }
        return gutter;
    }

    public static String getLeadingWhitespace(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && RSyntaxUtilities.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    private static final Element getLineElem(Document document, int n) {
        int n2;
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    public static Rectangle getLineWidthUpTo(RSyntaxTextArea rSyntaxTextArea, Segment segment, int n, int n2, TabExpander tabExpander, Rectangle rectangle, int n3) throws BadLocationException {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        if (n < 0) {
            throw new BadLocationException("Invalid document position", n);
        }
        if (n2 > rSyntaxDocument.getLength()) {
            throw new BadLocationException("Invalid document position", n2);
        }
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n4 = element.getElementIndex(n);
        if (Math.abs(n4 - element.getElementIndex(n2)) > 1) {
            throw new IllegalArgumentException("p0 and p1 are not on the same line (" + n + ", " + n2 + ").");
        }
        Token token = rSyntaxDocument.getTokenListForLine(n4);
        RSyntaxUtilities.makeTokenListStartAt(token, n, tabExpander, rSyntaxTextArea, 0.0f);
        rectangle = token.listOffsetToView(rSyntaxTextArea, tabExpander, n2, n3, rectangle);
        return rectangle;
    }

    public static int getMatchingBracketPosition(RSyntaxTextArea rSyntaxTextArea) {
        try {
            int n = rSyntaxTextArea.getCaretPosition() - 1;
            if (n > -1) {
                boolean bl;
                char c;
                Token token;
                int n2;
                int n3;
                Element element;
                int n4;
                Element element2;
                RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
                char c2 = rSyntaxDocument.charAt(n);
                switch (c2) {
                    case '(': 
                    case '[': 
                    case '{': {
                        element2 = rSyntaxDocument.getDefaultRootElement();
                        n4 = element2.getElementIndex(n);
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                        token = rSyntaxDocument.getTokenListForLine(n4);
                        token = RSyntaxUtilities.getTokenAtOffset(token, n);
                        if (token.type != 22) {
                            return -1;
                        }
                        c = c2 == '{' ? (char)'}' : (c2 == '(' ? (char)')' : ']');
                        bl = true;
                        break;
                    }
                    case ')': 
                    case ']': 
                    case '}': {
                        element2 = rSyntaxDocument.getDefaultRootElement();
                        n4 = element2.getElementIndex(n);
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                        token = rSyntaxDocument.getTokenListForLine(n4);
                        token = RSyntaxUtilities.getTokenAtOffset(token, n);
                        if (token.type != 22) {
                            return -1;
                        }
                        c = c2 == '}' ? (char)'{' : (c2 == ')' ? (char)'(' : '[');
                        bl = false;
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                if (bl) {
                    int n5 = element2.getElementCount();
                    n3 = n + 1;
                    int n6 = 0;
                    boolean bl2 = false;
                    while (true) {
                        int n7;
                        rSyntaxDocument.getText(n3, n2 - n3, charSegment);
                        for (int i = n7 = RSyntaxUtilities.charSegment.offset; i < n7 + RSyntaxUtilities.charSegment.count; ++i) {
                            int n8;
                            char c3 = RSyntaxUtilities.charSegment.array[i];
                            if (c3 == c2) {
                                if (!bl2) {
                                    token = rSyntaxDocument.getTokenListForLine(n4);
                                    bl2 = true;
                                }
                                n8 = n3 + (i - n7);
                                token = RSyntaxUtilities.getTokenAtOffset(token, n8);
                                if (token.type != 22) continue;
                                ++n6;
                                continue;
                            }
                            if (c3 != c) continue;
                            if (!bl2) {
                                token = rSyntaxDocument.getTokenListForLine(n4);
                                bl2 = true;
                            }
                            n8 = n3 + (i - n7);
                            token = RSyntaxUtilities.getTokenAtOffset(token, n8);
                            if (token.type != 22) continue;
                            if (n6 == 0) {
                                if (rSyntaxTextArea.isCodeFoldingEnabled() && rSyntaxTextArea.getFoldManager().isLineHidden(n4)) {
                                    return -1;
                                }
                                return n8;
                            }
                            --n6;
                        }
                        if (++n4 == n5) {
                            return -1;
                        }
                        bl2 = false;
                        element = element2.getElement(n4);
                        n3 = element.getStartOffset();
                        n2 = element.getEndOffset();
                    }
                }
                n2 = n;
                int n9 = 0;
                boolean bl3 = false;
                while (true) {
                    int n10;
                    rSyntaxDocument.getText(n3, n2 - n3, charSegment);
                    int n11 = RSyntaxUtilities.charSegment.offset;
                    for (int i = n10 = n11 + RSyntaxUtilities.charSegment.count - 1; i >= n11; --i) {
                        Token token2;
                        int n12;
                        char c4 = RSyntaxUtilities.charSegment.array[i];
                        if (c4 == c2) {
                            if (!bl3) {
                                token = rSyntaxDocument.getTokenListForLine(n4);
                                bl3 = true;
                            }
                            n12 = n3 + (i - n11);
                            token2 = RSyntaxUtilities.getTokenAtOffset(token, n12);
                            if (token2.type != 22) continue;
                            ++n9;
                            continue;
                        }
                        if (c4 != c) continue;
                        if (!bl3) {
                            token = rSyntaxDocument.getTokenListForLine(n4);
                            bl3 = true;
                        }
                        n12 = n3 + (i - n11);
                        token2 = RSyntaxUtilities.getTokenAtOffset(token, n12);
                        if (token2.type != 22) continue;
                        if (n9 == 0) {
                            return n12;
                        }
                        --n9;
                    }
                    if (--n4 == -1) {
                        return -1;
                    }
                    bl3 = false;
                    element = element2.getElement(n4);
                    n3 = element.getStartOffset();
                    n2 = element.getEndOffset();
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return -1;
    }

    public static int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, View view) throws BadLocationException {
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)view.getContainer();
        biasArray[0] = Position.Bias.Forward;
        switch (n2) {
            case 1: 
            case 5: {
                Rectangle rectangle;
                if (n == -1) {
                    n = n2 == 1 ? Math.max(0, view.getEndOffset() - 1) : view.getStartOffset();
                    break;
                }
                Caret caret = rSyntaxTextArea != null ? rSyntaxTextArea.getCaret() : null;
                Point point = caret != null ? caret.getMagicCaretPosition() : null;
                int n3 = point == null ? ((rectangle = rSyntaxTextArea.modelToView(n)) == null ? 0 : rectangle.x) : point.x;
                if (n2 == 1) {
                    n = RSyntaxUtilities.getPositionAbove(rSyntaxTextArea, n, n3, (TabExpander)((Object)view));
                    break;
                }
                n = RSyntaxUtilities.getPositionBelow(rSyntaxTextArea, n, n3, (TabExpander)((Object)view));
                break;
            }
            case 7: {
                FoldManager foldManager;
                int n4;
                int n5;
                if (n == -1) {
                    n = Math.max(0, view.getEndOffset() - 1);
                    break;
                }
                n = Math.max(0, n - 1);
                if (!rSyntaxTextArea.isCodeFoldingEnabled() || (n5 = rSyntaxTextArea.getLineOfOffset(n + 1)) == (n4 = rSyntaxTextArea.getLineOfOffset(n)) || !(foldManager = rSyntaxTextArea.getFoldManager()).isLineHidden(n4)) break;
                while (--n4 > 0 && foldManager.isLineHidden(n4)) {
                }
                n = rSyntaxTextArea.getLineEndOffset(n4) - 1;
                break;
            }
            case 3: {
                FoldManager foldManager;
                int n6;
                int n7;
                if (n == -1) {
                    n = view.getStartOffset();
                    break;
                }
                n = Math.min(n + 1, view.getDocument().getLength());
                if (!rSyntaxTextArea.isCodeFoldingEnabled() || (n7 = rSyntaxTextArea.getLineOfOffset(n - 1)) == (n6 = rSyntaxTextArea.getLineOfOffset(n)) || !(foldManager = rSyntaxTextArea.getFoldManager()).isLineHidden(n6)) break;
                int n8 = rSyntaxTextArea.getLineCount();
                while (++n6 < n8 && foldManager.isLineHidden(n6)) {
                }
                n = n6 == n8 ? rSyntaxTextArea.getLineEndOffset(n7) - 1 : rSyntaxTextArea.getLineStartOffset(n6);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }

    public static final int getPositionAbove(RSyntaxTextArea rSyntaxTextArea, int n, float f, TabExpander tabExpander) throws BadLocationException {
        TokenOrientedView tokenOrientedView = (TokenOrientedView)((Object)tabExpander);
        Token token = tokenOrientedView.getTokenListForPhysicalLineAbove(n);
        if (token == null) {
            return -1;
        }
        if (token.type == 0) {
            int n2 = rSyntaxTextArea.getLineOfOffset(n);
            return rSyntaxTextArea.getLineStartOffset(n2 - 1);
        }
        return token.getListOffset(rSyntaxTextArea, tabExpander, 0.0f, f);
    }

    public static final int getPositionBelow(RSyntaxTextArea rSyntaxTextArea, int n, float f, TabExpander tabExpander) throws BadLocationException {
        TokenOrientedView tokenOrientedView = (TokenOrientedView)((Object)tabExpander);
        Token token = tokenOrientedView.getTokenListForPhysicalLineBelow(n);
        if (token == null) {
            return -1;
        }
        if (token.type == 0) {
            int n2 = rSyntaxTextArea.getLineOfOffset(n);
            FoldManager foldManager = rSyntaxTextArea.getFoldManager();
            n2 = foldManager.getVisibleLineBelow(n2);
            return rSyntaxTextArea.getLineStartOffset(n2);
        }
        return token.getListOffset(rSyntaxTextArea, tabExpander, 0.0f, f);
    }

    public static final Token getTokenAtOffset(Token token, int n) {
        for (Token token2 = token; token2 != null; token2 = token2.getNextToken()) {
            if (!token2.containsPosition(n)) continue;
            return token2;
        }
        return null;
    }

    public static int getWordEnd(RSyntaxTextArea rSyntaxTextArea, int n) throws BadLocationException {
        Document document = rSyntaxTextArea.getDocument();
        int n2 = rSyntaxTextArea.getLineEndOffsetOfCurrentLine();
        int n3 = Math.min(n2, document.getLength());
        if (n == n3) {
            return n;
        }
        String string = document.getText(n, n3 - n - 1);
        if (string != null && string.length() > 0) {
            int n4 = 0;
            int n5 = string.length();
            char c = string.charAt(n4);
            if (Character.isWhitespace(c)) {
                while (n4 < n5 && Character.isWhitespace(string.charAt(n4++))) {
                }
            } else if (Character.isLetterOrDigit(c)) {
                while (n4 < n5 && Character.isLetterOrDigit(string.charAt(n4++))) {
                }
            } else {
                n4 = 2;
            }
            n += n4 - 1;
        }
        return n;
    }

    public static int getWordStart(RSyntaxTextArea rSyntaxTextArea, int n) throws BadLocationException {
        Document document = rSyntaxTextArea.getDocument();
        Element element = RSyntaxUtilities.getLineElem(document, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        if (n == n2) {
            return n;
        }
        int n3 = Math.min(n + 1, document.getLength());
        String string = document.getText(n2, n3 - n2);
        if (string != null && string.length() > 0) {
            int n4 = string.length() - 1;
            char c = string.charAt(n4);
            if (Character.isWhitespace(c)) {
                while (n4 > 0 && Character.isWhitespace(string.charAt(n4 - 1))) {
                    --n4;
                }
                n = n2 + n4;
            } else if (Character.isLetterOrDigit(c)) {
                while (n4 > 0 && Character.isLetterOrDigit(string.charAt(n4 - 1))) {
                    --n4;
                }
                n = n2 + n4;
            }
        }
        return n;
    }

    public static final float getTokenListWidth(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return RSyntaxUtilities.getTokenListWidth(token, rSyntaxTextArea, tabExpander, 0.0f);
    }

    public static final float getTokenListWidth(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            f2 += token2.getWidth(rSyntaxTextArea, tabExpander, f2);
        }
        return f2 - f;
    }

    public static final float getTokenListWidthUpTo(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, int n) {
        float f2 = 0.0f;
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            if (token2.containsPosition(n)) {
                return f2 + token2.getWidthUpTo(n - token2.offset, rSyntaxTextArea, tabExpander, f + f2);
            }
            f2 += token2.getWidth(rSyntaxTextArea, tabExpander, f + f2);
        }
        return f2;
    }

    public static final boolean isBracket(char c) {
        return c <= '}' && (dataTable[c] & 0x40) > 0;
    }

    public static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean isHexCharacter(char c) {
        return c <= 'f' && (dataTable[c] & 0x10) > 0;
    }

    public static final boolean isJavaOperator(char c) {
        return c <= '~' && (dataTable[c] & 0x80) > 0;
    }

    public static final boolean isLetter(char c) {
        return c <= 'z' && (dataTable[c] & 2) > 0;
    }

    public static final boolean isLetterOrDigit(char c) {
        return c <= 'z' && (dataTable[c] & 0x20) > 0;
    }

    public static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public static float makeTokenListStartAt(Token token, int n, TabExpander tabExpander, RSyntaxTextArea rSyntaxTextArea, float f) {
        Token token2;
        for (token2 = token; token2 != null && token2.isPaintable() && !token2.containsPosition(n); token2 = token2.getNextToken()) {
            f += token2.getWidth(rSyntaxTextArea, tabExpander, f);
        }
        if (token2 != null && token2.isPaintable() && token2.offset != n) {
            int n2 = n - token2.offset;
            f += token2.getWidthUpTo(token2.textCount - n2 + 1, rSyntaxTextArea, tabExpander, f);
            token2.makeStartAt(n);
        }
        if (token2 != null && token2.isPaintable()) {
            token.copyFrom(token2);
        } else {
            token = null;
        }
        token2 = null;
        return f;
    }

    public static boolean regexCanFollowInJavaScript(Token token) {
        char c;
        return token == null || token.textCount == 1 && ((c = token.text[token.textOffset]) == '=' || c == '(' || c == ',' || c == '?' || c == ':' || c == '[' || c == '!' || c == '&') || token.type == 23 && token.text[token.textCount - 1] == '=' || token.is(6, JS_KEYWORD_RETURN);
    }

    public static final char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c | 0x20);
        }
        return c;
    }
}

