/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RegExReplaceInfo;

public class SearchEngine {
    private SearchEngine() {
    }

    public static boolean find(JTextArea jTextArea, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        if (string == null || string.length() == 0) {
            return false;
        }
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        String string2 = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!bl4) {
            int n2 = SearchEngine.getNextMatchPos(string, string2, bl, bl2, bl3);
            string2 = null;
            if (n2 != -1) {
                caret.setSelectionVisible(true);
                n2 = bl ? n + n2 : n2;
                SearchEngine.selectAndPossiblyCenter(jTextArea, n2, n2 + string.length());
                return true;
            }
        } else {
            Point point = SearchEngine.getNextMatchPosRegEx(string, string2, bl, bl2, bl3);
            string2 = null;
            if (point != null) {
                caret.setSelectionVisible(true);
                if (bl) {
                    point.translate(n, n);
                }
                SearchEngine.selectAndPossiblyCenter(jTextArea, point.x, point.y);
                return true;
            }
        }
        return false;
    }

    protected static String getFindInText(JTextArea jTextArea, int n, boolean bl) {
        String string = null;
        if (bl) {
            try {
                string = jTextArea.getText(n, jTextArea.getDocument().getLength() - n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            try {
                string = jTextArea.getText(0, n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    protected static List getMatches(Matcher matcher, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            Point point = new Point(matcher.start(), matcher.end());
            if (string == null) {
                arrayList.add(point);
                continue;
            }
            arrayList.add(new RegExReplaceInfo(matcher.group(0), point.x, point.y, SearchEngine.getReplacementText(matcher, string)));
        }
        return arrayList;
    }

    public static final int getNextMatchPos(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            return SearchEngine.getNextMatchPosImpl(string.toLowerCase(), string2.toLowerCase(), bl, bl2, bl3);
        }
        return SearchEngine.getNextMatchPosImpl(string, string2, bl, bl2, bl3);
    }

    protected static final int getNextMatchPosImpl(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            int n = string.length();
            int n2 = bl ? 0 : string2.length();
            int n3 = bl ? 1 : -1;
            while ((n2 = bl ? string2.indexOf(string, n2) : string2.lastIndexOf(string, n2)) != -1) {
                if (SearchEngine.isWholeWord(string2, n2, n)) {
                    return n2;
                }
                n2 += n3;
            }
            return n2;
        }
        return bl ? string2.indexOf(string) : string2.lastIndexOf(string);
    }

    public static Point getNextMatchPosRegEx(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(string, charSequence, bl, bl2, bl3, null);
    }

    protected static Object getNextMatchPosRegExImpl(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3, String string2) {
        if (bl3) {
            string = "\\b" + string + "\\b";
        }
        int n = 8;
        Pattern pattern = Pattern.compile(string, n |= bl2 ? 0 : 66);
        Matcher matcher = pattern.matcher(charSequence);
        if (bl) {
            if (matcher.find()) {
                if (string2 == null) {
                    return new Point(matcher.start(), matcher.end());
                }
                return new RegExReplaceInfo(matcher.group(0), matcher.start(), matcher.end(), SearchEngine.getReplacementText(matcher, string2));
            }
        } else {
            List list = SearchEngine.getMatches(matcher, string2);
            if (!list.isEmpty()) {
                return list.get(list.size() - 1);
            }
        }
        return null;
    }

    protected static RegExReplaceInfo getRegExReplaceInfo(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        if (string3 == null) {
            string3 = "";
        }
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(string, string2, bl, bl2, bl3, string3);
    }

    public static String getReplacementText(Matcher matcher, CharSequence charSequence) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (c == '\\') {
                c = charSequence.charAt(++n);
                switch (c) {
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                    }
                }
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                int n2;
                int n3;
                if ((n3 = charSequence.charAt(++n) - 48) < 0 || n3 > 9) {
                    throw new IndexOutOfBoundsException("No group " + charSequence.charAt(n));
                }
                ++n;
                boolean bl = false;
                while (!bl && n < charSequence.length() && (n2 = charSequence.charAt(n) - 48) >= 0 && n2 <= 9) {
                    int n4 = n3 * 10 + n2;
                    if (matcher.groupCount() < n4) {
                        bl = true;
                        continue;
                    }
                    n3 = n4;
                    ++n;
                }
                if (matcher.group(n3) == null) continue;
                stringBuffer.append(matcher.group(n3));
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final boolean isWholeWord(CharSequence charSequence, int n, int n2) {
        boolean bl;
        boolean bl2;
        try {
            bl2 = !Character.isLetterOrDigit(charSequence.charAt(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl2 = true;
        }
        try {
            bl = !Character.isLetterOrDigit(charSequence.charAt(n + n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        return bl2 && bl;
    }

    protected static int makeMarkAndDotEqual(JTextArea jTextArea, boolean bl) {
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.min(caret.getDot(), caret.getMark()) : Math.max(caret.getDot(), caret.getMark());
        caret.setDot(n);
        return n;
    }

    protected static boolean regexReplace(JTextArea jTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws PatternSyntaxException {
        Caret caret = jTextArea.getCaret();
        int n = SearchEngine.makeMarkAndDotEqual(jTextArea, bl);
        String string3 = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string3 == null) {
            return false;
        }
        RegExReplaceInfo regExReplaceInfo = SearchEngine.getRegExReplaceInfo(string, string3, bl, bl2, bl3, string2);
        string3 = null;
        if (regExReplaceInfo != null) {
            caret.setSelectionVisible(true);
            int n2 = regExReplaceInfo.getStartIndex();
            int n3 = regExReplaceInfo.getEndIndex();
            if (bl) {
                n2 += n;
                n3 += n;
            }
            SearchEngine.selectAndPossiblyCenter(jTextArea, n2, n3);
            jTextArea.replaceSelection(regExReplaceInfo.getReplacement());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(RTextArea rTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws PatternSyntaxException {
        if (string == null || string.length() == 0) {
            return false;
        }
        rTextArea.beginAtomicEdit();
        try {
            if (bl4) {
                boolean bl5 = SearchEngine.regexReplace(rTextArea, string, string2, bl, bl2, bl3);
                return bl5;
            }
            SearchEngine.makeMarkAndDotEqual(rTextArea, bl);
            if (SearchEngine.find(rTextArea, string, bl, bl2, bl3, false)) {
                rTextArea.replaceSelection(string2);
                boolean bl6 = true;
                return bl6;
            }
        }
        finally {
            rTextArea.endAtomicEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceAll(RTextArea rTextArea, String string, String string2, boolean bl, boolean bl2, boolean bl3) throws PatternSyntaxException {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 0;
        rTextArea.beginAtomicEdit();
        try {
            if (bl3) {
                if (string2 == null) {
                    string2 = "";
                }
                int n2 = rTextArea.getCaretPosition();
                rTextArea.setCaretPosition(0);
                int n3 = 8;
                Pattern pattern = Pattern.compile(string, n3 |= bl ? 0 : 66);
                while (SearchEngine.find(rTextArea, string, true, bl, bl2, true)) {
                    Matcher matcher = pattern.matcher(rTextArea.getSelectedText());
                    String string3 = SearchEngine.getReplacementText(matcher, string2);
                    rTextArea.replaceSelection(string3);
                    ++n;
                }
                if (n == 0) {
                    rTextArea.setCaretPosition(n2);
                }
            } else {
                rTextArea.setCaretPosition(0);
                while (SearchEngine.find(rTextArea, string, true, bl, bl2, false)) {
                    rTextArea.replaceSelection(string2);
                    ++n;
                }
            }
        }
        finally {
            rTextArea.endAtomicEdit();
        }
        return n;
    }

    private static void selectAndPossiblyCenter(JTextArea jTextArea, int n, int n2) {
        jTextArea.setSelectionStart(n);
        jTextArea.setSelectionEnd(n2);
        Rectangle rectangle = null;
        try {
            rectangle = jTextArea.modelToView(n);
            if (rectangle == null) {
                return;
            }
            if (n2 != n) {
                rectangle = rectangle.union(jTextArea.modelToView(n2));
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            jTextArea.setSelectionStart(n);
            jTextArea.setSelectionEnd(n2);
            return;
        }
        Rectangle rectangle2 = jTextArea.getVisibleRect();
        if (rectangle2.contains(rectangle)) {
            jTextArea.setSelectionStart(n);
            jTextArea.setSelectionEnd(n2);
            return;
        }
        rectangle2.x = rectangle.x - (rectangle2.width - rectangle.width) / 2;
        rectangle2.y = rectangle.y - (rectangle2.height - rectangle.height) / 2;
        Rectangle rectangle3 = jTextArea.getBounds();
        Insets insets = jTextArea.getInsets();
        rectangle3.x = insets.left;
        rectangle3.y = insets.top;
        rectangle3.width -= insets.left + insets.right;
        rectangle3.height -= insets.top + insets.bottom;
        if (rectangle2.x < rectangle3.x) {
            rectangle2.x = rectangle3.x;
        }
        if (rectangle2.x + rectangle2.width > rectangle3.x + rectangle3.width) {
            rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
        }
        if (rectangle2.y < rectangle3.y) {
            rectangle2.y = rectangle3.y;
        }
        if (rectangle2.y + rectangle2.height > rectangle3.y + rectangle3.height) {
            rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
        }
        jTextArea.scrollRectToVisible(rectangle2);
    }
}

