/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.PluginSettings;
import pt.webdetails.cpf.messaging.JsonSerializable;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.XmlParserFactoryProducer;

public abstract class VersionChecker {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected PluginSettings settings;
    protected static String VERSION_FILE = "version.xml";
    private static String[] branches;

    public VersionChecker(PluginSettings pluginSettings) {
        this.settings = pluginSettings;
    }

    protected abstract String getVersionCheckUrl(Branch var1);

    public String[] getBranches() {
        return branches;
    }

    public CheckVersionResponse checkVersion() {
        Version installed = null;
        try {
            installed = this.getInstalledVersion();
        }
        catch (Exception e) {
            String msg = "Error attempting to read version.xml";
            this.logger.error((Object)msg, (Throwable)e);
            return new CheckVersionResponse(CheckVersionResponse.Type.ERROR, msg, null);
        }
        String url = this.getVersionCheckUrl(installed.getBranch());
        if (url == null) {
            String msg = "No URL found for this version.";
            this.logger.info((Object)msg);
            SAXReader reader = XmlParserFactoryProducer.getSAXReader(null);
            Version latest = null;
            try {
                Document versionXml = reader.read(this.getVersionCheckUrl(Branch.STABLE));
                latest = new Version(versionXml);
            }
            catch (DocumentException e) {
                msg = "Could not parse remote file ";
                this.logger.info((Object)msg, (Throwable)e);
                return new CheckVersionResponse(CheckVersionResponse.Type.ERROR, msg, null);
            }
            return new CheckVersionResponse(CheckVersionResponse.Type.INCONCLUSIVE, msg, latest.downloadUrl);
        }
        Version latest = null;
        try {
            SAXReader reader = XmlParserFactoryProducer.getSAXReader(null);
            Document versionXml = reader.read(url);
            latest = new Version(versionXml);
        }
        catch (DocumentException e) {
            String msg = "Could not parse remote file ";
            this.logger.info((Object)msg, (Throwable)e);
            return new CheckVersionResponse(CheckVersionResponse.Type.ERROR, msg, null);
        }
        if (installed.isSuperceededBy(latest)) {
            return new CheckVersionResponse(CheckVersionResponse.Type.UPDATE, null, latest.downloadUrl);
        }
        return new CheckVersionResponse(CheckVersionResponse.Type.LATEST, null, null);
    }

    public String getVersion() {
        try {
            Version installed = this.getInstalledVersion();
            return installed.toString();
        }
        catch (Exception e) {
            String msg = "Error attempting to read version.xml";
            this.logger.error((Object)msg, (Throwable)e);
            return "unknown version";
        }
    }

    private Version getInstalledVersion() throws DocumentException, IOException {
        Version installed = null;
        IReadAccess systemDir = PluginEnvironment.repository().getPluginSystemReader(null);
        SAXReader reader = XmlParserFactoryProducer.getSAXReader(null);
        Document versionXml = reader.read(systemDir.getFileInputStream(VERSION_FILE));
        installed = new Version(versionXml);
        return installed;
    }

    private static String getStringValue(Node node, String xpath, String defaultValue) {
        String value;
        Node valNode = node.selectSingleNode(xpath);
        if (valNode != null && !StringUtils.isEmpty((String)(value = valNode.getText()))) {
            return value;
        }
        return defaultValue;
    }

    static {
        ArrayList<String> branchList = new ArrayList<String>();
        for (Branch branch : Branch.values()) {
            branchList.add(branch.toString());
        }
        branches = branchList.toArray(new String[branchList.size()]);
    }

    public static class Version {
        private String branchStr;
        private String version;
        private String buildId;
        private String downloadUrl;
        private Branch branch;

        public Version(Document xml) {
            if (xml == null) {
                throw new IllegalArgumentException("no document");
            }
            Node versionNode = xml.selectSingleNode("//version");
            this.branchStr = VersionChecker.getStringValue(versionNode, "branch", this.branchStr);
            this.version = VersionChecker.getStringValue(versionNode, "version", this.version);
            this.buildId = VersionChecker.getStringValue(versionNode, "buildId", this.buildId);
            this.downloadUrl = VersionChecker.getStringValue(versionNode, "package_url", null);
            if (this.branchStr == null) {
                this.branchStr = VersionChecker.getStringValue(versionNode, "@branch", this.branchStr);
            }
            if (this.version == null) {
                this.version = VersionChecker.getStringValue(versionNode, "/version", this.version);
            }
            if (this.buildId == null) {
                this.buildId = VersionChecker.getStringValue(versionNode, "@buildId", this.buildId);
            }
            if (this.downloadUrl == null) {
                this.downloadUrl = VersionChecker.getStringValue(versionNode, "downloadUrl", null);
            }
        }

        public Branch getBranch() {
            if (this.branch == null) {
                if (StringUtils.equals((String)this.branchStr, (String)"TRUNK")) {
                    if (StringUtils.startsWithIgnoreCase((String)this.buildId, (String)"manual")) {
                        return Branch.LOCAL;
                    }
                    return Branch.TRUNK;
                }
                if (StringUtils.equals((String)this.branchStr, (String)"STABLE")) {
                    return Branch.STABLE;
                }
                return Branch.UNKNOWN;
            }
            return this.branch;
        }

        public boolean isSuperceededBy(Version other) {
            if (this.getBranch().equals((Object)other.getBranch())) {
                switch (this.getBranch()) {
                    case STABLE: {
                        return this.version.compareTo(other.version) < 0;
                    }
                    case TRUNK: {
                        return this.buildId.compareTo(other.buildId) < 0;
                    }
                }
                return false;
            }
            return false;
        }

        public String toString() {
            switch (this.getBranch()) {
                case LOCAL: {
                    return this.buildId;
                }
                case TRUNK: {
                    return (Object)((Object)this.getBranch()) + " build" + this.buildId;
                }
                case STABLE: {
                    return "v" + this.version;
                }
            }
            return this.getBranch().toString();
        }
    }

    public static enum Branch {
        STABLE,
        TRUNK,
        LOCAL,
        UNKNOWN;

    }

    public static class CheckVersionResponse
    implements JsonSerializable {
        private Type type;
        private String msg;
        private String url;

        public CheckVersionResponse(Type responseType, String message, String downloadUrl) {
            this.type = responseType;
            this.msg = message;
            this.url = downloadUrl;
        }

        public String getMessage() {
            return this.msg;
        }

        public Type getType() {
            return this.type;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            obj.put("result", (Object)this.type.toString().toLowerCase());
            switch (this.type) {
                case LATEST: 
                case ERROR: {
                    obj.put("msg", (Object)this.msg);
                    break;
                }
                case INCONCLUSIVE: {
                    obj.put("msg", (Object)this.msg);
                    obj.put("downloadUrl", (Object)this.url);
                    break;
                }
                case UPDATE: {
                    obj.put("downloadUrl", (Object)this.msg);
                }
            }
            return obj;
        }

        public static enum Type {
            LATEST,
            UPDATE,
            INCONCLUSIVE,
            ERROR;

        }
    }
}

