/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.persistence;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.CpfProperties;
import pt.webdetails.cpf.InvalidOperationException;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.persistence.IPersistenceEngine;
import pt.webdetails.cpf.persistence.Persistable;
import pt.webdetails.cpf.persistence.PersistenceEngineSettingsReader;
import pt.webdetails.cpf.session.PentahoSessionUtils;
import pt.webdetails.cpf.utils.CharsetHelper;

public class PersistenceEngine
implements IPersistenceEngine {
    private static final Log logger = LogFactory.getLog(PersistenceEngine.class);
    private static final CpfProperties SETTINGS = CpfProperties.getInstance();
    private static final int JSON_INDENT = 2;
    private static PersistenceEngine _instance;
    private OServer server;

    protected PersistenceEngine() {
        try {
            logger.info((Object)"Creating PersistenceEngine instance");
            this.initialize();
        }
        catch (Exception ex) {
            logger.fatal((Object)("Could not create PersistenceEngine: " + Util.getExceptionDescription((Exception)ex)));
        }
    }

    public static synchronized PersistenceEngine getInstance() {
        if (_instance == null) {
            _instance = new PersistenceEngine();
        }
        return _instance;
    }

    public static void shutdown() {
        if (_instance != null) {
            logger.info((Object)"Shutting down PersistenceEngine");
            _instance.serverShutdown();
        }
    }

    private void serverShutdown() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    protected String getOrientPath() {
        return FilenameUtils.normalize((String)FilenameUtils.separatorsToUnix((String)PentahoSystem.getApplicationContext().getSolutionPath("system/.orient/")));
    }

    private void initialize() throws Exception {
        if (SETTINGS.getBooleanProperty("LOCAL_INSTANCE", true)) {
            String orientPath = this.getOrientPath();
            File dirPath = new File(orientPath);
            if (!dirPath.exists() && !dirPath.mkdir()) {
                logger.warn((Object)"Unable to create orient support folder. Does system/.orient exist in the server filesystem?");
            }
            this.startOrient();
        }
    }

    @Override
    public String process(IParameterProvider requestParams, IPentahoSession userSession) throws InvalidOperationException {
        String methodString = requestParams.getStringParameter("method", "none");
        JSONObject reply = null;
        try {
            Method mthd = Method.valueOf(methodString.toUpperCase());
            switch (mthd) {
                case DELETE: {
                    reply = this.deleteRecord(requestParams);
                    break;
                }
                case GET: {
                    logger.error((Object)"get requests to PersistenceEngine are no longer supported. please use the SimplePersistence API.");
                    return "{'result': false}";
                }
                case STORE: {
                    reply = this.store(requestParams);
                    break;
                }
                case QUERY: {
                    PentahoSessionUtils psu = new PentahoSessionUtils();
                    if (!psu.getCurrentSession().isAdministrator()) {
                        throw new SecurityException("Arbitrary querying is only available to admins");
                    }
                    reply = this.query(requestParams);
                }
            }
            if (reply == null) {
                logger.error((Object)"Reply to request is null");
                return "{'result': false}";
            }
            return reply.toString(2);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Invalid method: " + methodString));
            return "{'result': false}";
        }
        catch (JSONException e) {
            logger.error((Object)("error processing: " + methodString));
            return "{'result': false}";
        }
    }

    private ODatabaseDocumentTx getConnection() {
        String url = SETTINGS.getProperty("ORIENT.DBURL");
        String user = SETTINGS.getProperty("ORIENT.USER");
        String password = SETTINGS.getProperty("ORIENT.PASSWORD");
        return (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(url, user, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeCommand(String query, Map<String, Object> params) {
        try (ODatabaseDocumentTx db = this.getConnection();){
            OCommandSQL preparedQuery = new OCommandSQL(query);
            if (params == null) {
                Object object = db.command((OCommandRequest)preparedQuery).execute(new Object[0]);
                return object;
            }
            Object object = db.command((OCommandRequest)preparedQuery).execute(new Object[]{params});
            return object;
        }
    }

    @Override
    public List<ODocument> executeQuery(String query, Map<String, Object> params) {
        try (ODatabaseDocumentTx db = this.getConnection();){
            OSQLSynchQuery preparedQuery = new OSQLSynchQuery(query);
            if (params == null) {
                List list = (List)db.command((OCommandRequest)preparedQuery).execute(new Object[0]);
                return list;
            }
            List list = (List)db.command((OCommandRequest)preparedQuery).execute(new Object[]{params});
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int deleteAll(String classTable) {
        int counter = 0;
        try (ODatabaseDocumentTx db = this.getConnection();){
            counter = 0;
            for (ODocument doc : db.browseClass(classTable)) {
                doc.delete();
                ++counter;
            }
        }
        return counter;
    }

    @Override
    public ODocument createDocument(String baseClass, String json) {
        ODocument doc = new ODocument(baseClass);
        doc.fromJSON(json);
        return doc;
    }

    @Override
    public ODocument createDocument(String baseClass, JSONObject json) {
        ODocument doc = new ODocument(baseClass);
        Iterator fields = json.keys();
        while (fields.hasNext()) {
            String field = (String)fields.next();
            if (field.equals("key")) continue;
            try {
                Object value = json.get(field);
                if (value instanceof JSONObject) {
                    doc.field(field, (Object)this.createDocument(baseClass + "_" + field, (JSONObject)value));
                    JSONObject obj = json.getJSONObject(field);
                    logger.debug((Object)("obj:" + obj.toString(2)));
                    continue;
                }
                doc.field(field, value);
            }
            catch (JSONException e) {
                logger.error((Object)e);
            }
        }
        return doc;
    }

    private JSONObject createJson(ODocument doc) {
        JSONObject json = new JSONObject();
        for (String field : doc.fieldNames()) {
            try {
                Object value = doc.field(field);
                if (value instanceof ODocument) {
                    ODocument docVal = (ODocument)value;
                    logger.debug((Object)("obj odoc:" + docVal.toJSON()));
                    json.put(field, (Object)this.createJson(docVal));
                    continue;
                }
                if (value == null) continue;
                logger.debug(value.getClass());
                json.put(field, value);
            }
            catch (JSONException e) {
                logger.error((Object)e);
            }
        }
        return json;
    }

    private JSONObject query(IParameterProvider requestParams) throws JSONException {
        String queryString = requestParams.getStringParameter("query", "");
        return this.query(queryString, null);
    }

    @Override
    public JSONObject query(String query, Map<String, Object> params) throws JSONException {
        JSONObject json = new JSONObject();
        try {
            json.put("result", (Object)Boolean.TRUE);
            List<ODocument> result = this.executeQuery(query, params);
            if (result != null) {
                JSONArray arr = new JSONArray();
                for (ODocument resDoc : result) {
                    arr.put((Object)new JSONObject(resDoc.toJSON()));
                }
                json.put("object", (Object)arr);
            }
        }
        catch (ODatabaseException ode) {
            json.put("result", (Object)Boolean.FALSE);
            json.put("errorMessage", (Object)"DatabaseException: Review query");
            logger.error((Object)this.getExceptionDescription((Exception)((Object)ode)));
        }
        return json;
    }

    @Override
    public JSONObject command(String query, Map<String, Object> params) throws JSONException {
        JSONObject json = new JSONObject();
        try {
            Object result = this.executeCommand(query, params);
            if (result != null) {
                json.put("result", (Object)Boolean.TRUE);
            }
        }
        catch (ODatabaseException ode) {
            json.put("result", (Object)Boolean.FALSE);
            json.put("errorMessage", (Object)"DatabaseException: Review query");
            logger.error((Object)this.getExceptionDescription((Exception)((Object)ode)));
        }
        return json;
    }

    private JSONObject deleteRecord(IParameterProvider requestParams) throws JSONException {
        String id = requestParams.getStringParameter("rid", "");
        return this.deleteRecord(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject deleteRecord(String id) throws JSONException {
        JSONObject json;
        block9: {
            json = new JSONObject();
            try (ODatabaseDocumentTx db = this.getConnection();){
                ODocument doc = (ODocument)db.getRecord((OIdentifiable)new ORecordId(id));
                if (doc == null) {
                    json.put("result", (Object)Boolean.FALSE);
                    json.put("errorMessage", (Object)("No element found with id " + id));
                    JSONObject jSONObject = json;
                    return jSONObject;
                }
                doc.delete();
                json.put("result", (Object)Boolean.TRUE);
            }
        }
        return json;
    }

    private JSONObject store(IParameterProvider requestParams) throws JSONException {
        String id = requestParams.getStringParameter("rid", "");
        String className = requestParams.getStringParameter("class", "");
        String data = requestParams.getStringParameter("data", "");
        return this.store(id, className, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeClass(String className) {
        try (ODatabaseDocumentTx database = null;){
            database = this.getConnection();
            if (this.classExists(className, database)) {
                boolean bl = false;
                return bl;
            }
            database.getMetadata().getSchema().createClass(className);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropClass(String className) {
        try (ODatabaseDocumentTx database = null;){
            database = this.getConnection();
            if (!this.classExists(className, database)) {
                boolean bl = false;
                return bl;
            }
            database.getMetadata().getSchema().dropClass(className);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean classExists(String className) {
        try (ODatabaseDocumentTx database = null;){
            database = this.getConnection();
            boolean bl = this.classExists(className, database);
            return bl;
        }
    }

    @Override
    public boolean classExists(String className, ODatabaseDocumentTx database) {
        return database.getMetadata().getSchema().getClass(className) != null;
    }

    @Override
    public JSONObject store(Persistable obj) {
        String key = obj.getKey();
        String className = obj.getClass().getName();
        try {
            JSONObject json = obj.toJSON();
            JSONObject ret = this.store(key, className, json);
            obj.setKey(ret.getString("id"));
            return ret;
        }
        catch (JSONException e) {
            return null;
        }
    }

    @Override
    public JSONObject store(String id, String className, JSONObject data) {
        return this.store(id, className, data, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized JSONObject store(String id, String className, JSONObject data, ODocument doc) {
        JSONObject json = new JSONObject();
        try (ODatabaseDocumentTx db = null;){
            ORID newId;
            block21: {
                json.put("result", (Object)Boolean.TRUE);
                db = this.getConnection();
                if (!StringUtils.isEmpty((String)id)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", id);
                    List<ODocument> result = this.executeQuery("select * from " + className + " where @rid = :id", params);
                    if (result.size() == 1) {
                        doc = result.get(0);
                        String user = this.getUserName();
                        if (doc.field("userid") != null && !doc.field("userid").toString().equals(user)) {
                            json.put("result", (Object)Boolean.FALSE);
                            json.put("errorMessage", (Object)("Object id " + id + " belongs to another user"));
                            JSONObject jSONObject = json;
                            return jSONObject;
                        }
                        this.fillDocument(doc, data);
                        break block21;
                    } else {
                        if (result.size() == 0) {
                            json.put("result", (Object)Boolean.FALSE);
                            json.put("errorMessage", (Object)("No " + className + " found with id " + id));
                            JSONObject jSONObject = json;
                            return jSONObject;
                        }
                        json.put("result", (Object)Boolean.FALSE);
                        json.put("errorMessage", (Object)("Multiple " + className + " found with id " + id));
                        JSONObject jSONObject = json;
                        return jSONObject;
                    }
                }
                if (doc == null) {
                    doc = this.createDocument(className, data, db);
                }
            }
            doc.save();
            if (id == null || id.length() == 0) {
                newId = doc.getIdentity();
                json.put("id", (Object)newId.toString());
            } else {
                json.put("id", (Object)id);
            }
            newId = json;
            return newId;
        }
        catch (JSONException e) {
            return json;
        }
    }

    private ODocument createDocument(String className, JSONObject data, ODatabaseDocumentTx db) throws JSONException {
        ODocument doc = new ODocument((ODatabaseRecord)db, className);
        this.fillDocument(doc, data);
        return doc;
    }

    private void fillDocument(ODocument doc, JSONObject data) throws JSONException {
        doc.fromJSON(data.toString(2));
        doc.field("userid", (Object)this.getUserName());
    }

    @Override
    public JSONObject store(String id, String className, String inputData) throws JSONException {
        JSONObject data = new JSONObject(inputData);
        return this.store(id, className, data);
    }

    private String getExceptionDescription(Exception ex) {
        return ex.getCause().getClass().getName() + " - " + ex.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startOrient() throws Exception {
        InputStream conf = new PersistenceEngineSettingsReader().getConfigurationInputStream();
        ODatabaseDocumentTx tx = null;
        try {
            tx = this.getConnection();
        }
        catch (Exception e) {
            String enc = CharsetHelper.getEncoding();
            String confAsString = IOUtils.toString((InputStream)conf, (String)enc);
            confAsString = confAsString.replaceAll(Matcher.quoteReplacement("$PATH$"), Matcher.quoteReplacement(this.getOrientPath()));
            conf.close();
            conf = new ByteArrayInputStream(confAsString.getBytes(enc));
            this.server = OServerMain.create();
            this.server.startup(conf);
            this.server.activate();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
            conf.close();
        }
    }

    protected String getUserName() {
        return PentahoSessionHolder.getSession().getName();
    }

    private static enum Method {
        HEAD,
        DELETE,
        GET,
        STORE,
        QUERY;

    }
}

