/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ObjectUtils;
import pt.webdetails.cpf.web.CpfRequestDispatcher;

class CpfServletContext
implements ServletContext {
    private final Log logger = LogFactory.getLog(this.getClass());
    private String resourceBasePath;
    private ResourceLoader resourceLoader;
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Hashtable attributes = new Hashtable();
    private final Properties initParameters = new Properties();
    private String servletContextName = "MockServletContext";

    public CpfServletContext() {
        this("", null);
    }

    public CpfServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public CpfServletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public CpfServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public ServletContext getContext(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMajorVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getMinorVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getMimeType(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public Set getResourcePaths(String path) {
        String actualPath = path.endsWith("/") ? path : path + "/";
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(actualPath));
        try {
            File file = resource.getFile();
            Object[] fileList = file.list();
            if (ObjectUtils.isEmpty((Object[])fileList)) {
                return null;
            }
            LinkedHashSet<String> resourcePaths = new LinkedHashSet<String>(fileList.length);
            for (int i = 0; i < fileList.length; ++i) {
                String resultPath = actualPath + (String)fileList[i];
                if (resource.createRelative((String)fileList[i]).getFile().isDirectory()) {
                    resultPath = resultPath + "/";
                }
                resourcePaths.add(resultPath);
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Couldn't get resource paths for " + resource), (Throwable)ex);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getURL();
        }
        catch (MalformedURLException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Couldn't get URL for " + resource), (Throwable)ex);
            return null;
        }
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        if (!resource.exists()) {
            return null;
        }
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Couldn't open InputStream for " + resource), (Throwable)ex);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new CpfRequestDispatcher(path);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Servlet getServlet(String string) throws ServletException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void log(String message) {
        this.logger.info((Object)message);
    }

    public void log(Exception ex, String message) {
        this.logger.info((Object)message, (Throwable)ex);
    }

    public void log(String message, Throwable ex) {
        this.logger.info((Object)message, ex);
    }

    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.warn((Object)("Couldn't determine real path of resource " + resource), (Throwable)ex);
            return null;
        }
    }

    public String getServerInfo() {
        return "CpfServletContext";
    }

    public String getInitParameter(String name) {
        return this.initParameters.getProperty(name);
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.setProperty(name, value);
    }

    public Enumeration getInitParameterNames() {
        return this.initParameters.keys();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public void setAttribute(String name, Object value) {
        if (name != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void setServletContextName() {
        this.servletContextName = this.servletContextName;
    }
}

