/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.endpoint;

import java.util.Collections;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleJobException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.exception.KettleTransException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.repo.controller.RepositoryBrowserController;
import org.pentaho.repo.model.RepositoryDirectory;
import org.pentaho.repo.model.RepositoryTree;

public class RepositoryBrowserEndpoint {
    private RepositoryBrowserController repositoryBrowserController;

    public RepositoryBrowserEndpoint(RepositoryBrowserController repositoryBrowserController) {
        this.repositoryBrowserController = repositoryBrowserController;
    }

    @GET
    @Path(value="/loadDirectoryTree{filter : (/filter)?}")
    @Produces(value={"application/json"})
    public Response loadDirectoryTree(@PathParam(value="filter") String filter) {
        RepositoryTree repositoryTree;
        if (filter.equals("false")) {
            repositoryTree = this.repositoryBrowserController.loadDirectoryTree();
        } else {
            RepositoryTree repositoryTree2 = repositoryTree = Utils.isEmpty((CharSequence)filter) ? this.repositoryBrowserController.loadDirectoryTree() : this.repositoryBrowserController.loadDirectoryTree();
        }
        if (repositoryTree != null) {
            return Response.ok((Object)repositoryTree).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/loadFile/{id}/{type}")
    public Response loadFile(@PathParam(value="id") String id, @PathParam(value="type") String type) {
        if (this.repositoryBrowserController.loadFile(id, type)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/loadFiles/{path}")
    @Produces(value={"application/json"})
    public Response loadFile(@PathParam(value="path") String path) {
        RepositoryDirectory repositoryDirectory = this.repositoryBrowserController.loadFiles(path);
        return Response.ok((Object)repositoryDirectory).build();
    }

    @GET
    @Path(value="/loadFolders/{path}")
    @Produces(value={"application/json"})
    public Response loadFolders(@PathParam(value="path") String path) {
        RepositoryDirectory repositoryDirectory = this.repositoryBrowserController.loadFolders(path);
        return Response.ok((Object)repositoryDirectory).build();
    }

    @GET
    @Path(value="/loadFilesAndFolders/{path}")
    @Produces(value={"application/json"})
    public Response loadFilesAndFolders(@PathParam(value="path") String path) {
        RepositoryDirectory repositoryDirectory = this.repositoryBrowserController.loadFilesAndFolders(path);
        return Response.ok((Object)repositoryDirectory).build();
    }

    @GET
    @Path(value="/getActiveFileName")
    public Response getActiveFileName() {
        String name = this.repositoryBrowserController.getActiveFileName();
        return Response.ok(Collections.singletonMap("fileName", name)).build();
    }

    @GET
    @Path(value="/loadRecent/{repo}/{id}")
    public Response loadRecent(@PathParam(value="repo") String repo, @PathParam(value="id") String id) {
        if (this.repositoryBrowserController.openRecentFile(repo, id)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/saveFile/{path}/{name}/{fileName}/{override}")
    public Response saveFile(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="fileName") String fileName, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.saveFile(path, name, fileName, overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/saveFile/{path}/{name}/{override}")
    public Response saveFile(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.saveFile(path, name, "", overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/checkForSecurityOrDupeIssues/{path}/{name}/{fileName}/{override}")
    public Response checkForSecurityOrDupeIssues(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="fileName") String fileName, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.checkForSecurityOrDupeIssues(path, name, fileName, overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/checkForSecurityOrDupeIssues/{path}/{name}/{override}")
    public Response checkForSecurityOrDupeIssues(@PathParam(value="path") String path, @PathParam(value="name") String name, @PathParam(value="override") String override) {
        boolean overwrite;
        boolean bl = overwrite = override != null && override.toLowerCase().equals("true");
        if (this.repositoryBrowserController.checkForSecurityOrDupeIssues(path, name, "", overwrite)) {
            return Response.ok().build();
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="/rename/{id}/{path}/{newName}/{type}/{oldName}")
    public Response rename(@PathParam(value="id") String id, @PathParam(value="path") String path, @PathParam(value="newName") String newName, @PathParam(value="type") String type, @PathParam(value="oldName") String oldName) {
        try {
            ObjectId objectId = this.repositoryBrowserController.rename(id, path, newName, type, oldName);
            if (objectId != null) {
                return Response.ok((Object)objectId).build();
            }
        }
        catch (KettleObjectExistsException koee) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (KettleJobException | KettleTransException ktje) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        catch (KettleException ke) {
            return Response.notModified().build();
        }
        return Response.notModified().build();
    }

    @GET
    @Path(value="/search/{path}/{filter}")
    @Produces(value={"application/json"})
    public Response search(@PathParam(value="path") String path, @PathParam(value="filter") String filter) {
        return Response.ok(this.repositoryBrowserController.search(path, filter)).build();
    }

    @POST
    @Path(value="/create/{parent}/{name}")
    @Produces(value={"application/json"})
    public Response rename(@PathParam(value="parent") String parent, @PathParam(value="name") String name) {
        RepositoryDirectory repositoryDirectory = this.repositoryBrowserController.create(parent, name);
        if (repositoryDirectory != null) {
            return Response.ok((Object)repositoryDirectory).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @DELETE
    @Path(value="/remove/{id}/{name}/{path}/{type}")
    public Response delete(@PathParam(value="id") String id, @PathParam(value="name") String name, @PathParam(value="path") String path, @PathParam(value="type") String type) {
        try {
            if (this.repositoryBrowserController.remove(id, name, path, type)) {
                return Response.ok().build();
            }
        }
        catch (KettleException ke) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    @GET
    @Path(value="/recentFiles")
    @Produces(value={"application/json"})
    public Response recentFiles() {
        return Response.ok(this.repositoryBrowserController.getRecentFiles()).build();
    }

    @GET
    @Path(value="/updateRecentFiles/{oldPath}/{newPath}")
    @Produces(value={"application/json"})
    public Response updateRecentFiles(@PathParam(value="oldPath") String oldPath, @PathParam(value="newPath") String newPath) {
        return Response.ok((Object)this.repositoryBrowserController.updateRecentFiles(oldPath, newPath)).build();
    }

    @GET
    @Path(value="/recentSearches")
    @Produces(value={"application/json"})
    public Response recentSearches() {
        return Response.ok((Object)this.repositoryBrowserController.getRecentSearches()).build();
    }

    @GET
    @Path(value="/storeRecentSearch/{recentSearch}")
    @Produces(value={"application/json"})
    public Response storeRecentSearch(@PathParam(value="recentSearch") String recentSearch) {
        return Response.ok((Object)this.repositoryBrowserController.storeRecentSearch(recentSearch)).build();
    }

    @GET
    @Path(value="/currentRepo")
    @Produces(value={"application/json"})
    public Response getCurrentRepo() {
        return Response.ok((Object)this.repositoryBrowserController.getCurrentRepo()).build();
    }
}

