/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.repo.model;

import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.repo.model.RepositoryObject;

public class RepositoryDirectory
extends RepositoryObject {
    public static String DIRECTORY = "folder";

    public RepositoryDirectory() {
        this.setHasChildren(true);
    }

    @Override
    public String getType() {
        return DIRECTORY;
    }

    public static RepositoryDirectory build(String parentPath, RepositoryDirectoryInterface repositoryDirectoryInterface) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setParent(parentPath);
        repositoryDirectory.setName(repositoryDirectoryInterface.getName());
        repositoryDirectory.setPath(repositoryDirectoryInterface.getPath());
        repositoryDirectory.setObjectId(repositoryDirectoryInterface.getObjectId());
        repositoryDirectory.setHidden(!repositoryDirectoryInterface.isVisible());
        return repositoryDirectory;
    }

    public static RepositoryDirectory build(String parentPath, RepositoryFile repositoryFile, Boolean isAdmin) {
        RepositoryDirectory repositoryDirectory = new RepositoryDirectory();
        repositoryDirectory.setParent(parentPath);
        repositoryDirectory.setName(repositoryFile.getName());
        repositoryDirectory.setPath(repositoryFile.getPath());
        repositoryDirectory.setObjectId(() -> (String)((Object)repositoryFile.getId()));
        repositoryDirectory.setHidden(repositoryFile.isHidden() != false && isAdmin == false);
        repositoryDirectory.setDate(repositoryFile.getLastModifiedDate() != null ? repositoryFile.getLastModifiedDate() : repositoryFile.getCreatedDate());
        return repositoryDirectory;
    }
}

