/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc;

import de.simplicit.vjdbc.VirtualConnection;
import de.simplicit.vjdbc.command.CallingContextFactory;
import de.simplicit.vjdbc.command.CommandSink;
import de.simplicit.vjdbc.command.DecoratedCommandSink;
import de.simplicit.vjdbc.command.NullCallingContextFactory;
import de.simplicit.vjdbc.command.StandardCallingContextFactory;
import de.simplicit.vjdbc.ejb.EjbCommandSink;
import de.simplicit.vjdbc.ejb.EjbCommandSinkHome;
import de.simplicit.vjdbc.ejb.EjbCommandSinkProxy;
import de.simplicit.vjdbc.rmi.CommandSinkRmi;
import de.simplicit.vjdbc.rmi.CommandSinkRmiProxy;
import de.simplicit.vjdbc.rmi.ConnectionBrokerRmi;
import de.simplicit.vjdbc.rmi.SecureSocketFactory;
import de.simplicit.vjdbc.serial.CallingContext;
import de.simplicit.vjdbc.serial.UIDEx;
import de.simplicit.vjdbc.servlet.RequestEnhancer;
import de.simplicit.vjdbc.servlet.RequestEnhancerFactory;
import de.simplicit.vjdbc.servlet.ServletCommandSinkJdkHttpClient;
import de.simplicit.vjdbc.servlet.jakarta.ServletCommandSinkJakartaHttpClient;
import de.simplicit.vjdbc.util.ClientInfo;
import de.simplicit.vjdbc.util.SQLExceptionHelper;
import java.rmi.Naming;
import java.rmi.server.RMISocketFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class VirtualDriver
implements Driver {
    private static Log _logger = LogFactory.getLog(VirtualDriver.class);
    private static final String VJDBC_IDENTIFIER = "jdbc:vjdbc:";
    private static final String EJB_IDENTIFIER = "ejb:";
    private static final String RMI_IDENTIFIER = "rmi:";
    private static final String SERVLET_IDENTIFIER = "servlet:";
    private static SecureSocketFactory _sslSocketFactory;
    private static boolean _cacheEnabled;
    private static final int MAJOR_VERSION = 1;
    private static final int MINOR_VERSION = 7;

    @Override
    public Connection connect(String urlstr, Properties props) throws SQLException {
        VirtualConnection result = null;
        if (this.acceptsURL(urlstr)) {
            String realUrl = urlstr.substring(VJDBC_IDENTIFIER.length());
            _logger.info((Object)("VJdbc-URL: " + realUrl));
            try {
                String[] urlparts;
                CommandSink sink = null;
                if (realUrl.startsWith(EJB_IDENTIFIER)) {
                    urlparts = this.split(realUrl.substring(EJB_IDENTIFIER.length()));
                    _logger.info((Object)("VJdbc in EJB-Mode, using object " + urlparts[0]));
                    sink = this.createEjbCommandSink(urlparts[0]);
                } else if (realUrl.startsWith(RMI_IDENTIFIER)) {
                    urlparts = this.split(realUrl.substring(RMI_IDENTIFIER.length()));
                    _logger.info((Object)("VJdbc in RMI-Mode, using object " + urlparts[0]));
                    boolean useSSL = false;
                    String propSSL = props.getProperty("vjdbc.rmi.ssl");
                    boolean bl = useSSL = propSSL != null && propSSL.equalsIgnoreCase("true");
                    if (useSSL) {
                        _logger.info((Object)"Using Secure Socket Layer (SSL)");
                    }
                    sink = this.createRmiCommandSink(urlparts[0], useSSL);
                } else if (realUrl.startsWith(SERVLET_IDENTIFIER)) {
                    urlparts = this.split(realUrl.substring(SERVLET_IDENTIFIER.length()));
                    _logger.info((Object)("VJdbc in Servlet-Mode, using URL " + urlparts[0]));
                    sink = this.createServletCommandSink(urlparts[0], props);
                } else {
                    throw new SQLException("Unknown protocol identifier " + realUrl);
                }
                if (urlparts[1].length() > 0) {
                    _logger.info((Object)("Connecting to datasource " + urlparts[1]));
                } else {
                    _logger.info((Object)"Using default datasource");
                }
                UIDEx reg = sink.connect(urlparts[1], props, ClientInfo.getProperties(props.getProperty("vjdbc.clientinfo.properties")), new CallingContext());
                CallingContextFactory ctxFactory = reg.getValue1() == 1 ? new StandardCallingContextFactory() : new NullCallingContextFactory();
                DecoratedCommandSink decosink = new DecoratedCommandSink(reg, sink, ctxFactory);
                result = new VirtualConnection(reg, decosink, props, _cacheEnabled);
            }
            catch (Exception e) {
                _logger.error((Object)e);
                throw SQLExceptionHelper.wrap(e);
            }
        }
        return result;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(VJDBC_IDENTIFIER);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 7;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    private CommandSink createRmiCommandSink(String rminame, boolean useSSL) throws Exception {
        if (useSSL && _sslSocketFactory == null) {
            _sslSocketFactory = new SecureSocketFactory();
            RMISocketFactory.setSocketFactory(_sslSocketFactory);
        }
        ConnectionBrokerRmi broker = (ConnectionBrokerRmi)Naming.lookup(rminame);
        CommandSinkRmi rmiSink = broker.createCommandSink();
        CommandSinkRmiProxy proxy = new CommandSinkRmiProxy(rmiSink);
        return proxy;
    }

    private CommandSink createEjbCommandSink(String ejbname) throws Exception {
        InitialContext ctx = new InitialContext();
        _logger.info((Object)("Lookup " + ejbname));
        Object ref = ctx.lookup(ejbname);
        _logger.info((Object)("PortableRemoteObject.narrow, " + ref.getClass().getName()));
        EjbCommandSinkHome home = (EjbCommandSinkHome)PortableRemoteObject.narrow((Object)ref, EjbCommandSinkHome.class);
        _logger.info((Object)"create");
        EjbCommandSink sink = home.create();
        return new EjbCommandSinkProxy(sink);
    }

    private CommandSink createServletCommandSink(String url, Properties props) throws Exception {
        String useJakartaHttpClient;
        RequestEnhancer requestEnhancer = null;
        String requestEnhancerFactoryClassName = props.getProperty("vjdbc.servlet.request_enhancer_factory");
        if (requestEnhancerFactoryClassName != null) {
            _logger.debug((Object)("Found RequestEnhancerFactory class: " + requestEnhancerFactoryClassName));
            Class<?> requestEnhancerFactoryClass = Class.forName(requestEnhancerFactoryClassName);
            RequestEnhancerFactory requestEnhancerFactory = (RequestEnhancerFactory)requestEnhancerFactoryClass.newInstance();
            _logger.debug((Object)"RequestEnhancerFactory successfully created");
            requestEnhancer = requestEnhancerFactory.create();
        }
        if ((useJakartaHttpClient = props.getProperty("vjdbc.servlet.use_jakarta_http_client")) != null && useJakartaHttpClient.equals("true")) {
            return new ServletCommandSinkJakartaHttpClient(url, requestEnhancer);
        }
        return new ServletCommandSinkJdkHttpClient(url, requestEnhancer);
    }

    private String[] split(String url) {
        char[] splitChars = new char[]{',', ';', '#', '$'};
        for (int i = 0; i < splitChars.length; ++i) {
            int charindex = url.indexOf(splitChars[i]);
            if (charindex < 0) continue;
            return new String[]{url.substring(0, charindex), url.substring(charindex + 1)};
        }
        return new String[]{url, ""};
    }

    static {
        _cacheEnabled = false;
        try {
            DriverManager.registerDriver(new VirtualDriver());
            _logger.info((Object)"Virtual JDBC-Driver successfully registered");
            try {
                Class.forName("org.hsqldb.jdbcDriver").newInstance();
                _logger.info((Object)"HSQL-Driver loaded, caching activated");
                _cacheEnabled = true;
            }
            catch (ClassNotFoundException e) {
                _logger.info((Object)"Couldn't load HSQL-Driver, caching deactivated");
                _cacheEnabled = false;
            }
            catch (Exception e) {
                _logger.error((Object)"Unexpected exception occured on loading the HSQL-Driver");
                _cacheEnabled = false;
            }
        }
        catch (Exception e) {
            _logger.fatal((Object)"Couldn't register Virtual-JDBC-Driver !", (Throwable)e);
            throw new RuntimeException("Couldn't register Virtual-JDBC-Driver !", e);
        }
    }
}

