/*
 * Decompiled with CFR 0.152.
 */
package de.simplicit.vjdbc.command;

import de.simplicit.vjdbc.command.Command;
import de.simplicit.vjdbc.command.ConnectionContext;
import de.simplicit.vjdbc.serial.StreamSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.CallableStatement;
import java.sql.SQLException;

public class CallableStatementSetBinaryStreamCommand
implements Command {
    static final long serialVersionUID = 4264932633701227941L;
    private int _index;
    private int _length;
    private String _parameterName;
    private byte[] _byteArray;

    public CallableStatementSetBinaryStreamCommand() {
    }

    public CallableStatementSetBinaryStreamCommand(int index, InputStream is) throws IOException {
        this._index = index;
        this._byteArray = StreamSerializer.toByteArray(is);
        this._length = this._byteArray.length;
    }

    public CallableStatementSetBinaryStreamCommand(String paramName, InputStream is) throws IOException {
        this._parameterName = paramName;
        this._byteArray = StreamSerializer.toByteArray(is);
        this._length = this._byteArray.length;
    }

    public CallableStatementSetBinaryStreamCommand(int index, InputStream is, int len) throws IOException {
        this._index = index;
        this._byteArray = StreamSerializer.toByteArray(is);
        this._length = len;
    }

    public CallableStatementSetBinaryStreamCommand(String paramName, InputStream is, int len) throws IOException {
        this._parameterName = paramName;
        this._byteArray = StreamSerializer.toByteArray(is);
        this._length = len;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._index);
        out.writeInt(this._length);
        out.writeObject(this._parameterName);
        out.writeObject(this._byteArray);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._index = in.readInt();
        this._length = in.readInt();
        this._parameterName = (String)in.readObject();
        this._byteArray = (byte[])in.readObject();
    }

    @Override
    public Object execute(Object target, ConnectionContext ctx) throws SQLException {
        CallableStatement cstmt = (CallableStatement)target;
        InputStream is = StreamSerializer.toInputStream(this._byteArray);
        if (this._parameterName != null) {
            cstmt.setBinaryStream(this._parameterName, is, this._length);
        } else {
            cstmt.setBinaryStream(this._index, is, this._length);
        }
        return null;
    }

    public String toString() {
        return "CallableStatementSetBinaryStreamCommand";
    }
}

