/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordActionsRunningGetJPAExecutor
implements JPAExecutor<List<String>> {
    private final long checkAgeSecs;

    public CoordActionsRunningGetJPAExecutor(long checkAgeSecs) {
        this.checkAgeSecs = checkAgeSecs;
    }

    @Override
    public String getName() {
        return "CoordActionsRunningGetJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        try {
            Timestamp ts = new Timestamp(System.currentTimeMillis() - this.checkAgeSecs * 1000L);
            Query q = em.createNamedQuery("GET_RUNNING_ACTIONS_OLDER_THAN");
            q.setParameter("lastModifiedTime", (Object)ts);
            List coordActionIds = q.getResultList();
            return coordActionIds;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

