/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsStatusJPAExecutor
implements JPAExecutor<List<CoordinatorAction.Status>> {
    private String coordJobId = null;

    public CoordJobGetActionsStatusJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsStatusJPAExecutor";
    }

    @Override
    public List<CoordinatorAction.Status> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_STATUS_UNIGNORED");
            q.setParameter("jobId", (Object)this.coordJobId);
            List coordStatusResultList = q.getResultList();
            ArrayList<CoordinatorAction.Status> coordStatus = new ArrayList<CoordinatorAction.Status>();
            for (String a : coordStatusResultList) {
                coordStatus.add(CoordinatorAction.Status.valueOf((String)a));
            }
            return coordStatus;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

