/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetJPAExecutor
implements JPAExecutor<CoordinatorJobBean> {
    private String coordJobId = null;

    public CoordJobGetJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    @Override
    public String getName() {
        return "CoordJobGetJPAExecutor";
    }

    @Override
    public CoordinatorJobBean execute(EntityManager em) throws JPAExecutorException {
        List cjBeans;
        try {
            Query q = em.createNamedQuery("GET_COORD_JOB");
            q.setParameter("id", (Object)this.coordJobId);
            cjBeans = q.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        CoordinatorJobBean bean = null;
        if (cjBeans != null && cjBeans.size() > 0) {
            bean = (CoordinatorJobBean)cjBeans.get(0);
            bean.setStatus(bean.getStatus());
            return bean;
        }
        throw new JPAExecutorException(ErrorCode.E0604, this.coordJobId);
    }
}

