/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.util.StringUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.NodeHandler;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class LiteWorkflowStoreService
extends WorkflowStoreService {
    public static final String CONF_PREFIX = "oozie.service.LiteWorkflowStoreService.";
    public static final String CONF_PREFIX_USER_RETRY = "oozie.service.LiteWorkflowStoreService.user.retry.";
    public static final String CONF_USER_RETRY_MAX = "oozie.service.LiteWorkflowStoreService.user.retry.max";
    public static final String CONF_USER_RETRY_INTEVAL = "oozie.service.LiteWorkflowStoreService.user.retry.inteval";
    public static final String CONF_USER_RETRY_ERROR_CODE = "oozie.service.LiteWorkflowStoreService.user.retry.error.code";
    public static final String CONF_USER_RETRY_ERROR_CODE_EXT = "oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext";
    public static final String NODE_DEF_VERSION_0 = "_oozie_inst_v_0";
    public static final String NODE_DEF_VERSION_1 = "_oozie_inst_v_1";
    public static final String CONF_NODE_DEF_VERSION = "oozie.service.LiteWorkflowStoreService.node.def.version";
    public static final String USER_ERROR_CODE_ALL = "ALL";

    protected static void liteExecute(NodeHandler.Context context, String actionType) throws WorkflowException {
        XLog log = XLog.getLog(LiteWorkflowStoreService.class);
        String jobId = context.getProcessInstance().getId();
        String nodeName = context.getNodeDef().getName();
        String skipVar = context.getProcessInstance().getVar(context.getNodeDef().getName() + "#" + "TO_SKIP");
        boolean skipAction = false;
        if (skipVar != null) {
            skipAction = skipVar.equals("true");
        }
        WorkflowActionBean action = new WorkflowActionBean();
        String actionId = Services.get().get(UUIDService.class).generateChildId(jobId, nodeName);
        if (!skipAction) {
            String nodeConf = context.getNodeDef().getConf();
            if (actionType == null) {
                try {
                    Element element = XmlUtils.parseXml(nodeConf);
                    actionType = element.getName();
                    nodeConf = XmlUtils.prettyPrint(element).toString();
                }
                catch (JDOMException ex) {
                    throw new WorkflowException(ErrorCode.E0700, new Object[]{ex.getMessage(), ex});
                }
            }
            log.debug(" Creating action for node [{0}]", nodeName);
            action.setType(actionType);
            action.setConf(nodeConf);
            action.setLogToken(((WorkflowJobBean)context.getTransientVar("oozie.workflow.workflow.bean")).getLogToken());
            action.setStatus(WorkflowAction.Status.PREP);
            action.setJobId(jobId);
        }
        String executionPath = context.getExecutionPath();
        action.setExecutionPath(executionPath);
        action.setCred(context.getNodeDef().getCred());
        log.debug("Setting action for cred: '" + context.getNodeDef().getCred() + "', name: '" + context.getNodeDef().getName() + "'");
        action.setUserRetryCount(0);
        int userRetryMax = LiteWorkflowStoreService.getUserRetryMax(context);
        int userRetryInterval = LiteWorkflowStoreService.getUserRetryInterval(context);
        action.setUserRetryMax(userRetryMax);
        action.setUserRetryInterval(userRetryInterval);
        log.debug("Setting action for userRetryMax: '" + userRetryMax + "', userRetryInterval: '" + userRetryInterval + "', name: '" + context.getNodeDef().getName() + "'");
        action.setName(nodeName);
        action.setId(actionId);
        context.setVar(nodeName + "#" + "action.id", actionId);
        ArrayList<WorkflowActionBean> list = (ArrayList<WorkflowActionBean>)context.getTransientVar("oozie.workflow.actions.to.start");
        if (list == null) {
            list = new ArrayList<WorkflowActionBean>();
            context.setTransientVar("oozie.workflow.actions.to.start", list);
        }
        list.add(action);
    }

    private static int getUserRetryInterval(NodeHandler.Context context) throws WorkflowException {
        int ret = ConfigurationService.getInt(CONF_USER_RETRY_INTEVAL);
        String userRetryInterval = context.getNodeDef().getUserRetryInterval();
        if (!userRetryInterval.equals("null")) {
            try {
                ret = Integer.parseInt(userRetryInterval);
            }
            catch (NumberFormatException nfe) {
                throw new WorkflowException(ErrorCode.E0700, nfe.getMessage(), nfe);
            }
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getUserRetryMax(NodeHandler.Context context) throws WorkflowException {
        int ret;
        XLog log = XLog.getLog(LiteWorkflowStoreService.class);
        int max = ret = ConfigurationService.getInt(CONF_USER_RETRY_MAX);
        String userRetryMax = context.getNodeDef().getUserRetryMax();
        if (userRetryMax.equals("null")) return 0;
        try {
            ret = Integer.parseInt(userRetryMax);
            if (ret <= max) return ret;
            ret = max;
            log.warn(ErrorCode.E0820.getTemplate(), ret, max);
            return ret;
        }
        catch (NumberFormatException nfe) {
            throw new WorkflowException(ErrorCode.E0700, nfe.getMessage(), nfe);
        }
    }

    public static Set<String> getUserRetryErrorCode() {
        String errorCodeString = ConfigurationService.get(CONF_USER_RETRY_ERROR_CODE).replaceAll("\\s+", "");
        Collection strings = StringUtils.getStringCollection((String)errorCodeString);
        String errorCodeExtString = ConfigurationService.get(CONF_USER_RETRY_ERROR_CODE_EXT).replaceAll("\\s+", "");
        Collection extra = StringUtils.getStringCollection((String)errorCodeExtString);
        HashSet<String> set = new HashSet<String>();
        set.addAll(strings);
        set.addAll(extra);
        return set;
    }

    public static String getNodeDefDefaultVersion() throws WorkflowException {
        String ret = ConfigurationService.get(CONF_NODE_DEF_VERSION);
        if (ret == null) {
            ret = NODE_DEF_VERSION_1;
        }
        return ret;
    }

    protected static void liteFail(NodeHandler.Context context) {
        LiteWorkflowStoreService.liteTerminate(context, "oozie.workflow.actions.to.fail");
    }

    protected static void liteKill(NodeHandler.Context context) {
        LiteWorkflowStoreService.liteTerminate(context, "oozie.workflow.actions.to.kill");
    }

    private static void liteTerminate(NodeHandler.Context context, String transientVar) {
        ArrayList<String> list = (ArrayList<String>)context.getTransientVar(transientVar);
        if (list == null) {
            list = new ArrayList<String>();
            context.setTransientVar(transientVar, list);
        }
        list.add(context.getVar(context.getNodeDef().getName() + "#" + "action.id"));
    }

    public static class LiteControlNodeHandler
    extends ControlNodeHandler {
        @Override
        public void touch(NodeHandler.Context context) throws WorkflowException {
            String nodeType;
            Class<?> nodeClass = context.getNodeDef().getClass();
            if (nodeClass.equals(StartNodeDef.class)) {
                nodeType = ":START:";
            } else if (nodeClass.equals(EndNodeDef.class)) {
                nodeType = ":END:";
            } else if (nodeClass.equals(KillNodeDef.class)) {
                nodeType = ":KILL:";
            } else if (nodeClass.equals(ForkNodeDef.class)) {
                nodeType = ":FORK:";
            } else if (nodeClass.equals(JoinNodeDef.class)) {
                nodeType = ":JOIN:";
            } else {
                throw new IllegalStateException("Invalid node type: " + nodeClass);
            }
            LiteWorkflowStoreService.liteExecute(context, nodeType);
        }
    }

    public static class LiteDecisionHandler
    extends DecisionNodeHandler {
        @Override
        public void start(NodeHandler.Context context) throws WorkflowException {
            LiteWorkflowStoreService.liteExecute(context, null);
        }

        @Override
        public void end(NodeHandler.Context context) {
        }

        @Override
        public void kill(NodeHandler.Context context) {
            LiteWorkflowStoreService.liteKill(context);
        }

        @Override
        public void fail(NodeHandler.Context context) {
            LiteWorkflowStoreService.liteFail(context);
        }
    }

    public static class LiteActionHandler
    extends ActionNodeHandler {
        @Override
        public void start(NodeHandler.Context context) throws WorkflowException {
            LiteWorkflowStoreService.liteExecute(context, null);
        }

        @Override
        public void end(NodeHandler.Context context) {
        }

        @Override
        public void kill(NodeHandler.Context context) {
            LiteWorkflowStoreService.liteKill(context);
        }

        @Override
        public void fail(NodeHandler.Context context) {
            LiteWorkflowStoreService.liteFail(context);
        }
    }
}

