/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import com.cloudera.sqoop.io.LobFile;
import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import com.cloudera.sqoop.util.TaskId;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class LargeObjectLoader
implements Closeable {
    public static final Log LOG = LogFactory.getLog((String)LargeObjectLoader.class.getName());
    public static final long DEFAULT_MAX_LOB_LENGTH = 0x1000000L;
    public static final String MAX_INLINE_LOB_LEN_KEY = "sqoop.inline.lob.length.max";
    private Configuration conf;
    private Path workPath;
    private FileSystem fs;
    private LobFile.Writer curBlobWriter;
    private LobFile.Writer curClobWriter;
    private long nextLobFileId = 0L;

    public LargeObjectLoader(Configuration conf, Path workPath) throws IOException {
        this.conf = conf;
        this.workPath = workPath;
        this.fs = FileSystem.get((Configuration)conf);
        this.curBlobWriter = null;
        this.curClobWriter = null;
    }

    protected synchronized void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (null != this.curBlobWriter) {
            this.curBlobWriter.close();
            this.curBlobWriter = null;
        }
        if (null != this.curClobWriter) {
            this.curClobWriter.close();
            this.curClobWriter = null;
        }
    }

    private String getNextLobFileName() {
        String file = "_lob/large_obj_" + TaskId.get(this.conf, "unknown_task_id") + this.nextLobFileId + ".lob";
        ++this.nextLobFileId;
        return file;
    }

    private Path getNextLobFilePath() throws IOException {
        Path p = new Path(this.workPath, this.getNextLobFileName());
        Path parent = p.getParent();
        LOG.info((Object)("Using lob file: " + p.toString()));
        if (!this.fs.exists(parent)) {
            this.fs.mkdirs(parent);
        }
        return p;
    }

    private LobFile.Writer getBlobWriter() throws IOException {
        if (null == this.curBlobWriter) {
            this.curBlobWriter = LobFile.create(this.getNextLobFilePath(), this.conf, false);
        }
        return this.curBlobWriter;
    }

    private LobFile.Writer getClobWriter() throws IOException {
        if (null == this.curClobWriter) {
            this.curClobWriter = LobFile.create(this.getNextLobFilePath(), this.conf, true);
        }
        return this.curClobWriter;
    }

    private String getRelativePath(LobFile.Writer w) {
        Path writerPath = w.getPath();
        String writerPathStr = writerPath.toString();
        String workPathStr = this.workPath.toString();
        if (!workPathStr.endsWith(File.separator)) {
            workPathStr = workPathStr + File.separator;
        }
        if (writerPathStr.startsWith(workPathStr)) {
            return writerPathStr.substring(workPathStr.length());
        }
        return writerPathStr;
    }

    private void copyAll(Reader reader, Writer writer) throws IOException {
        int charsRead;
        int bufferSize = this.conf.getInt("io.file.buffer.size", 4096);
        char[] buf = new char[bufferSize];
        while (-1 != (charsRead = reader.read(buf))) {
            writer.write(buf, 0, charsRead);
        }
    }

    private void copyAll(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        int bufferSize = this.conf.getInt("io.file.buffer.size", 4096);
        byte[] buf = new byte[bufferSize];
        while (-1 != (bytesRead = input.read(buf, 0, bufferSize))) {
            output.write(buf, 0, bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobRef readBlobRef(int colNum, ResultSet r) throws IOException, InterruptedException, SQLException {
        long maxInlineLobLen = this.conf.getLong(MAX_INLINE_LOB_LEN_KEY, 0x1000000L);
        Blob b = r.getBlob(colNum);
        if (null == b) {
            return null;
        }
        if (b.length() > maxInlineLobLen) {
            long len = b.length();
            LobFile.Writer lobWriter = this.getBlobWriter();
            long recordOffset = lobWriter.tell();
            InputStream is = null;
            OutputStream os = lobWriter.writeBlobRecord(len);
            try {
                is = b.getBinaryStream();
                this.copyAll(is, os);
            }
            finally {
                if (null != os) {
                    os.close();
                }
                if (null != is) {
                    is.close();
                }
                lobWriter.finishRecord();
            }
            return new BlobRef(this.getRelativePath(this.curBlobWriter), recordOffset, len);
        }
        return new BlobRef(b.getBytes(1L, (int)b.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClobRef readClobRef(int colNum, ResultSet r) throws IOException, InterruptedException, SQLException {
        long maxInlineLobLen = this.conf.getLong(MAX_INLINE_LOB_LEN_KEY, 0x1000000L);
        Clob c = r.getClob(colNum);
        if (null == c) {
            return null;
        }
        if (c.length() > maxInlineLobLen) {
            long len = c.length();
            LobFile.Writer lobWriter = this.getClobWriter();
            long recordOffset = lobWriter.tell();
            Reader reader = null;
            Writer w = lobWriter.writeClobRecord(len);
            try {
                reader = c.getCharacterStream();
                this.copyAll(reader, w);
            }
            finally {
                if (null != w) {
                    w.close();
                }
                if (null != reader) {
                    reader.close();
                }
                lobWriter.finishRecord();
            }
            return new ClobRef(this.getRelativePath(lobWriter), recordOffset, len);
        }
        return new ClobRef(c.getSubString(1L, (int)c.length()));
    }
}

