/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.config.ConfigurationHelper;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.tool.SqoopTool;
import com.cloudera.sqoop.util.ClassLoaderStack;
import com.cloudera.sqoop.util.Jars;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;

public class JobBase {
    public static final Log LOG = LogFactory.getLog((String)JobBase.class.getName());
    public static final String SERIALIZE_SQOOPOPTIONS = "sqoop.jobbase.serialize.sqoopoptions";
    public static final boolean SERIALIZE_SQOOPOPTIONS_DEFAULT = true;
    public static final String HADOOP_MAP_TASK_MAX_ATTEMTPS = "mapreduce.map.maxattempts";
    public static final String HADOOP_REDUCE_TASK_MAX_ATTEMTPS = "mapreduce.reduce.maxattempts";
    protected SqoopOptions options;
    protected Class<? extends Mapper> mapperClass;
    protected Class<? extends InputFormat> inputFormatClass;
    protected Class<? extends OutputFormat> outputFormatClass;
    private Job mrJob;
    private ClassLoader prevClassLoader = null;
    protected final boolean isHCatJob;
    public static final String PROPERTY_VERBOSE = "sqoop.verbose";

    public JobBase() {
        this(null);
    }

    public JobBase(SqoopOptions opts) {
        this(opts, null, null, null);
    }

    public JobBase(SqoopOptions opts, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        this.options = opts;
        this.mapperClass = mapperClass;
        this.inputFormatClass = inputFormatClass;
        this.outputFormatClass = outputFormatClass;
        this.isHCatJob = this.options.getHCatTableName() != null;
    }

    protected Class<? extends Mapper> getMapperClass() throws ClassNotFoundException {
        return this.mapperClass;
    }

    protected Class<? extends InputFormat> getInputFormatClass() throws ClassNotFoundException {
        return this.inputFormatClass;
    }

    protected Class<? extends OutputFormat> getOutputFormatClass() throws ClassNotFoundException {
        return this.outputFormatClass;
    }

    public void setOutputFormatClass(Class<? extends OutputFormat> cls) {
        this.outputFormatClass = cls;
    }

    public void setInputFormatClass(Class<? extends InputFormat> cls) {
        this.inputFormatClass = cls;
    }

    public void setMapperClass(Class<? extends Mapper> cls) {
        this.mapperClass = cls;
    }

    public void setOptions(SqoopOptions opts) {
        this.options = opts;
    }

    protected void cacheJars(Job job, ConnManager mgr) throws IOException {
        String sqoopHome;
        SqoopTool tool;
        if (this.options.isSkipDistCache()) {
            LOG.info((Object)"Not adding sqoop jars to distributed cache as requested");
            return;
        }
        Configuration conf = job.getConfiguration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> localUrls = new HashSet<String>();
        this.addToCache(Jars.getSqoopJarPath(), (FileSystem)fs, localUrls);
        if (null != mgr) {
            this.addToCache(Jars.getDriverClassJar(mgr), (FileSystem)fs, localUrls);
            this.addToCache(Jars.getJarPathForClass(mgr.getClass()), (FileSystem)fs, localUrls);
        }
        if (null != (tool = this.options.getActiveSqoopTool())) {
            this.addToCache(Jars.getJarPathForClass(tool.getClass()), (FileSystem)fs, localUrls);
            List<String> toolDeps = tool.getDependencyJars();
            if (null != toolDeps) {
                for (String depFile : toolDeps) {
                    this.addToCache(depFile, (FileSystem)fs, localUrls);
                }
            }
        }
        if (null != (sqoopHome = System.getenv("SQOOP_HOME"))) {
            File sqoopHomeFile = new File(sqoopHome);
            File sqoopLibFile = new File(sqoopHomeFile, "lib");
            if (sqoopLibFile.exists()) {
                this.addDirToCache(sqoopLibFile, (FileSystem)fs, localUrls);
            }
        } else {
            LOG.warn((Object)"SQOOP_HOME is unset. May not be able to find all job dependencies.");
        }
        if (this.options.doHiveImport() && this.options.getFileLayout() == SqoopOptions.FileLayout.ParquetFile) {
            String hiveHome = this.options.getHiveHome();
            if (null != hiveHome) {
                File hiveHomeFile = new File(hiveHome);
                File hiveLibFile = new File(hiveHomeFile, "lib");
                if (hiveLibFile.exists()) {
                    this.addDirToCache(hiveLibFile, (FileSystem)fs, localUrls);
                }
            } else {
                LOG.warn((Object)"HIVE_HOME is unset. Cannot add hive libs as dependencies.");
            }
        }
        String tmpjars = conf.get("tmpjars");
        StringBuilder sb = new StringBuilder();
        if (localUrls.isEmpty() && StringUtils.isEmpty((String)tmpjars)) {
            return;
        }
        if (null != tmpjars) {
            String[] tmpjarsElements;
            for (String jarElement : tmpjarsElements = tmpjars.split(",")) {
                if (jarElement.isEmpty()) {
                    this.warn("Empty input is invalid and was removed from tmpjars.");
                    continue;
                }
                sb.append(jarElement);
                sb.append(",");
            }
        }
        int lastComma = sb.lastIndexOf(",");
        if (localUrls.isEmpty() && lastComma >= 0) {
            sb.deleteCharAt(lastComma);
        }
        sb.append(org.apache.hadoop.util.StringUtils.arrayToString((String[])localUrls.toArray(new String[0])));
        conf.set("tmpjars", sb.toString());
    }

    protected void warn(String message) {
        LOG.warn((Object)message);
    }

    private void addToCache(String file, FileSystem fs, Set<String> localUrls) {
        if (null == file) {
            return;
        }
        Path p = new Path(file);
        String qualified = p.makeQualified(fs).toString();
        LOG.debug((Object)("Adding to job classpath: " + qualified));
        localUrls.add(qualified);
    }

    private void addDirToCache(File dir, FileSystem fs, Set<String> localUrls) {
        if (null == dir) {
            return;
        }
        for (File libfile : dir.listFiles()) {
            if (!libfile.exists() || libfile.isDirectory() || !libfile.getName().endsWith("jar")) continue;
            this.addToCache(libfile.toString(), fs, localUrls);
        }
    }

    protected void loadJars(Configuration conf, String ormJarFile, String tableClassName) throws IOException {
        boolean isLocal;
        boolean bl = isLocal = "local".equals(conf.get("mapreduce.jobtracker.address")) || "local".equals(conf.get("mapred.job.tracker"));
        if (isLocal) {
            this.prevClassLoader = ClassLoaderStack.addJarFile(ormJarFile, tableClassName);
        }
    }

    protected void unloadJars() {
        if (null != this.prevClassLoader) {
            ClassLoaderStack.setCurrentClassLoader(this.prevClassLoader);
        }
    }

    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        Class<? extends InputFormat> ifClass = this.getInputFormatClass();
        LOG.debug((Object)("Using InputFormat: " + ifClass));
        job.setInputFormatClass(ifClass);
    }

    protected void configureOutputFormat(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        Class<? extends OutputFormat> ofClass = this.getOutputFormatClass();
        LOG.debug((Object)("Using OutputFormat: " + ofClass));
        job.setOutputFormatClass(ofClass);
    }

    protected void configureMapper(Job job, String tableName, String tableClassName) throws ClassNotFoundException, IOException {
        job.setMapperClass(this.getMapperClass());
    }

    protected int configureNumTasks(Job job) throws IOException {
        int numMapTasks = this.configureNumMapTasks(job);
        this.configureNumReduceTasks(job);
        return numMapTasks;
    }

    protected int configureNumMapTasks(Job job) throws IOException {
        int numMapTasks = this.options.getNumMappers();
        if (numMapTasks < 1) {
            numMapTasks = 4;
            LOG.warn((Object)("Invalid mapper count; using " + numMapTasks + " mappers."));
        }
        ConfigurationHelper.setJobNumMaps(job, numMapTasks);
        return numMapTasks;
    }

    protected int configureNumReduceTasks(Job job) throws IOException {
        job.setNumReduceTasks(0);
        return 0;
    }

    protected void setJob(Job job) {
        this.mrJob = job;
    }

    public Job getJob() {
        return this.mrJob;
    }

    public Job createJob(Configuration configuration) throws IOException {
        if (configuration.getBoolean(SERIALIZE_SQOOPOPTIONS, true)) {
            this.putSqoopOptionsToConfiguration(this.options, configuration);
        }
        return new Job(configuration);
    }

    public void putSqoopOptionsToConfiguration(SqoopOptions opts, Configuration configuration) {
        for (Map.Entry<Object, Object> e : opts.writeProperties().entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            configuration.set("sqoop.opt." + key, value);
        }
    }

    protected boolean runJob(Job job) throws ClassNotFoundException, IOException, InterruptedException {
        return job.waitForCompletion(true);
    }

    protected void displayRetiredJobNotice(Log log) {
        log.info((Object)"The MapReduce job has already been retired. Performance");
        log.info((Object)"counters are unavailable. To get this information, ");
        log.info((Object)"you will need to enable the completed job store on ");
        log.info((Object)"the jobtracker with:");
        log.info((Object)"mapreduce.jobtracker.persist.jobstatus.active = true");
        log.info((Object)"mapreduce.jobtracker.persist.jobstatus.hours = 1");
        log.info((Object)"A jobtracker restart is required for these settings");
        log.info((Object)"to take effect.");
    }

    protected void propagateOptionsToJob(Job job) {
        Configuration configuration = job.getConfiguration();
        configuration.setBoolean(PROPERTY_VERBOSE, this.options.getVerbose());
    }
}

