/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.postgresql;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ConnManager;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.util.ExportException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.sqoop.mapreduce.ExportJobBase;
import org.apache.sqoop.mapreduce.db.DBConfiguration;
import org.apache.sqoop.mapreduce.postgresql.PGBulkloadExportMapper;
import org.apache.sqoop.mapreduce.postgresql.PGBulkloadExportReducer;
import org.apache.sqoop.orm.TableClassName;

public class PGBulkloadExportJob
extends ExportJobBase {
    public static final Log LOG = LogFactory.getLog((String)PGBulkloadExportJob.class.getName());

    public PGBulkloadExportJob(ExportJobContext context) {
        super(context);
    }

    public PGBulkloadExportJob(ExportJobContext ctxt, Class<? extends Mapper> mapperClass, Class<? extends InputFormat> inputFormatClass, Class<? extends OutputFormat> outputFormatClass) {
        super(ctxt, mapperClass, inputFormatClass, outputFormatClass);
    }

    @Override
    protected void configureInputFormat(Job job, String tableName, String tableClassName, String splitByCol) throws ClassNotFoundException, IOException {
        super.configureInputFormat(job, tableName, tableClassName, splitByCol);
        ConnManager mgr = this.context.getConnManager();
        String username = this.options.getUsername();
        if (null == username || username.length() == 0) {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), this.options.getFetchSize(), this.options.getConnectionParams());
        } else {
            DBConfiguration.configureDB(job.getConfiguration(), mgr.getDriverClass(), this.options.getConnectString(), username, this.options.getPassword(), this.options.getFetchSize(), this.options.getConnectionParams());
        }
    }

    @Override
    protected Class<? extends Mapper> getMapperClass() {
        return PGBulkloadExportMapper.class;
    }

    protected Class<? extends Reducer> getReducerClass() {
        return PGBulkloadExportReducer.class;
    }

    private void setDelimiter(String prop, char val, Configuration conf) {
        switch (val) {
            case '\u0000': {
                break;
            }
            default: {
                conf.set(prop, String.valueOf(val));
            }
        }
    }

    @Override
    protected void propagateOptionsToJob(Job job) {
        super.propagateOptionsToJob(job);
        SqoopOptions opts = this.context.getOptions();
        Configuration conf = job.getConfiguration();
        conf.setIfUnset("pgbulkload.bin", "pg_bulkload");
        if (opts.getNullStringValue() != null) {
            conf.set("pgbulkload.null.string", opts.getNullStringValue());
        }
        this.setDelimiter("pgbulkload.input.field.delim", opts.getInputFieldDelim(), conf);
        this.setDelimiter("pgbulkload.input.record.delim", opts.getInputRecordDelim(), conf);
        this.setDelimiter("pgbulkload.input.enclosedby", opts.getInputEnclosedBy(), conf);
        this.setDelimiter("pgbulkload.input.escapedby", opts.getInputEscapedBy(), conf);
        conf.setBoolean("pgbulkload.input.encloserequired", opts.isInputEncloseRequired());
        conf.setIfUnset("pgbulkload.check.constraints", "YES");
        conf.setIfUnset("pgbulkload.parse.errors", "INFINITE");
        conf.setIfUnset("pgbulkload.duplicate.errors", "INFINITE");
        conf.set("mapred.jar", this.context.getJarFile());
        conf.setBoolean("mapred.map.tasks.speculative.execution", false);
        conf.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        conf.setInt("mapreduce.map.maxattempts", 1);
        conf.setInt("mapreduce.reduce.maxattempts", 1);
    }

    @Override
    public void runExport() throws ExportException, IOException {
        String outputTableName;
        SqoopOptions options = this.context.getOptions();
        Configuration conf = options.getConf();
        DBConfiguration dbConf = null;
        String tableName = outputTableName = this.context.getTableName();
        String tableClassName = new TableClassName(options).getClassForTable(outputTableName);
        LOG.info((Object)("Beginning export of " + outputTableName));
        this.loadJars(conf, this.context.getJarFile(), tableClassName);
        try {
            Job job = new Job(conf);
            dbConf = new DBConfiguration(job.getConfiguration());
            dbConf.setOutputTableName(tableName);
            this.configureInputFormat(job, tableName, tableClassName, null);
            this.configureOutputFormat(job, tableName, tableClassName);
            this.configureNumTasks(job);
            this.propagateOptionsToJob(job);
            job.setMapperClass(this.getMapperClass());
            job.setMapOutputKeyClass(LongWritable.class);
            job.setMapOutputValueClass(Text.class);
            job.setReducerClass(this.getReducerClass());
            this.cacheJars(job, this.context.getConnManager());
            this.setJob(job);
            boolean success = this.runJob(job);
            if (!success) {
                throw new ExportException("Export job failed!");
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe);
        }
        finally {
            this.unloadJars();
        }
    }

    @Override
    protected int configureNumReduceTasks(Job job) throws IOException {
        if (job.getNumReduceTasks() < 1) {
            job.setNumReduceTasks(1);
        }
        return job.getNumReduceTasks();
    }

    private void clearStagingTable(DBConfiguration dbConf, String tableName) throws IOException {
    }
}

