/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.extra;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;

public class CalculatedChildFunDef
extends FunDefBase {
    public static final CalculatedChildFunDef instance = new CalculatedChildFunDef();

    CalculatedChildFunDef() {
        super("CalculatedChild", "Returns an existing calculated child member with name <String> from the specified <Member>.", "mmmS");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        final StringCalc stringCalc = compiler.compileString(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, stringCalc}){

            @Override
            public Member evaluateMember(Evaluator evaluator) {
                Member member = memberCalc.evaluateMember(evaluator);
                String name = stringCalc.evaluateString(evaluator);
                return CalculatedChildFunDef.this.getCalculatedChild(member, name, evaluator);
            }
        };
    }

    private Member getCalculatedChild(Member parent, String childName, Evaluator evaluator) {
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        Level childLevel = parent.getLevel().getChildLevel();
        if (childLevel == null) {
            return parent.getHierarchy().getNullMember();
        }
        List<Member> calcMemberList = schemaReader.getCalculatedMembers(childLevel);
        for (Member child : calcMemberList) {
            if (!child.getParentMember().equals(parent) || !child.getName().equals(childName)) continue;
            return child;
        }
        return parent.getHierarchy().getNullMember();
    }
}

