/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.BitSet;
import java.util.List;
import java.util.SortedSet;
import mondrian.olap.Util;
import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseIntSegmentBody;
import mondrian.rolap.agg.DenseNativeSegmentDataset;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.spi.SegmentBody;
import mondrian.util.Pair;

class DenseIntSegmentDataset
extends DenseNativeSegmentDataset {
    final int[] values;

    DenseIntSegmentDataset(SegmentAxis[] axes, int size) {
        this(axes, new int[size], Util.bitSetBetween(0, size));
    }

    DenseIntSegmentDataset(SegmentAxis[] axes, int[] values, BitSet nullIndicators) {
        super(axes, nullIndicators);
        this.values = values;
    }

    @Override
    public int getInt(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    @Override
    public Object getObject(CellKey pos) {
        if (this.values.length == 0) {
            return null;
        }
        int offset = pos.getOffset(this.axisMultipliers);
        return this.getObject(offset);
    }

    @Override
    protected Integer getObject(int offset) {
        int value = this.values[offset];
        if (value == 0 && this.isNull(offset)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean exists(CellKey pos) {
        return true;
    }

    @Override
    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        int offset = this.getOffset(pos);
        this.values[offset] = data.getInt(key);
        int value = this.values[offset];
        if (value != 0 || !data.isNull(key)) {
            this.nullValues.clear(offset);
        }
    }

    @Override
    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getInt(column);
        int value = this.values[offset];
        if (value != 0 || !rowList.isNull(column)) {
            this.nullValues.clear(offset);
        }
    }

    @Override
    public SqlStatement.Type getType() {
        return SqlStatement.Type.INT;
    }

    public void put(CellKey key, int value) {
        int offset = key.getOffset(this.axisMultipliers);
        this.values[offset] = value;
    }

    public void put(int[] ordinals, int value) {
        int offset = this.getOffset(ordinals);
        this.values[offset] = value;
    }

    void set(int k, int o) {
        this.values[k] = o;
    }

    @Override
    protected int getSize() {
        return this.values.length;
    }

    @Override
    public SegmentBody createSegmentBody(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        return new DenseIntSegmentBody(this.nullValues, this.values, axes);
    }
}

