/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.server.FileRepository;
import mondrian.server.ImplicitRepository;
import mondrian.server.MondrianServerImpl;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.IdentityCatalogLocator;
import mondrian.util.LockBox;
import org.apache.log4j.Logger;

public class MondrianServerRegistry {
    public static final Logger logger = Logger.getLogger(MondrianServerRegistry.class);
    public static final MondrianServerRegistry INSTANCE = new MondrianServerRegistry();
    final LockBox lockBox = new LockBox();
    final MondrianServer staticServer = this.createWithRepository(null, null);

    public MondrianServer serverForId(String instanceId) {
        if (instanceId != null) {
            LockBox.Entry entry = this.lockBox.get(instanceId);
            if (entry == null) {
                throw Util.newError("No server instance has id '" + instanceId + "'");
            }
            return (MondrianServer)entry.getValue();
        }
        return this.staticServer;
    }

    public String getCopyrightYear() {
        return "2018";
    }

    public String getProductVersion() {
        return "8.2.0.0-342";
    }

    public int getSchemaVersion() {
        return 3;
    }

    public MondrianServer.MondrianVersion getVersion() {
        StringBuilder sb;
        block4: {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" Vendor: Pentaho");
                String title = "mondrian";
                logger.debug((Object)"  Title: mondrian");
                String versionString = "8.2.0.0-342";
                logger.debug((Object)"Version: 8.2.0.0-342");
                int majorVersion = 8;
                logger.debug((Object)String.format("Major Version: %d", 8));
                boolean minorVersion = false;
                logger.debug((Object)String.format("Minor Version: %d", 0));
            }
            sb = new StringBuilder();
            try {
                Integer.parseInt("8.2.0.0-342");
                sb.append("8.2.0.0-342");
            }
            catch (NumberFormatException e) {
                String versionMajor = String.valueOf(8);
                String versionMinor = String.valueOf(0);
                if (versionMajor != null) {
                    sb.append(versionMajor);
                }
                if (versionMinor == null) break block4;
                sb.append(".").append(versionMinor);
            }
        }
        return new MondrianServer.MondrianVersion(){

            @Override
            public String getVersionString() {
                return sb.toString();
            }

            @Override
            public String getProductName() {
                return "mondrian";
            }

            @Override
            public int getMinorVersion() {
                return 0;
            }

            @Override
            public int getMajorVersion() {
                return 8;
            }

            public int getSchemaVersion() {
                return 3;
            }
        };
    }

    public MondrianServer createWithRepository(RepositoryContentFinder contentFinder, CatalogLocator catalogLocator) {
        Repository repository;
        if (catalogLocator == null) {
            catalogLocator = new IdentityCatalogLocator();
        }
        if (contentFinder == null) {
            if (this.staticServer != null) {
                return this.staticServer;
            }
            repository = new ImplicitRepository();
        } else {
            repository = new FileRepository(contentFinder, catalogLocator);
        }
        return new MondrianServerImpl(this, repository, catalogLocator);
    }
}

