/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ExportJobContext;
import com.cloudera.sqoop.manager.GenericJdbcManager;
import com.cloudera.sqoop.manager.ImportJobContext;
import com.cloudera.sqoop.mapreduce.JdbcExportJob;
import com.cloudera.sqoop.mapreduce.JdbcUpdateExportJob;
import com.cloudera.sqoop.util.ExportException;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.sqoop.manager.OracleManager;
import org.apache.sqoop.manager.oracle.OraOopDataDrivenDBInputFormat;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatInsert;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatUpdate;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleUtils;

public class OraOopConnManager
extends GenericJdbcManager {
    public static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopConnManager.class.getName());
    private List<String> columnNamesInOracleTable = null;
    private Map<String, Integer> columnTypesInOracleTable = null;
    private final String timestampJavaType = this.options.getConf().getBoolean("oraoop.timestamp.string", true) ? "String" : super.toJavaType(93);

    public OraOopConnManager(SqoopOptions sqoopOptions) {
        super("oracle.jdbc.OracleDriver", sqoopOptions);
    }

    @Override
    protected Connection makeConnection() throws SQLException {
        String connectStr = this.options.getConnectString();
        String username = this.options.getUsername();
        String password = this.options.getPassword();
        Properties additionalProps = this.options.getConnectionParams();
        Connection connection = OracleConnectionFactory.createOracleJdbcConnection(this.getDriverClass(), connectStr, username, password, additionalProps);
        if (username == null) {
            username = OracleManager.getSessionUser(connection);
        }
        OraOopUtilities.setCurrentSessionUser(username);
        return connection;
    }

    @Override
    public void close() throws SQLException {
        super.close();
    }

    private List<String> getColumnNamesInOracleTable(String tableName) {
        if (this.columnNamesInOracleTable == null) {
            OracleTable tableContext = null;
            try {
                tableContext = this.getOracleTableContext();
                Configuration conf = this.options.getConf();
                this.columnNamesInOracleTable = OraOopOracleQueries.getTableColumnNames(this.getConnection(), tableContext, OraOopUtilities.omitLobAndLongColumnsDuringImport(conf), OraOopUtilities.recallSqoopJobType(conf), true, true);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return OraOopUtilities.copyStringList(this.columnNamesInOracleTable);
    }

    protected List<String> getSelectedColumnNamesInOracleTable(String tableName) {
        int columnNameLimit;
        List<String> colNamesInTable = this.getColumnNamesInOracleTable(tableName);
        String[] selectedColumns = this.options.getColumns();
        if (selectedColumns != null && selectedColumns.length > 0) {
            for (int idx = 0; idx < selectedColumns.length; ++idx) {
                String selectedColumn = selectedColumns[idx];
                selectedColumns[idx] = !OracleUtils.isEscaped(selectedColumn) ? selectedColumn.toUpperCase() : OracleUtils.unescapeIdentifier(selectedColumn);
            }
            String[] duplicates = OraOopUtilities.getDuplicatedStringArrayValues(selectedColumns, false);
            if (duplicates.length > 0) {
                StringBuilder msg = new StringBuilder();
                msg.append("The following column names have been duplicated in the ");
                msg.append("\"--columns\" clause:\n");
                for (String duplicate : duplicates) {
                    msg.append("\t" + duplicate + "\n");
                }
                throw new RuntimeException(msg.toString());
            }
            for (String selectedColumn : selectedColumns) {
                if (colNamesInTable.contains(selectedColumn)) continue;
                OracleTable tableContext = this.getOracleTableContext();
                throw new RuntimeException(String.format("The column named \"%s\" does not exist within the table%s (or is of an unsupported data-type).", selectedColumn, tableContext.toString()));
            }
            for (int idx = colNamesInTable.size() - 1; idx >= 0; --idx) {
                String colName = colNamesInTable.get(idx);
                if (OraOopUtilities.stringArrayContains(selectedColumns, colName, false)) continue;
                colNamesInTable.remove(idx);
            }
        }
        if ((columnNameLimit = this.options.getConf().getInt("oraoop.column.limit", 0)) > 0) {
            columnNameLimit = Math.min(columnNameLimit, colNamesInTable.size());
            colNamesInTable = colNamesInTable.subList(0, columnNameLimit);
        }
        return colNamesInTable;
    }

    @Override
    protected String getColTypesQuery(String tableName) {
        List<String> colNames = this.getSelectedColumnNamesInOracleTable(tableName);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int idx = 0; idx < colNames.size(); ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(this.escapeColName(colNames.get(idx)));
        }
        sb.append(String.format(" FROM %s WHERE 0=1", tableName));
        return sb.toString();
    }

    @Override
    protected String getColNamesQuery(String tableName) {
        List<String> colNames = this.getSelectedColumnNamesInOracleTable(tableName);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int idx = 0; idx < colNames.size(); ++idx) {
            if (idx > 0) {
                sb.append(",");
            }
            sb.append(this.escapeColName(colNames.get(idx)));
        }
        sb.append(String.format(" FROM %s WHERE 1=0", this.escapeTableName(tableName)));
        return sb.toString();
    }

    @Override
    protected String getSplitColumn(SqoopOptions opts, String tableName) {
        if (tableName != null) {
            return "not-required";
        }
        return super.getSplitColumn(opts, tableName);
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        this.logImportTableDetails(context);
        context.setConnManager(this);
        context.setInputFormat(OraOopDataDrivenDBInputFormat.class);
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        Class<OraOopOutputFormatInsert> oraOopOutputFormatClass;
        this.logExportTableDetails(context);
        if (this.columnTypesInOracleTable == null) {
            throw new ExportException("The column-types for the table are notknown.");
        }
        if (this.columnTypesInOracleTable.containsValue(OraOopOracleQueries.getOracleType("BINARY_DOUBLE"))) {
            context.getOptions().getConf().setBoolean("oraoop.table.contains.binary.double.column", true);
        }
        if (this.columnTypesInOracleTable.containsValue(OraOopOracleQueries.getOracleType("BINARY_FLOAT"))) {
            context.getOptions().getConf().setBoolean("oraoop.table.contains.binary.float.column", true);
        }
        context.setConnManager(this);
        try {
            oraOopOutputFormatClass = OraOopOutputFormatInsert.class;
        }
        catch (NoClassDefFoundError ex) {
            this.explainWhyExportClassCannotBeLoaded(ex, "OraOopOutputFormatInsert");
            throw ex;
        }
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, oraOopOutputFormatClass);
        exportJob.runExport();
    }

    @Override
    public void updateTable(ExportJobContext context) throws IOException, ExportException {
        Class<OraOopOutputFormatUpdate> oraOopOutputFormatClass;
        this.logExportTableDetails(context);
        context.setConnManager(this);
        try {
            oraOopOutputFormatClass = OraOopOutputFormatUpdate.class;
        }
        catch (NoClassDefFoundError ex) {
            this.explainWhyExportClassCannotBeLoaded(ex, "OraOopOutputFormatUpdate");
            throw ex;
        }
        JdbcUpdateExportJob exportJob = new JdbcUpdateExportJob(context, null, null, oraOopOutputFormatClass);
        exportJob.runExport();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public String toHiveType(int sqlType) {
        String hiveType = super.toHiveType(sqlType);
        if (hiveType == null) {
            if (sqlType == OraOopOracleQueries.getOracleType("BFILE") || sqlType == OraOopOracleQueries.getOracleType("INTERVALYM") || sqlType == OraOopOracleQueries.getOracleType("INTERVALDS") || sqlType == OraOopOracleQueries.getOracleType("NCLOB") || sqlType == OraOopOracleQueries.getOracleType("NCHAR") || sqlType == OraOopOracleQueries.getOracleType("NVARCHAR") || sqlType == OraOopOracleQueries.getOracleType("OTHER") || sqlType == OraOopOracleQueries.getOracleType("ROWID") || sqlType == OraOopOracleQueries.getOracleType("TIMESTAMPTZ") || sqlType == OraOopOracleQueries.getOracleType("TIMESTAMPLTZ") || sqlType == OraOopOracleQueries.getOracleType("STRUCT")) {
                hiveType = "STRING";
            }
            if (sqlType == OraOopOracleQueries.getOracleType("BINARY_FLOAT")) {
                hiveType = "FLOAT";
            }
            if (sqlType == OraOopOracleQueries.getOracleType("BINARY_DOUBLE")) {
                hiveType = "DOUBLE";
            }
        }
        if (hiveType == null) {
            LOG.warn(String.format("%s should be updated to cater for data-type: %d", OraOopUtilities.getCurrentMethodName(), sqlType));
        }
        return hiveType;
    }

    @Override
    public String toJavaType(int sqlType) {
        String javaType = super.toJavaType(sqlType);
        if (sqlType == OraOopOracleQueries.getOracleType("TIMESTAMP")) {
            javaType = this.timestampJavaType;
        }
        if (sqlType == OraOopOracleQueries.getOracleType("TIMESTAMPTZ")) {
            javaType = this.timestampJavaType;
        }
        if (sqlType == OraOopOracleQueries.getOracleType("TIMESTAMPLTZ")) {
            javaType = this.timestampJavaType;
        }
        if (sqlType == OraOopOracleQueries.getOracleType("BINARY_FLOAT")) {
            javaType = "Float";
        }
        if (sqlType == OraOopOracleQueries.getOracleType("BINARY_DOUBLE")) {
            javaType = "Double";
        }
        if (sqlType == OraOopOracleQueries.getOracleType("STRUCT")) {
            javaType = "String";
        }
        if (javaType == null && (sqlType == OraOopOracleQueries.getOracleType("BFILE") || sqlType == OraOopOracleQueries.getOracleType("NCLOB") || sqlType == OraOopOracleQueries.getOracleType("NCHAR") || sqlType == OraOopOracleQueries.getOracleType("NVARCHAR") || sqlType == OraOopOracleQueries.getOracleType("ROWID") || sqlType == OraOopOracleQueries.getOracleType("INTERVALYM") || sqlType == OraOopOracleQueries.getOracleType("INTERVALDS") || sqlType == OraOopOracleQueries.getOracleType("OTHER"))) {
            javaType = "String";
        }
        if (javaType == null) {
            LOG.warn(String.format("%s should be updated to cater for data-type: %d", OraOopUtilities.getCurrentMethodName(), sqlType));
        }
        return javaType;
    }

    @Override
    public String timestampToQueryString(Timestamp ts) {
        return "TO_TIMESTAMP('" + ts + "', 'YYYY-MM-DD HH24:MI:SS.FF')";
    }

    public OracleTable getOracleTableContext() {
        return OraOopUtilities.decodeOracleTableName(this.options.getUsername(), this.options.getTableName(), this.options.getConf());
    }

    @Override
    public Map<String, Integer> getColumnTypes(String tableName) {
        if (this.columnTypesInOracleTable == null) {
            Map<String, Integer> columnTypes = super.getColumnTypes(tableName);
            this.columnTypesInOracleTable = new HashMap<String, Integer>();
            List<String> colNames = this.getColumnNamesInOracleTable(tableName);
            for (int idx = 0; idx < colNames.size(); ++idx) {
                String columnNameInTable = colNames.get(idx);
                if (!columnTypes.containsKey(columnNameInTable)) continue;
                int colType = columnTypes.get(columnNameInTable);
                String key = OracleUtils.unescapeIdentifier(columnNameInTable);
                this.columnTypesInOracleTable.put(key, colType);
            }
        }
        return this.columnTypesInOracleTable;
    }

    @Override
    public String escapeColName(String colName) {
        return OracleUtils.escapeIdentifier(colName);
    }

    @Override
    public String escapeTableName(String tableName) {
        return OracleUtils.escapeIdentifier(tableName);
    }

    @Override
    public boolean escapeTableNameOnExport() {
        return true;
    }

    private void logImportTableDetails(ImportJobContext context) {
        Path outputDirectory = context.getDestination();
        if (outputDirectory != null) {
            LOG.debug("The output directory for the sqoop table import is : " + outputDirectory.getName());
        }
        this.showUserWhetherOraOopOraStatsIsAvailable(context.getOptions().getConf());
    }

    private void logExportTableDetails(ExportJobContext context) {
        this.showUserWhetherOraOopOraStatsIsAvailable(context.getOptions().getConf());
        String[] updateKeyColumns = OraOopUtilities.getExportUpdateKeyColumnNames(context.getOptions());
        if (updateKeyColumns.length > 0) {
            LOG.info(String.format("The column%s used to match rows in the HDFS file with rows in the Oracle table %s: %s", updateKeyColumns.length > 1 ? "s" : "", updateKeyColumns.length > 1 ? "are" : "is", OraOopUtilities.stringArrayToCSV(updateKeyColumns)));
        }
    }

    private void showUserWhetherOraOopOraStatsIsAvailable(Configuration conf) {
        if (OraOopUtilities.userWantsOracleSessionStatisticsReports(conf)) {
            LOG.info(String.format("%s=true", "oraoop.report.session.statistics"));
            OraOopUtilities.startSessionSnapshot(null);
        }
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT SYSTIMESTAMP FROM DUAL";
    }

    @Override
    protected void checkTableImportOptions(ImportJobContext context) throws IOException, ImportException {
        super.checkTableImportOptions(context);
    }

    private void explainWhyExportClassCannotBeLoaded(NoClassDefFoundError ex, String exportClassName) {
        String msg = String.format("Unable to load class %s.\nThis is most likely caused by the Cloudera Shim Jar not being included in the Java Classpath.\nEither:\n\tUse \"-libjars\" on the Sqoop command-line to include the Cloudera shim jar in the Java Classpath; or\n\tCopy the Cloudera shim jar into the Sqoop/lib directory so that it is automatically included in the Java Classpath; or\n\tObtain an updated version of Sqoop that addresses the Sqoop Jira \"SQOOP-127\".\n\nThe Java Classpath is:\n%s", exportClassName, OraOopUtilities.getJavaClassPath());
        LOG.fatal(msg, ex);
    }

    @Override
    public boolean isDirectModeHCatSupported() {
        return true;
    }

    @Override
    public boolean isDirectModeHBaseSupported() {
        return true;
    }

    @Override
    public boolean isDirectModeAccumuloSupported() {
        return true;
    }
}

