/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.example;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import parquet.example.data.Group;
import parquet.example.data.simple.convert.GroupRecordConverter;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;

public class GroupReadSupport
extends ReadSupport<Group> {
    @Override
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = GroupReadSupport.getSchemaForRead(fileSchema, partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    @Override
    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

