/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper.field;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongoArrayExpansion {
    protected static Class<?> PKG = MongoArrayExpansion.class;
    public String m_expansionPath;
    protected List<MongoField> m_subFields;
    private List<String> m_pathParts;
    private List<String> m_tempParts;
    public RowMetaInterface m_outputRowMeta;

    public MongoArrayExpansion(List<MongoField> subFields) {
        this.m_subFields = subFields;
    }

    public void init() throws KettleException {
        if (Const.isEmpty((String)this.m_expansionPath)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.NoPathSet", (String[])new String[0]));
        }
        if (this.m_pathParts != null) {
            return;
        }
        String expansionPath = MongoDbInputData.cleansePath(this.m_expansionPath);
        String[] temp = expansionPath.split("\\.");
        this.m_pathParts = new ArrayList<String>();
        for (String part : temp) {
            this.m_pathParts.add(part);
        }
        if (this.m_pathParts.get(0).equals("$")) {
            this.m_pathParts.remove(0);
        } else if (this.m_pathParts.get(0).startsWith("$[")) {
            String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
            this.m_pathParts.set(0, r);
        }
        this.m_tempParts = new ArrayList<String>();
        if (this.m_subFields != null) {
            for (MongoField f : this.m_subFields) {
                int outputIndex = this.m_outputRowMeta.indexOfValue(f.m_fieldName);
                f.init(outputIndex);
            }
        }
    }

    public void reset(VariableSpace space) {
        this.m_tempParts.clear();
        for (String part : this.m_pathParts) {
            this.m_tempParts.add(space.environmentSubstitute(part));
        }
        for (MongoField f : this.m_subFields) {
            f.reset(space);
        }
    }

    protected Object[][] nullResult() {
        Object[][] result = new Object[1][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
        return result;
    }

    public Object[][] convertToKettleValue(BasicDBObject mongoObject, VariableSpace space) throws KettleException {
        Object fieldValue;
        if (mongoObject == null) {
            return this.nullResult();
        }
        if (this.m_tempParts.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.m_tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return this.nullResult();
        }
        if (part.indexOf(91) > 0) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.m_tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get(part)) == null) {
            return this.nullResult();
        }
        if (fieldValue instanceof BasicDBObject) {
            return this.convertToKettleValue((BasicDBObject)fieldValue, space);
        }
        if (fieldValue instanceof BasicDBList) {
            return this.convertToKettleValue((BasicDBList)fieldValue, space);
        }
        return this.nullResult();
    }

    public Object[][] convertToKettleValue(BasicDBList mongoList, VariableSpace space) throws KettleException {
        if (mongoList == null) {
            return this.nullResult();
        }
        if (this.m_tempParts.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.m_tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return this.nullResult();
        }
        String index = part.substring(1, part.indexOf(93));
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            this.m_tempParts.add(0, part);
        }
        if (index.equals("*")) {
            Object[][] result = new Object[mongoList.size()][this.m_outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            for (int i = 0; i < mongoList.size(); ++i) {
                Object element = mongoList.get(i);
                for (int j = 0; j < this.m_subFields.size(); ++j) {
                    MongoField sf = this.m_subFields.get(j);
                    sf.reset(space);
                    result[i][sf.m_outputIndex] = element instanceof BasicDBObject ? sf.convertToKettleValue((BasicDBObject)element) : (element instanceof BasicDBList ? sf.convertToKettleValue((BasicDBList)element) : sf.getKettleValue(element));
                }
            }
            return result;
        }
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return this.nullResult();
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return this.nullResult();
        }
        if (element instanceof BasicDBObject) {
            return this.convertToKettleValue((BasicDBObject)element, space);
        }
        if (element instanceof BasicDBList) {
            return this.convertToKettleValue((BasicDBList)element, space);
        }
        return this.nullResult();
    }
}

