/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.parser;

import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.connections.OlapConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.parser.OlapConnectionReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.parser.OlapConnectionReadHandlerFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.StringReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractMDXDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private AbstractMDXDataFactory dataFactory;
    private OlapConnectionReadHandler connectionProviderReadHandler;
    private StringReadHandler roleField;
    private StringReadHandler jdbcUserField;
    private StringReadHandler jdbcPasswordField;

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        OlapConnectionReadHandlerFactory factory = OlapConnectionReadHandlerFactory.getInstance();
        XmlReadHandler handler = factory.getHandler(uri, tagName);
        if (handler instanceof OlapConnectionReadHandler) {
            this.connectionProviderReadHandler = (OlapConnectionReadHandler)handler;
            return this.connectionProviderReadHandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("role-field".equals(tagName)) {
            this.roleField = new StringReadHandler();
            return this.roleField;
        }
        if ("jdbc-user-field".equals(tagName)) {
            this.jdbcUserField = new StringReadHandler();
            return this.jdbcUserField;
        }
        if ("jdbc-password-field".equals(tagName)) {
            this.jdbcPasswordField = new StringReadHandler();
            return this.jdbcPasswordField;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        OlapConnectionProvider provider = null;
        if (this.connectionProviderReadHandler != null) {
            provider = (OlapConnectionProvider)this.connectionProviderReadHandler.getObject();
        }
        if (provider == null) {
            provider = (OlapConnectionProvider)this.getRootHandler().getHelperObject("olap-connection-provider");
        }
        if (provider == null) {
            throw new SAXException("Unable to create OLAP4J Factory: No connection provider specified or recognized.");
        }
        this.dataFactory = this.createDataFactory(provider);
        if (this.roleField != null) {
            this.dataFactory.setRoleField(this.roleField.getResult());
        }
        if (this.jdbcUserField != null) {
            this.dataFactory.setJdbcUserField(this.jdbcUserField.getResult());
        }
        if (this.jdbcPasswordField != null) {
            this.dataFactory.setJdbcPasswordField(this.jdbcPasswordField.getResult());
        }
    }

    protected abstract AbstractMDXDataFactory createDataFactory(OlapConnectionProvider var1);

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }
}

