/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.MessageSender;
import ca.sqlpower.dao.SPPersistenceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonMessageSender
implements MessageSender<JSONObject> {
    private final List<JSONObject> jsonObjects = new ArrayList<JSONObject>();

    @Override
    public synchronized void clear() {
        this.jsonObjects.clear();
    }

    @Override
    public synchronized void flush() throws SPPersistenceException {
    }

    @Override
    public synchronized void send(JSONObject content) throws SPPersistenceException {
        this.jsonObjects.add(content);
    }

    public synchronized List<JSONObject> getJsonObjects() {
        return Collections.unmodifiableList(this.jsonObjects);
    }

    public synchronized JSONArray getJsonArray() {
        JSONArray jsonArray = new JSONArray();
        for (JSONObject object : this.jsonObjects) {
            jsonArray.put(object);
        }
        return jsonArray;
    }

    public synchronized JSONArray getAndClear() {
        JSONArray jsonArray = this.getJsonArray();
        this.clear();
        return jsonArray;
    }

    public synchronized String getJsonString() {
        return this.getJsonArray().toString();
    }
}

