/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistedObjectComparator
implements Comparator<PersistedSPObject> {
    private final SPObject root;
    private final Map<String, PersistedSPObject> persistedObjectsMap;
    private final Map<String, SPObject> lookupCache;

    public PersistedObjectComparator(SPObject root, Map<String, PersistedSPObject> persistedObjectsMap) {
        this.root = root;
        this.persistedObjectsMap = persistedObjectsMap;
        this.lookupCache = new HashMap<String, SPObject>(SQLPowerUtils.buildIdMap(this.root));
    }

    @Override
    public int compare(PersistedSPObject o1, PersistedSPObject o2) {
        if (o1.getParentUUID() == null && o2.getParentUUID() == null) {
            return 0;
        }
        if (o1.getParentUUID() == null) {
            return -1;
        }
        if (o2.getParentUUID() == null) {
            return 1;
        }
        if (o1.getParentUUID().equals(o2.getParentUUID()) && o1.getType().equals(o2.getType())) {
            return Integer.signum(o1.getIndex() - o2.getIndex());
        }
        List<PersistedSPObject> ancestorList1 = this.buildAncestorListFromPersistedObjects(o1);
        List<PersistedSPObject> ancestorList2 = this.buildAncestorListFromPersistedObjects(o2);
        if (ancestorList1.contains(o2)) {
            return 1;
        }
        if (ancestorList2.contains(o1)) {
            return -1;
        }
        PersistedSPObject sharedAncestor = null;
        PersistedSPObject ancestor1 = null;
        PersistedSPObject ancestor2 = null;
        boolean compareWithAncestor = false;
        int i = 0;
        for (int j = 0; i < ancestorList1.size() && j < ancestorList2.size(); ++i, ++j) {
            ancestor1 = ancestorList1.get(i);
            ancestor2 = ancestorList2.get(j);
            if (sharedAncestor != null && !ancestor1.equals(ancestor2)) {
                compareWithAncestor = true;
                break;
            }
            sharedAncestor = ancestor1;
        }
        if (!compareWithAncestor) {
            if (ancestorList1.size() < ancestorList2.size()) {
                ancestor1 = o1;
                ancestor2 = ancestorList2.get(ancestorList1.size());
            } else if (ancestorList1.size() > ancestorList2.size()) {
                ancestor1 = ancestorList1.get(ancestorList2.size());
                ancestor2 = o2;
            } else {
                ancestor1 = o1;
                ancestor2 = o2;
            }
        }
        if (ancestor1.equals(ancestor2)) {
            throw new IllegalStateException("The ancestors of " + o1 + " and " + o2 + " is the same object but should not be by checks above. The ancestor is " + ancestor1);
        }
        return this.compareAncestors(o1, o2, ancestorList1, ancestorList2, sharedAncestor, ancestor1, ancestor2);
    }

    protected int compareAncestors(PersistedSPObject o1, PersistedSPObject o2, List<PersistedSPObject> ancestorList1, List<PersistedSPObject> ancestorList2, PersistedSPObject sharedAncestor, PersistedSPObject ancestor1, PersistedSPObject ancestor2) {
        int c;
        if (ancestor1.getType().equals(ancestor2.getType())) {
            c = ancestor1.getIndex() - ancestor2.getIndex();
        } else {
            if (sharedAncestor == null) {
                if (ancestorList1.isEmpty()) {
                    throw new IllegalStateException("The object represented by " + o1 + " is not correctly connected to the model");
                }
                if (ancestorList2.isEmpty()) {
                    throw new IllegalStateException("The object represented by " + o2 + " is not correctly connected to the model");
                }
                throw new NullPointerException("There was an issue comparing " + o1 + " and " + o2 + " which is " + "normally caused by the objects not being in the same tree.");
            }
            try {
                int ancestorType1Index = PersisterUtils.getTypePosition(ancestor1.getType(), sharedAncestor.getType());
                if (ancestorType1Index == -1) {
                    throw new IllegalStateException("Allowed child types for " + sharedAncestor + " does not contain " + ancestor1);
                }
                int ancestorType2Index = PersisterUtils.getTypePosition(ancestor2.getType(), sharedAncestor.getType());
                if (ancestorType2Index == -1) {
                    throw new IllegalStateException("Allowed child types for " + sharedAncestor + " does not contain " + ancestor2);
                }
                c = ancestorType1Index - ancestorType2Index;
                if (c == 0 && ancestor1.getParentUUID().equals(ancestor2.getParentUUID())) {
                    c = ancestor1.getIndex() - ancestor2.getIndex();
                    if (c == 0) {
                        throw new IllegalStateException("The objects " + ancestor1 + " and " + ancestor2 + " are defined as equal but shouldn't be.");
                    }
                } else if (c == 0) {
                    throw new IllegalStateException("Error comparing " + o1 + " to " + o2);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Integer.signum(c);
    }

    private List<PersistedSPObject> buildAncestorListFromPersistedObjects(PersistedSPObject child) {
        PersistedSPObject pso;
        ArrayList<PersistedSPObject> resultList = new ArrayList<PersistedSPObject>();
        String uuid = child.getParentUUID();
        while ((pso = this.persistedObjectsMap.get(uuid)) != null) {
            resultList.add(0, pso);
            uuid = pso.getParentUUID();
        }
        SPObject spo = this.findByUuid(uuid, SPObject.class);
        ArrayList<PersistedSPObject> existingAncestorList = new ArrayList<PersistedSPObject>();
        if (spo != null) {
            existingAncestorList.add(0, PersisterUtils.createPersistedObjectFromSPObject(spo));
            List<SPObject> ancestorList = SQLPowerUtils.getAncestorList(spo);
            Collections.reverse(ancestorList);
            for (SPObject ancestor : ancestorList) {
                existingAncestorList.add(0, PersisterUtils.createPersistedObjectFromSPObject(ancestor));
            }
        }
        resultList.addAll(0, existingAncestorList);
        return resultList;
    }

    protected <T extends SPObject> T findByUuid(String uuid, Class<T> expectedType) {
        if (this.lookupCache.get(uuid) != null) {
            SPObject foundObject = this.lookupCache.get(uuid);
            if (!expectedType.isAssignableFrom(foundObject.getClass())) {
                throw new IllegalStateException("The object " + foundObject + " is not of type " + expectedType + " from the cache.");
            }
            return (T)((SPObject)expectedType.cast(foundObject));
        }
        return null;
    }
}

