/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.FriendlyRuntimeSPPersistenceException;
import ca.sqlpower.dao.PersistedObjectEntry;
import ca.sqlpower.dao.PersistedPropertiesEntry;
import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.dao.RemovedObjectEntry;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPSessionPersister;
import ca.sqlpower.dao.helper.PersisterHelperFinder;
import ca.sqlpower.dao.helper.SPPersisterHelper;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.util.HashTreeSetMultimap;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SortedSetMultimap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;

public class SPPersisterListener
implements SPListener {
    private static final String PROPERTY_CHANGED_MSG = "Start event: propertyChange";
    private static final Logger logger = Logger.getLogger(SPPersisterListener.class);
    private final SPPersister target;
    private final SessionPersisterSuperConverter converter;
    private SPSessionPersister eventSource;
    private Multimap<String, PersistedSPOProperty> persistedProperties = LinkedListMultimap.create();
    private LinkedHashMap<String, PersistedSPObject> persistedObjects = new LinkedHashMap();
    private SortedSetMultimap<String, PersistedSPObject> parentPeristedObjects = new HashTreeSetMultimap<String, PersistedSPObject>(new Comparator<PersistedSPObject>(){

        @Override
        public int compare(PersistedSPObject o1, PersistedSPObject o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getIndex() - o2.getIndex();
        }
    });
    private LinkedHashMap<String, RemovedObjectEntry> objectsToRemove = new LinkedHashMap();
    private Set<String> removedObjectsUUIDs = new HashSet<String>();
    private int transactionCount = 0;
    private boolean rollingBack;
    private final SPSessionPersister rollbackPersister;

    public SPPersisterListener(SPPersister target, SessionPersisterSuperConverter converter) {
        this(target, null, converter);
    }

    public SPPersisterListener(SPPersister target, SPSessionPersister dontEcho, SessionPersisterSuperConverter converter) {
        this(target, dontEcho, converter, null);
    }

    public SPPersisterListener(SPPersister target, SPSessionPersister dontEcho, SessionPersisterSuperConverter converter, SPSessionPersister rollbackPersister) {
        this.target = target;
        this.converter = converter;
        this.eventSource = dontEcho;
        this.rollbackPersister = rollbackPersister;
    }

    private String getParentPersistedObjectsId(PersistedSPObject pso) {
        return this.getParentPersistedObjectsId(pso.getParentUUID(), pso.getType());
    }

    private String getParentPersistedObjectsId(String parentUUID, String type) {
        return parentUUID + "." + type;
    }

    @Override
    public void childAdded(SPChildEvent e) {
        if (!e.getSource().getRunnableDispatcher().isForegroundThread()) {
            throw new RuntimeException("New child event " + e + " not fired on the foreground.");
        }
        int index = e.getIndex();
        PersistedSPObject minValue = new PersistedSPObject(e.getSource().getUUID(), e.getChildType().getName(), e.getChild().getUUID(), index);
        HashSet<PersistedSPObject> toBeUpdated = new HashSet<PersistedSPObject>(this.parentPeristedObjects.get((Object)this.getParentPersistedObjectsId(minValue)).tailSet(minValue));
        for (PersistedSPObject psp : toBeUpdated) {
            PersistedSPObject newIndexedSibling = new PersistedSPObject(psp.getParentUUID(), psp.getType(), psp.getUUID(), psp.getIndex() + 1);
            this.parentPeristedObjects.remove((Object)this.getParentPersistedObjectsId(psp), (Object)psp);
            this.parentPeristedObjects.put((Object)this.getParentPersistedObjectsId(newIndexedSibling), (Object)newIndexedSibling);
            psp.setIndex(psp.getIndex() + 1);
        }
        SQLPowerUtils.listenToHierarchy(e.getChild(), this);
        if (this.wouldEcho()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Child added: " + e));
        }
        this.persistObject(e.getChild(), index);
        this.removedObjectsUUIDs.removeAll(this.getDescendantUUIDs(e.getChild()));
    }

    public void persistObject(SPObject o, int index) {
        this.persistObject(o, index, true);
    }

    public void persistObject(SPObject o, int index, boolean includeRootPersistObject) {
        if (this.wouldEcho()) {
            return;
        }
        this.transactionStarted(TransactionEvent.createStartTransactionEvent(this, "Persisting " + o.getName() + " and its descendants."));
        SPPersister poolingPersister = new SPPersister(){

            @Override
            public void rollback() {
            }

            @Override
            public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
                throw new IllegalStateException("There was a remove object call when trying to persist an object. This should not happen.");
            }

            @Override
            public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
                SPPersisterListener.this.persistedProperties.put((Object)uuid, (Object)new PersistedSPOProperty(uuid, propertyName, propertyType, newValue, newValue, true));
            }

            @Override
            public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
                SPPersisterListener.this.persistedProperties.put((Object)uuid, (Object)new PersistedSPOProperty(uuid, propertyName, propertyType, oldValue, newValue, false));
            }

            @Override
            public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding a " + type + " with UUID: " + uuid + " to persistedObjects"));
                }
                if (SPPersisterListener.this.getPersistedObject(uuid) != null) {
                    throw new SPPersistenceException(uuid, "Cannot add object of type " + type + " with UUID " + uuid + " because an object with " + " the same UUID has already been added");
                }
                PersistedSPObject pspo = new PersistedSPObject(parentUUID, type, uuid, index);
                SPPersisterListener.this.persistedObjects.put(uuid, pspo);
                SPPersisterListener.this.parentPeristedObjects.put((Object)SPPersisterListener.this.getParentPersistedObjectsId(pspo), (Object)pspo);
            }

            @Override
            public void commit() throws SPPersistenceException {
            }

            @Override
            public void begin() throws SPPersistenceException {
            }
        };
        try {
            this.persistObjectInterleaveProperties(o, index, includeRootPersistObject, poolingPersister);
        }
        catch (SPPersistenceException e) {
            throw new RuntimeException(e);
        }
        this.transactionEnded(TransactionEvent.createEndTransactionEvent(this));
    }

    public void persistObjectInterleaveProperties(SPObject o, int index, boolean includeRootPersistObject, SPPersister localTarget) throws SPPersistenceException {
        this.persistObjectInterleaveProperties(o, index, includeRootPersistObject, localTarget, Collections.<Class<SPObject>>emptySet());
    }

    public void persistObjectInterleaveProperties(SPObject o, int index, boolean includeRootPersistObject, SPPersister localTarget, Collection<Class<? extends SPObject>> skipList) throws SPPersistenceException {
        SPPersisterHelper<? extends SPObject> persisterHelper;
        try {
            persisterHelper = PersisterHelperFinder.findPersister(o.getClass());
        }
        catch (Exception e) {
            throw new SPPersistenceException(o.getUUID(), e);
        }
        localTarget.begin();
        if (includeRootPersistObject) {
            persisterHelper.persistObject(o, index, localTarget, this.converter);
        } else {
            ArrayList<String> emptyList = new ArrayList<String>();
            persisterHelper.persistObjectProperties(o, localTarget, this.converter, emptyList);
        }
        for (Class<? extends SPObject> childType : o.getAllowedChildTypes()) {
            if (skipList.contains(childType)) continue;
            List<? extends SPObject> children = o instanceof SQLObject ? ((SQLObject)o).getChildrenWithoutPopulating(childType) : o.getChildren(childType);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Persisting children " + children + " of " + o));
            }
            for (int i = 0; i < children.size(); ++i) {
                this.persistObjectInterleaveProperties(children.get(i), i, true, localTarget, skipList);
            }
        }
        localTarget.commit();
    }

    @Override
    public void childRemoved(SPChildEvent e) {
        if (!e.getSource().getRunnableDispatcher().isForegroundThread()) {
            throw new RuntimeException("Removed child event " + e + " not fired on the foreground.");
        }
        String parentUUID = e.getSource().getUUID();
        int index = e.getIndex();
        ArrayList<PersistedSPObject> toBeUpdated = new ArrayList<PersistedSPObject>();
        for (PersistedSPObject persisterSibling : this.parentPeristedObjects.get((Object)this.getParentPersistedObjectsId(parentUUID, e.getChildType().getName()))) {
            if (persisterSibling.getIndex() <= index || !persisterSibling.getType().equals(e.getChildType().getName())) continue;
            toBeUpdated.add(persisterSibling);
        }
        for (PersistedSPObject psp : toBeUpdated) {
            PersistedSPObject newIndexedSibling = new PersistedSPObject(psp.getParentUUID(), psp.getType(), psp.getUUID(), psp.getIndex() - 1);
            this.persistedObjects.remove(psp.getUUID());
            this.persistedObjects.put(psp.getUUID(), newIndexedSibling);
            this.parentPeristedObjects.remove((Object)this.getParentPersistedObjectsId(psp), (Object)psp);
            this.parentPeristedObjects.put((Object)this.getParentPersistedObjectsId(newIndexedSibling), (Object)newIndexedSibling);
        }
        SQLPowerUtils.unlistenToHierarchy(e.getChild(), this);
        if (this.wouldEcho()) {
            return;
        }
        String uuid = e.getChild().getUUID();
        if (this.getRemovedObject(uuid) != null && this.getPersistedObject(uuid) == null) {
            throw new IllegalStateException("Cannot add object of type " + e.getChildType() + " with UUID " + uuid + " because an object with " + " the same UUID has already been removed");
        }
        PersistedSPObject pso = this.getPersistedObject(uuid);
        if (pso == null) {
            this.transactionStarted(TransactionEvent.createStartTransactionEvent(this, "Start of transaction triggered by childRemoved event"));
            this.objectsToRemove.put(e.getChild().getUUID(), new RemovedObjectEntry(e.getSource().getUUID(), e.getChild(), e.getIndex()));
            this.removedObjectsUUIDs.addAll(this.getDescendantUUIDs(e.getChild()));
            this.transactionEnded(TransactionEvent.createEndTransactionEvent(this));
        }
        this.persistedProperties.removeAll((Object)uuid);
        if (pso != null) {
            this.persistedObjects.remove(pso.getUUID());
            this.parentPeristedObjects.remove((Object)this.getParentPersistedObjectsId(pso), (Object)pso);
        }
        ArrayList<String> descendantUUIDs = new ArrayList<String>(this.getDescendantUUIDs(e.getChild()));
        descendantUUIDs.remove(uuid);
        for (String uuidToRemove : descendantUUIDs) {
            this.persistedProperties.removeAll((Object)uuidToRemove);
            PersistedSPObject childPSO = this.persistedObjects.get(uuidToRemove);
            this.persistedObjects.remove(uuidToRemove);
            if (childPSO == null) continue;
            this.parentPeristedObjects.remove((Object)this.getParentPersistedObjectsId(childPSO), (Object)childPSO);
        }
    }

    @Override
    public void transactionEnded(TransactionEvent e) {
        if (this.wouldEcho()) {
            return;
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("transactionEnded " + (e == null ? null : e.getMessage())));
            }
            this.commit();
        }
        catch (SPPersistenceException e1) {
            throw new RuntimeException(e1);
        }
    }

    @Override
    public void transactionRollback(TransactionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transactionRollback " + (e == null ? null : e.getMessage())));
        }
        this.rollback();
    }

    @Override
    public void transactionStarted(TransactionEvent e) {
        if (this.wouldEcho()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transactionStarted " + (e == null ? null : e.getMessage())));
        }
        ++this.transactionCount;
    }

    @Override
    public void propertyChanged(PropertyChangeEvent evt) {
        PropertyDescriptor propertyDescriptor;
        SPObject source = (SPObject)evt.getSource();
        String uuid = source.getUUID();
        String propertyName = evt.getPropertyName();
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        try {
            if (!PersisterHelperFinder.findPersister(source.getClass()).getPersistedProperties().contains(propertyName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Tried to persist a property that shouldn't be. Ignoring the property: " + propertyName));
                }
                return;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (!((SPObject)evt.getSource()).getRunnableDispatcher().isForegroundThread()) {
            throw new RuntimeException("Property change " + evt + " not fired on the foreground.");
        }
        Object oldBasicType = this.converter.convertToBasicType(oldValue, new Object[0]);
        Object newBasicType = this.converter.convertToBasicType(newValue, new Object[0]);
        PersistedSPOProperty property = null;
        for (PersistedSPOProperty p : this.persistedProperties.get((Object)uuid)) {
            if (!p.getPropertyName().equals(propertyName)) continue;
            property = p;
            break;
        }
        if (property != null) {
            boolean valuesMatch;
            if (property.getNewValue() == null) {
                valuesMatch = oldBasicType == null;
            } else {
                boolean bl = valuesMatch = property.getNewValue().equals(oldBasicType) || property.getOldValue().equals(oldBasicType) && property.getNewValue().equals(newBasicType);
            }
            if (!valuesMatch) {
                try {
                    throw new RuntimeException("Multiple property changes do not follow after each other properly. Property " + property.getPropertyName() + ", on object " + source + " of type " + source.getClass() + ", Old " + oldBasicType + ", new " + property.getNewValue());
                }
                catch (Throwable throwable) {
                    this.rollback();
                    throw throwable;
                }
            }
        }
        if (this.wouldEcho()) {
            this.persistedProperties.remove((Object)uuid, (Object)property);
            return;
        }
        this.transactionStarted(TransactionEvent.createStartTransactionEvent(this, PROPERTY_CHANGED_MSG));
        try {
            propertyDescriptor = PropertyUtils.getPropertyDescriptor((Object)source, (String)propertyName);
        }
        catch (Exception ex) {
            this.rollback();
            throw new RuntimeException(ex);
        }
        if (propertyDescriptor == null || propertyDescriptor.getWriteMethod() == null) {
            this.transactionEnded(TransactionEvent.createEndTransactionEvent(this));
            return;
        }
        SPPersister.DataType typeForClass = PersisterUtils.getDataType(newValue == null ? Void.class : newValue.getClass());
        boolean unconditional = false;
        if (property != null) {
            oldBasicType = property.getOldValue();
            unconditional = property.isUnconditional();
            this.persistedProperties.remove((Object)uuid, (Object)property);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("persistProperty(" + uuid + ", " + propertyName + ", " + typeForClass.name() + ", " + oldValue + ", " + newValue + ")"));
        }
        this.persistedProperties.put((Object)uuid, (Object)new PersistedSPOProperty(uuid, propertyName, typeForClass, oldBasicType, newBasicType, unconditional));
        this.transactionEnded(TransactionEvent.createEndTransactionEvent(this));
    }

    private boolean wouldEcho() {
        if (this.rollingBack) {
            return true;
        }
        if (this.rollbackPersister != null && this.rollbackPersister.isHeadingToWisconsin()) {
            return true;
        }
        return this.eventSource != null && this.eventSource.isUpdatingWorkspace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void commit() throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("commit(): transactionCount = " + this.transactionCount));
        }
        if (this.transactionCount == 1) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Calling commit...");
                }
                if (this.objectsToRemove.isEmpty() && this.persistedObjects.isEmpty() && this.persistedProperties.isEmpty()) {
                    return;
                }
                this.target.begin();
                this.commitRemovals();
                this.commitObjects();
                this.commitProperties();
                this.target.commit();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"...commit completed.");
                }
                if (!logger.isDebugEnabled()) return;
                try {
                    final Clip clip = AudioSystem.getClip();
                    clip.open(AudioSystem.getAudioInputStream(this.getClass().getResource("/sounds/transaction_complete.wav")));
                    clip.addLineListener(new LineListener(){

                        @Override
                        public void update(LineEvent event) {
                            if (event.getType().equals(LineEvent.Type.STOP)) {
                                logger.debug((Object)"Stopping sound");
                                clip.close();
                            }
                        }
                    });
                    clip.start();
                    return;
                }
                catch (Exception ex) {
                    logger.debug((Object)"A transaction committed but we cannot play the commit sound.", (Throwable)ex);
                }
                return;
            }
            catch (Throwable t) {
                logger.warn((Object)("Rolling back due to " + t), t);
                this.rollback();
                if (t instanceof SPPersistenceException) {
                    throw (SPPersistenceException)t;
                }
                if (!(t instanceof FriendlyRuntimeSPPersistenceException)) throw new SPPersistenceException(null, t);
                throw (FriendlyRuntimeSPPersistenceException)t;
            }
            finally {
                this.clear();
                this.transactionCount = 0;
            }
        } else {
            --this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.wouldEcho() || this.eventSource == null || this.eventSource.isHeadingToWisconsin()) {
            this.objectsToRemove.clear();
            this.removedObjectsUUIDs.clear();
            this.persistedObjects.clear();
            this.parentPeristedObjects.clear();
            this.persistedProperties.clear();
            this.transactionCount = 0;
            this.target.rollback();
            return;
        }
        this.rollingBack = true;
        SPObject workspace = this.eventSource.getWorkspaceContainer().getWorkspace();
        boolean initialMagic = workspace.isMagicEnabled();
        if (initialMagic) {
            workspace.setMagicEnabled(false);
        }
        try {
            if (this.rollbackPersister == null) {
                LinkedList<PersistedObjectEntry> rollbackObjects = new LinkedList<PersistedObjectEntry>();
                LinkedList<PersistedPropertiesEntry> rollbackProperties = new LinkedList<PersistedPropertiesEntry>();
                for (PersistedSPObject o : this.persistedObjects.values()) {
                    rollbackObjects.add(new PersistedObjectEntry(o.getParentUUID(), o.getUUID()));
                }
                for (PersistedSPOProperty p : this.persistedProperties.values()) {
                    rollbackProperties.add(new PersistedPropertiesEntry(p.getUUID(), p.getPropertyName(), p.getDataType(), p.getOldValue()));
                }
                SPSessionPersister.undoForSession(this.eventSource.getWorkspaceContainer().getWorkspace(), rollbackObjects, rollbackProperties, this.objectsToRemove, this.converter);
            }
        }
        catch (SPPersistenceException e) {
            logger.error((Object)e);
        }
        finally {
            this.objectsToRemove.clear();
            this.removedObjectsUUIDs.clear();
            this.persistedObjects.clear();
            this.parentPeristedObjects.clear();
            this.persistedProperties.clear();
            this.transactionCount = 0;
            this.rollingBack = false;
            this.target.rollback();
            if (initialMagic) {
                this.eventSource.getWorkspaceContainer().getWorkspace().setMagicEnabled(true);
            }
        }
    }

    private void commitObjects() throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Committing objects");
        }
        for (PersistedSPObject pwo : this.persistedObjects.values()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Commiting persist call: " + pwo));
            }
            this.target.persistObject(pwo.getParentUUID(), pwo.getType(), pwo.getUUID(), pwo.getIndex());
        }
    }

    private void commitProperties() throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"commitProperties()");
        }
        for (PersistedSPOProperty property : this.persistedProperties.values()) {
            if (this.removedObjectsUUIDs.contains(property.getUUID())) continue;
            if (property.isUnconditional()) {
                this.target.persistProperty(property.getUUID(), property.getPropertyName(), property.getDataType(), property.getNewValue());
                continue;
            }
            this.target.persistProperty(property.getUUID(), property.getPropertyName(), property.getDataType(), property.getOldValue(), property.getNewValue());
        }
    }

    private void commitRemovals() throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"commitRemovals()");
        }
        for (RemovedObjectEntry entry : this.objectsToRemove.values()) {
            if (this.removedObjectsUUIDs.contains(entry.getParentUUID())) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("target.removeObject(" + entry.getParentUUID() + ", " + entry.getRemovedChild().getUUID() + ")"));
            }
            this.target.removeObject(entry.getParentUUID(), entry.getRemovedChild().getUUID());
        }
    }

    public List<PersistedSPOProperty> getPersistedProperties() {
        return new LinkedList<PersistedSPOProperty>(this.persistedProperties.values());
    }

    public List<PersistedSPObject> getPersistedObjects() {
        return new ArrayList<PersistedSPObject>(this.persistedObjects.values());
    }

    public LinkedHashMap<String, RemovedObjectEntry> getObjectsToRemove() {
        return this.objectsToRemove;
    }

    public PersistedSPObject getPersistedObject(String uuid) {
        return this.persistedObjects.get(uuid);
    }

    public RemovedObjectEntry getRemovedObject(String uuid) {
        return this.objectsToRemove.get(uuid);
    }

    public Set<String> getDescendantUUIDs(SPObject parent) {
        HashSet<String> uuids = new HashSet<String>();
        uuids.add(parent.getUUID());
        List<? extends SPObject> children = parent instanceof SQLObject ? ((SQLObject)parent).getChildrenWithoutPopulating() : parent.getChildren();
        for (SPObject sPObject : children) {
            uuids.addAll(this.getDescendantUUIDs(sPObject));
        }
        return uuids;
    }

    public void clear() {
        this.objectsToRemove.clear();
        this.removedObjectsUUIDs.clear();
        this.persistedObjects.clear();
        this.parentPeristedObjects.clear();
        this.persistedProperties.clear();
    }

    public boolean isInTransaction() {
        return this.transactionCount > 0;
    }

    public void setEventSource(SPSessionPersister eventSource) {
        if (this.isInTransaction()) {
            throw new IllegalStateException("Cannot set the event source when in a transaction!");
        }
        this.eventSource = eventSource;
    }
}

