/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.FriendlyRuntimeSPPersistenceException;
import ca.sqlpower.dao.PersistedObjectComparator;
import ca.sqlpower.dao.PersistedObjectEntry;
import ca.sqlpower.dao.PersistedPropertiesEntry;
import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.dao.RemovedObjectEntry;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.helper.PersisterHelperFinder;
import ca.sqlpower.dao.helper.SPPersisterHelper;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.WorkspaceContainer;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.beans.PropertyChangeEvent;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public abstract class SPSessionPersister
implements SPPersister {
    private boolean godMode = false;
    private static final Logger logger = Logger.getLogger(SPSessionPersister.class);
    private WorkspaceContainer workspaceContainer;
    private int transactionCount = 0;
    protected Multimap<String, PersistedSPOProperty> persistedProperties = LinkedListMultimap.create();
    private List<PersistedPropertiesEntry> persistedPropertiesRollbackList = new LinkedList<PersistedPropertiesEntry>();
    protected List<PersistedSPObject> persistedObjects = new LinkedList<PersistedSPObject>();
    private final Map<String, SPObject> lookupCache = new HashMap<String, SPObject>();
    protected Map<String, PersistedSPObject> persistedObjectsMap = new HashMap<String, PersistedSPObject>();
    private List<PersistedObjectEntry> persistedObjectsRollbackList = new LinkedList<PersistedObjectEntry>();
    protected final Comparator<String> removedObjectComparator = new Comparator<String>(){

        @Override
        public int compare(String uuid1, String uuid2) {
            int c;
            SPObject spo1 = SPSessionPersister.this.findByUuid(SPSessionPersister.this.root, uuid1, SPObject.class);
            SPObject spo2 = SPSessionPersister.this.findByUuid(SPSessionPersister.this.root, uuid2, SPObject.class);
            if (uuid1.equals(uuid2)) {
                return 0;
            }
            if (spo1 == null && spo2 == null) {
                return uuid2.compareTo(uuid1);
            }
            if (spo1 == null) {
                return -1;
            }
            if (spo2 == null) {
                return 1;
            }
            if (spo1.getParent() == null && spo2.getParent() == null) {
                return 0;
            }
            if (spo1.getParent() == null) {
                return 1;
            }
            if (spo2.getParent() == null) {
                return -1;
            }
            if (spo1.equals(spo2)) {
                return 0;
            }
            if (spo1.getParent().equals(spo2.getParent())) {
                List<? extends SPObject> siblings = spo1.getParent() instanceof SQLObject ? ((SQLObject)spo1.getParent()).getChildrenWithoutPopulating() : spo1.getParent().getChildren();
                return Integer.signum(siblings.indexOf(spo2) - siblings.indexOf(spo1));
            }
            List<SPObject> ancestorList1 = SQLPowerUtils.getAncestorList(spo1);
            List<SPObject> ancestorList2 = SQLPowerUtils.getAncestorList(spo2);
            SPObject previousAncestor = null;
            SPObject ancestor1 = spo1;
            SPObject ancestor2 = spo2;
            boolean compareWithAncestor = false;
            int i = 0;
            for (int j = 0; i < ancestorList1.size() && j < ancestorList2.size(); ++i, ++j) {
                ancestor1 = ancestorList1.get(i);
                ancestor2 = ancestorList2.get(j);
                if (previousAncestor != null && !ancestor1.equals(ancestor2)) {
                    compareWithAncestor = true;
                    break;
                }
                previousAncestor = ancestor1;
            }
            if (!compareWithAncestor) {
                if (ancestorList1.size() < ancestorList2.size()) {
                    ancestor1 = spo1;
                    ancestor2 = ancestorList2.get(ancestorList1.size());
                } else if (ancestorList1.size() > ancestorList2.size()) {
                    ancestor1 = ancestorList1.get(ancestorList2.size());
                    ancestor2 = spo2;
                } else {
                    ancestor1 = spo1;
                    ancestor2 = spo2;
                }
            }
            if (ancestor1.equals(ancestor2)) {
                c = ancestorList2.size() - ancestorList1.size();
            } else if (ancestor1.getClass() == ancestor2.getClass()) {
                List<? extends SPObject> siblings = previousAncestor instanceof SQLObject ? ((SQLObject)previousAncestor).getChildrenWithoutPopulating() : previousAncestor.getChildren();
                int index1 = siblings.indexOf(ancestor1);
                int index2 = siblings.indexOf(ancestor2);
                c = index2 - index1;
            } else {
                c = uuid2.compareTo(uuid1);
            }
            return Integer.signum(c);
        }
    };
    protected Map<String, String> objectsToRemove = new HashMap<String, String>();
    private boolean disableMagic = true;
    private boolean rollbackOnCommitError = true;
    private LinkedHashMap<String, RemovedObjectEntry> objectsToRemoveRollbackList = new LinkedHashMap();
    protected final SPObject root;
    private final String name;
    private Thread currentThread;
    private boolean headingToWisconsin;
    protected final SessionPersisterSuperConverter converter;
    protected boolean correctSQLImportOrder = true;

    private void setPersistedProperties(Multimap<String, PersistedSPOProperty> persistedProperties) {
        this.persistedProperties = persistedProperties;
    }

    private void setPersistedObjects(List<PersistedSPObject> persistedObjects) {
        this.persistedObjects = persistedObjects;
        this.persistedObjectsMap.clear();
        for (PersistedSPObject pso : persistedObjects) {
            this.persistedObjectsMap.put(pso.getUUID(), pso);
        }
    }

    private void setObjectsToRemove(Map<String, String> objectsToRemove) {
        this.objectsToRemove = objectsToRemove;
    }

    public SPSessionPersister(String name, SPObject root, SessionPersisterSuperConverter converter) {
        this.name = name;
        this.root = root;
        this.converter = converter;
    }

    public String toString() {
        return "SPSessionPersister \"" + this.name + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void begin() throws SPPersistenceException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            this.enforceThreadSafety();
            if (this.transactionCount == 0) {
                this.lookupCache.clear();
                this.converter.setUUIDCache(this.lookupCache);
            }
            ++this.transactionCount;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("spsp.begin(); - transaction count : " + this.transactionCount));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SPPersistenceException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            SPObject workspace;
            this.enforceThreadSafety();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("spsp.commit(); - transaction count : " + this.transactionCount));
            }
            SPObject sPObject = workspace = this.getWorkspaceContainer().getWorkspace();
            synchronized (sPObject) {
                try {
                    if (this.disableMagic) {
                        workspace.setMagicEnabled(false);
                    }
                    if (this.transactionCount == 0) {
                        throw new SPPersistenceException(null, "Commit attempted while not in a transaction");
                    }
                    this.objectsToRemoveRollbackList.clear();
                    this.persistedObjectsRollbackList.clear();
                    this.persistedPropertiesRollbackList.clear();
                    if (this.transactionCount == 1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Begin of commit phase...");
                            logger.debug((Object)("Committing " + this.persistedObjects.size() + " new objects, " + this.persistedProperties.size() + " changes to different property names, and " + this.objectsToRemove.size() + " objects are being removed."));
                        }
                        workspace.begin("Begin batch transaction...");
                        this.commitRemovals();
                        this.commitObjects();
                        this.commitProperties();
                        workspace.commit();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"...commit succeeded.");
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"SPSessionPersister caught an exception while performing a commit operation. Will try to rollback...", t);
                    if (this.rollbackOnCommitError) {
                        this.rollback();
                    }
                    if (t instanceof SPPersistenceException) {
                        throw (SPPersistenceException)t;
                    }
                    if (t instanceof FriendlyRuntimeSPPersistenceException) {
                        throw (FriendlyRuntimeSPPersistenceException)t;
                    }
                    throw new SPPersistenceException(null, t);
                }
                finally {
                    if (this.transactionCount > 0) {
                        --this.transactionCount;
                        if (this.transactionCount == 0) {
                            this.objectsToRemove.clear();
                            this.objectsToRemoveRollbackList.clear();
                            this.persistedObjects.clear();
                            this.persistedObjectsMap.clear();
                            this.persistedObjectsRollbackList.clear();
                            this.persistedProperties.clear();
                            this.persistedPropertiesRollbackList.clear();
                            this.lookupCache.clear();
                            this.converter.removeUUIDCache();
                            this.currentThread = null;
                        }
                    }
                    if (this.disableMagic) {
                        workspace.setMagicEnabled(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Persisting object " + uuid + " of type " + type + " as a child to " + parentUUID));
        }
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            this.enforceThreadSafety();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("spsp.persistObject(\"%s\", \"%s\", \"%s\", %d);", parentUUID, type, uuid, index));
            }
            if (this.transactionCount == 0) {
                this.rollback();
                throw new SPPersistenceException("Cannot persist objects while outside a transaction.");
            }
            SPObject objectToPersist = this.findByUuid(this.root, uuid, SPObject.class);
            if (this.exists(uuid) && objectToPersist.getClass() != this.root.getClass()) {
                if (this.godMode) {
                    return;
                }
                this.rollback();
                throw new SPPersistenceException(uuid, "An SPObject with UUID " + uuid + " and type " + type + " under parent with UUID " + parentUUID + " already exists.\n" + " The object exists in the root already? " + (objectToPersist != null) + "\n" + " The persisted objects map contains keys: " + this.persistedObjectsMap.keySet() + "\n" + " The persisted properties map contains values for this object? " + (this.persistedProperties.get((Object)uuid) != null && !this.persistedProperties.get((Object)uuid).isEmpty()) + "\n" + " The removed set contains the object? " + this.objectsToRemove.containsKey(uuid));
            }
            PersistedSPObject pso = new PersistedSPObject(parentUUID, type, uuid, index);
            this.persistedObjects.add(pso);
            this.persistedObjectsMap.put(pso.getUUID(), pso);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        if (this.transactionCount <= 0) {
            this.rollback();
            throw new SPPersistenceException(null, "Cannot persist objects while outside a transaction.");
        }
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            this.enforceThreadSafety();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("spsp.persistProperty(\"%s\", \"%s\", DataType.%s, %s, %s);", uuid, propertyName, propertyType.name(), oldValue, newValue));
            }
            try {
                this.persistPropertyHelper(uuid, propertyName, propertyType, oldValue, newValue, this.godMode);
            }
            catch (SPPersistenceException e) {
                this.rollback();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Persisting property " + propertyName + ", changing to " + newValue));
        }
        if (this.transactionCount <= 0) {
            this.rollback();
            throw new SPPersistenceException("Cannot persist objects while outside a transaction.");
        }
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            this.enforceThreadSafety();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("spsp.persistProperty(\"%s\", \"%s\", DataType.%s, %s); // unconditional", uuid, propertyName, propertyType.name(), newValue));
            }
            try {
                if (newValue instanceof InputStream && !((InputStream)newValue).markSupported()) {
                    newValue = new BufferedInputStream((InputStream)newValue);
                }
                this.persistPropertyHelper(uuid, propertyName, propertyType, newValue, newValue, true);
            }
            catch (SPPersistenceException e) {
                this.rollback();
                throw e;
            }
        }
    }

    private void persistPropertyHelper(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue, boolean unconditional) throws SPPersistenceException {
        if (!this.exists(uuid)) {
            throw new SPPersistenceException(uuid, "SPObject with UUID " + uuid + " could not be found." + " Was trying to set its property \"" + propertyName + "\" " + "to value \"" + newValue + "\".");
        }
        Object lastPropertyValueFound = null;
        for (PersistedSPOProperty persistedProperty : this.persistedProperties.get((Object)uuid)) {
            if (!propertyName.equals(persistedProperty.getPropertyName())) continue;
            lastPropertyValueFound = persistedProperty.getNewValue();
        }
        Object propertyValue = null;
        SPObject spo = this.findByUuid(this.root, uuid, SPObject.class);
        if (lastPropertyValueFound != null) {
            if (!unconditional && !lastPropertyValueFound.equals(oldValue)) {
                throw new SPPersistenceException(uuid, "For property \"" + propertyName + "\", the expected property value \"" + oldValue + "\" does not match with the actual property value \"" + lastPropertyValueFound + "\"");
            }
        } else if (!unconditional && spo != null) {
            try {
                propertyValue = PersisterHelperFinder.findPersister(spo.getClass()).findProperty(spo, propertyName, this.converter);
            }
            catch (Exception e) {
                throw new SPPersistenceException("Could not find the persister helper for " + spo.getClass(), e);
            }
            if (propertyValue != null && oldValue == null) {
                throw new SPPersistenceException(uuid, "For property \"" + propertyName + "\" on SPObject of type " + spo.getClass() + " and UUID + " + spo.getUUID() + ", the expected property value \"" + oldValue + "\" does not match with the actual property value \"" + propertyValue + "\"");
            }
        }
        if (spo != null) {
            this.persistedProperties.put((Object)uuid, (Object)new PersistedSPOProperty(uuid, propertyName, propertyType, propertyValue, newValue, unconditional));
        } else {
            this.persistedProperties.put((Object)uuid, (Object)new PersistedSPOProperty(uuid, propertyName, propertyType, oldValue, newValue, unconditional));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        WorkspaceContainer workspaceContainer = this.getWorkspaceContainer();
        synchronized (workspaceContainer) {
            this.enforceThreadSafety();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("spsp.removeObject(\"%s\", \"%s\");", parentUUID, uuid));
            }
            if (this.transactionCount == 0) {
                logger.error((Object)"Remove Object attempted while not in a transaction. Rollback initiated.");
                this.rollback();
                throw new SPPersistenceException(uuid, "Remove Object attempted while not in a transaction. Rollback initiated.");
            }
            SPObject spo = this.findByUuid(this.root, uuid, SPObject.class);
            if (spo == null) {
                this.rollback();
                throw new SPPersistenceException(uuid, "Cannot remove the SPObject with UUID " + uuid + " from parent UUID " + parentUUID + " as it does not exist.");
            }
            this.objectsToRemove.put(uuid, parentUUID);
        }
    }

    @Override
    public void rollback() {
        this.rollback(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(boolean force) {
        SPObject workspace;
        SPObject sPObject = workspace = this.getWorkspaceContainer().getWorkspace();
        synchronized (sPObject) {
            if (this.headingToWisconsin) {
                return;
            }
            this.headingToWisconsin = true;
            if (!force) {
                this.enforceThreadSafety();
            }
            try {
                if (this.disableMagic) {
                    workspace.setMagicEnabled(false);
                }
                workspace.begin("Rolling back changes.");
                this.rollbackProperties();
                this.rollbackCreations();
                this.rollbackRemovals();
                workspace.commit("Done Rolling back");
                workspace.rollback("Rolling back all listeners on the workspace as they should have any transaction counters reset.");
            }
            catch (Exception e) {
                logger.fatal((Object)"First try at restore failed.", (Throwable)e);
            }
            finally {
                if (this.disableMagic) {
                    workspace.setMagicEnabled(true);
                }
                this.objectsToRemove.clear();
                this.objectsToRemoveRollbackList.clear();
                this.persistedObjects.clear();
                this.persistedObjectsMap.clear();
                this.persistedObjectsRollbackList.clear();
                this.persistedProperties.clear();
                this.persistedPropertiesRollbackList.clear();
                this.lookupCache.clear();
                this.converter.removeUUIDCache();
                this.transactionCount = 0;
                this.currentThread = null;
                this.headingToWisconsin = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"spsp.rollback(); - Killed all current transactions.");
                }
            }
        }
    }

    private void commitRemovals() throws SPPersistenceException {
        TreeMap<String, String> sortedObjectsToRemove = new TreeMap<String, String>(this.removedObjectComparator);
        sortedObjectsToRemove.putAll(this.objectsToRemove);
        for (Map.Entry removeEntry : sortedObjectsToRemove.entrySet()) {
            SPObject spo = this.findByUuid(this.root, (String)removeEntry.getKey(), SPObject.class);
            if (spo == null) {
                boolean descendantRemoved = false;
                for (RemovedObjectEntry removedRollbackEntry : this.objectsToRemoveRollbackList.values()) {
                    if (SQLPowerUtils.findByUuid(removedRollbackEntry.getRemovedChild(), (String)removeEntry.getKey(), SPObject.class) == null) continue;
                    descendantRemoved = true;
                    break;
                }
                if (descendantRemoved) continue;
            }
            SPObject parent = this.findByUuid(this.root, (String)removeEntry.getValue(), SPObject.class);
            try {
                List<SPObject> siblings;
                if (parent instanceof SQLObject) {
                    siblings = ((SQLObject)parent).getChildrenWithoutPopulating();
                } else {
                    if (parent == null) {
                        throw new NullPointerException("The parent with id " + (String)removeEntry.getValue() + " is missing. However, to get here the spo with id " + (String)removeEntry.getKey() + " must not have been null. The spo is " + spo);
                    }
                    siblings = parent.getChildren();
                }
                int index = siblings.indexOf(spo);
                parent.removeChild(spo);
                this.removeRollBackList(spo, parent, index -= parent.childPositionOffset(spo.getClass()));
                Set<String> removedKeys = SQLPowerUtils.buildIdMap(spo).keySet();
                for (String removedKey : removedKeys) {
                    this.lookupCache.remove(removedKey);
                }
            }
            catch (IllegalArgumentException e) {
                throw new SPPersistenceException((String)removeEntry.getKey(), e);
            }
            catch (ObjectDependentException e) {
                throw new SPPersistenceException((String)removeEntry.getKey(), e);
            }
        }
        if (this.objectsToRemoveRollbackList.size() != this.objectsToRemove.size()) {
            logger.warn((Object)"Skipped some objects");
        }
        this.objectsToRemove.clear();
    }

    private void removeRollBackList(SPObject object, SPObject parent, int index) {
        this.objectsToRemoveRollbackList.put(object.getUUID(), new RemovedObjectEntry(parent.getUUID(), object, index));
    }

    protected void commitObjects() throws SPPersistenceException {
        Collections.sort(this.persistedObjects, this.getComparator());
        if (this.correctSQLImportOrder) {
            ArrayList<PersistedSPObject> rImportedKeys = new ArrayList<PersistedSPObject>();
            for (int i = 0; i < this.persistedObjects.size(); ++i) {
                if (!this.persistedObjects.get(i).getType().equals(SQLRelationship.SQLImportedKey.class.getName())) continue;
                rImportedKeys.add(this.persistedObjects.get(i));
            }
            this.persistedObjects.removeAll(rImportedKeys);
            this.persistedObjects.addAll(rImportedKeys);
        }
        this.commitSortedObjects();
    }

    protected Comparator<? super PersistedSPObject> getComparator() {
        return new PersistedObjectComparator(this.root, this.persistedObjectsMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitSortedObjects() throws SPPersistenceException {
        for (PersistedSPObject pso : this.persistedObjects) {
            Class<? extends SPObject> parentAllowedChildType;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Persisting " + pso));
            }
            if (pso.isLoaded()) continue;
            SPObject parent = this.findByUuid(this.root, pso.getParentUUID(), SPObject.class);
            SPObject spo = null;
            if (parent == null && pso.getType().equals(this.root.getClass().getName())) {
                this.lookupCache.clear();
                this.refreshRootNode(pso);
                this.lookupCache.clear();
                continue;
            }
            if (parent == null) {
                throw new IllegalStateException("Missing parent with uuid " + pso.getParentUUID() + " when trying to load " + pso);
            }
            try {
                parentAllowedChildType = PersisterUtils.getParentAllowedChildType(pso.getType(), parent.getClass().getName());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            List<? extends SPObject> siblings = parent instanceof SQLObject ? ((SQLObject)parent).getChildrenWithoutPopulating(parentAllowedChildType) : parent.getChildren(parentAllowedChildType);
            if (this.objectsToRemoveRollbackList.keySet().contains(parent.getUUID())) {
                for (SPObject sPObject : siblings) {
                    if (!sPObject.getUUID().equals(pso.getUUID())) continue;
                    spo = sPObject;
                    break;
                }
            }
            if (spo == null) {
                block14: for (SPObject sPObject : SQLPowerUtils.getAncestorList(parent)) {
                    if (!this.objectsToRemoveRollbackList.keySet().contains(sPObject.getUUID())) continue;
                    for (SPObject sPObject2 : siblings) {
                        if (!sPObject2.getUUID().equals(pso.getUUID())) continue;
                        spo = sPObject2;
                        break block14;
                    }
                }
            }
            if (spo != null) {
                this.removeFinalPersistProperties(pso);
                continue;
            }
            if (this.objectsToRemoveRollbackList.get(pso.getUUID()) != null) {
                spo = this.objectsToRemoveRollbackList.get(pso.getUUID()).getRemovedChild();
                this.removeFinalPersistProperties(pso);
            } else {
                if (parent instanceof SQLObject && this.populateSQLObject((SQLObject)parent)) continue;
                try {
                    spo = PersisterHelperFinder.findPersister(pso.getType()).commitObject(pso, this.persistedProperties, this.persistedObjects, this.converter);
                }
                catch (Exception ex) {
                    throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
                }
            }
            if (spo == null) continue;
            SPListener removeChildOnAddListener = new SPListener(){

                @Override
                public void propertyChanged(PropertyChangeEvent arg0) {
                }

                @Override
                public void childRemoved(SPChildEvent e) {
                    SPSessionPersister.this.objectsToRemoveRollbackList.put(e.getChild().getUUID(), new RemovedObjectEntry(e.getSource().getUUID(), e.getChild(), e.getIndex()));
                }

                @Override
                public void childAdded(SPChildEvent e) {
                }

                @Override
                public void transactionStarted(TransactionEvent e) {
                }

                @Override
                public void transactionRollback(TransactionEvent e) {
                }

                @Override
                public void transactionEnded(TransactionEvent e) {
                }
            };
            try {
                parent.addSPListener(removeChildOnAddListener);
                try {
                    parent.addChild(spo, Math.min(pso.getIndex(), siblings.size()));
                    this.persistedObjectsRollbackList.add(new PersistedObjectEntry(parent.getUUID(), spo.getUUID()));
                    this.lookupCache.putAll(SQLPowerUtils.buildIdMap(spo));
                }
                catch (RuntimeException runtimeException) {
                    if (parent.getChildren().contains(spo)) {
                        try {
                            parent.removeChild(spo);
                        }
                        catch (RuntimeException ex) {
                            logger.error((Object)"Failed to add the child and now cannot remove the child.", (Throwable)ex);
                        }
                        catch (ObjectDependentException ex) {
                            logger.error((Object)"Failed to add the child and now cannot remove the child.", (Throwable)ex);
                        }
                    }
                    throw runtimeException;
                }
            }
            finally {
                parent.removeSPListener(removeChildOnAddListener);
            }
        }
        this.persistedObjects.clear();
        this.persistedObjectsMap.clear();
    }

    private void removeFinalPersistProperties(PersistedSPObject pso) throws SPPersistenceException {
        List<String> persistedPropNames;
        try {
            persistedPropNames = PersisterHelperFinder.findPersister(pso.getType()).getPersistedProperties();
        }
        catch (Exception ex) {
            throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
        }
        ArrayList<PersistedSPOProperty> propertiesToRemove = new ArrayList<PersistedSPOProperty>();
        for (PersistedSPOProperty spoProperty : this.persistedProperties.get((Object)pso.getUUID())) {
            if (persistedPropNames.contains(spoProperty.getPropertyName())) continue;
            propertiesToRemove.add(spoProperty);
        }
        for (PersistedSPOProperty spoProperty : propertiesToRemove) {
            this.persistedProperties.get((Object)pso.getUUID()).remove(spoProperty);
        }
    }

    private boolean populateSQLObject(SQLObject parent) throws SPPersistenceException {
        if (!(parent instanceof SQLTable || parent instanceof SQLDatabase || parent instanceof SQLSchema || parent instanceof SQLCatalog)) {
            return false;
        }
        ArrayList childrenForPopulate = new ArrayList();
        if (parent instanceof SQLTable) {
            SQLObject spo;
            ArrayList<SQLObject> children;
            Boolean columnsPopulated = PersisterUtils.findPersistedBooleanProperty(this.persistedProperties, parent.getUUID(), "columnsPopulated");
            Boolean indicesPopulated = PersisterUtils.findPersistedBooleanProperty(this.persistedProperties, parent.getUUID(), "indicesPopulated");
            Boolean exportedKeysPopulated = PersisterUtils.findPersistedBooleanProperty(this.persistedProperties, parent.getUUID(), "exportedKeysPopulated");
            Boolean importedKeysPopulated = PersisterUtils.findPersistedBooleanProperty(this.persistedProperties, parent.getUUID(), "importedKeysPopulated");
            SQLTable table = (SQLTable)parent;
            if (!table.isColumnsPopulated() && columnsPopulated != null && columnsPopulated.booleanValue()) {
                ArrayList<PersistedSPObject> columnsForPopulate = new ArrayList<PersistedSPObject>();
                for (PersistedSPObject spo2 : this.persistedObjects) {
                    if (spo2.isLoaded() || !spo2.getParentUUID().equals(parent.getUUID()) || !spo2.getType().equals(SQLColumn.class.getName())) continue;
                    columnsForPopulate.add(spo2);
                }
                children = new ArrayList<SQLObject>();
                for (PersistedSPObject pso : columnsForPopulate) {
                    try {
                        spo = (SQLObject)PersisterHelperFinder.findPersister(pso.getType()).commitObject(pso, this.persistedProperties, this.persistedObjects, this.converter);
                        children.add(spo);
                    }
                    catch (Exception ex) {
                        throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
                    }
                }
                SQLObjectUtils.populateChildrenWithList(parent, children);
                childrenForPopulate.addAll(columnsForPopulate);
                if (columnsForPopulate.isEmpty()) {
                    table.setColumnsPopulated(columnsPopulated);
                }
            }
            if (!table.isIndicesPopulated() && indicesPopulated != null && indicesPopulated.booleanValue()) {
                ArrayList<PersistedSPObject> indicesForPopulate = new ArrayList<PersistedSPObject>();
                for (PersistedSPObject spo2 : this.persistedObjects) {
                    if (spo2.isLoaded() || !spo2.getParentUUID().equals(parent.getUUID()) || !spo2.getType().equals(SQLIndex.class.getName())) continue;
                    indicesForPopulate.add(spo2);
                }
                children = new ArrayList();
                for (PersistedSPObject pso : indicesForPopulate) {
                    try {
                        spo = (SQLObject)PersisterHelperFinder.findPersister(pso.getType()).commitObject(pso, this.persistedProperties, this.persistedObjects, this.converter);
                        children.add(spo);
                    }
                    catch (Exception ex) {
                        throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
                    }
                }
                SQLObjectUtils.populateChildrenWithList(parent, children);
                childrenForPopulate.addAll(indicesForPopulate);
                if (indicesForPopulate.isEmpty()) {
                    table.setIndicesPopulated(indicesPopulated);
                }
            }
            if (!table.isExportedKeysPopulated() && exportedKeysPopulated != null && exportedKeysPopulated.booleanValue()) {
                ArrayList<PersistedSPObject> exportedKeysForPopulate = new ArrayList<PersistedSPObject>();
                for (PersistedSPObject spo2 : this.persistedObjects) {
                    if (spo2.isLoaded() || !spo2.getParentUUID().equals(parent.getUUID()) || !spo2.getType().equals(SQLRelationship.class.getName())) continue;
                    exportedKeysForPopulate.add(spo2);
                }
                children = new ArrayList();
                for (PersistedSPObject pso : exportedKeysForPopulate) {
                    try {
                        spo = (SQLObject)PersisterHelperFinder.findPersister(pso.getType()).commitObject(pso, this.persistedProperties, this.persistedObjects, this.converter);
                        children.add(spo);
                    }
                    catch (Exception ex) {
                        throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
                    }
                }
                SQLObjectUtils.populateChildrenWithList(parent, children);
                childrenForPopulate.addAll(exportedKeysForPopulate);
            }
        } else {
            Boolean populated = PersisterUtils.findPersistedBooleanProperty(this.persistedProperties, parent.getUUID(), "populated");
            if (!parent.isPopulated() && populated != null && populated.booleanValue()) {
                for (PersistedSPObject spo : this.persistedObjects) {
                    if (spo.isLoaded() || !spo.getParentUUID().equals(parent.getUUID())) continue;
                    childrenForPopulate.add(spo);
                }
            }
            ArrayList<SQLObject> children = new ArrayList<SQLObject>();
            for (PersistedSPObject pso : childrenForPopulate) {
                try {
                    SQLObject spo = (SQLObject)PersisterHelperFinder.findPersister(pso.getType()).commitObject(pso, this.persistedProperties, this.persistedObjects, this.converter);
                    children.add(spo);
                }
                catch (Exception ex) {
                    throw new SPPersistenceException("Could not find the persister helper for " + pso.getType(), ex);
                }
            }
            SQLObjectUtils.populateChildrenWithList(parent, children);
        }
        if (!childrenForPopulate.isEmpty()) {
            for (PersistedSPObject spo : childrenForPopulate) {
                this.persistedObjectsRollbackList.add(new PersistedObjectEntry(parent.getUUID(), spo.getUUID()));
            }
            return true;
        }
        return false;
    }

    protected abstract void refreshRootNode(PersistedSPObject var1);

    private void commitProperties() throws SPPersistenceException {
        for (String uuid : this.persistedProperties.keySet()) {
            SPObject spo = this.findByUuid(this.root, uuid, SPObject.class);
            if (spo == null) {
                throw new IllegalStateException("Couldn't locate object " + uuid + " in session");
            }
            for (PersistedSPOProperty persistedProperty : this.persistedProperties.get((Object)uuid)) {
                Object oldValue;
                String propertyName = persistedProperty.getPropertyName();
                Object newValue = persistedProperty.getNewValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Applying property " + propertyName + " to " + spo.getClass().getSimpleName() + " at " + spo.getUUID()));
                }
                try {
                    SPPersisterHelper<? extends SPObject> persisterHelper = PersisterHelperFinder.findPersister(spo.getClass());
                    oldValue = persisterHelper.findProperty(spo, propertyName, this.converter);
                    persisterHelper.commitProperty(spo, propertyName, newValue, persistedProperty.getDataType(), this.converter);
                }
                catch (Exception e) {
                    throw new SPPersistenceException("Could not find the persister helper for " + spo.getClass(), e);
                }
                if (!persistedProperty.isUnconditional()) {
                    oldValue = persistedProperty.getOldValue();
                }
                this.persistedPropertiesRollbackList.add(new PersistedPropertiesEntry(spo.getUUID(), persistedProperty.getPropertyName(), persistedProperty.getDataType(), oldValue));
            }
        }
        this.persistedProperties.clear();
    }

    private void rollbackRemovals() {
        ArrayList<RemovedObjectEntry> removedObjects = new ArrayList<RemovedObjectEntry>(this.objectsToRemoveRollbackList.values());
        Collections.reverse(removedObjects);
        for (RemovedObjectEntry entry : removedObjects) {
            String parentUuid = entry.getParentUUID();
            SPObject objectToRestore = entry.getRemovedChild();
            int index = entry.getIndex();
            SPObject parent = this.findByUuid(this.root, parentUuid, SPObject.class);
            try {
                if (parent.getChildren().contains(objectToRestore)) continue;
                parent.addChild(objectToRestore, index);
            }
            catch (Throwable t) {
                logger.error((Object)("Cannot rollback " + entry.getRemovedChild() + " child removal"), t);
            }
        }
    }

    private void rollbackProperties() {
        Collections.reverse(this.persistedPropertiesRollbackList);
        HashSet<String> objectCreationRollbackUUIDs = new HashSet<String>();
        for (PersistedObjectEntry persistedObjectEntry : this.persistedObjectsRollbackList) {
            objectCreationRollbackUUIDs.add(persistedObjectEntry.getChildId());
        }
        for (PersistedPropertiesEntry persistedPropertiesEntry : this.persistedPropertiesRollbackList) {
            try {
                String parentUUID = persistedPropertiesEntry.getUUID();
                if (objectCreationRollbackUUIDs.contains(parentUUID)) continue;
                String propertyName = persistedPropertiesEntry.getPropertyName();
                Object rollbackValue = persistedPropertiesEntry.getRollbackValue();
                SPObject parent = this.findByUuid(this.root, parentUUID, SPObject.class);
                if (parent == null) continue;
                PersisterHelperFinder.findPersister(parent.getClass()).commitProperty(parent, propertyName, rollbackValue, persistedPropertiesEntry.getPropertyType(), this.converter);
            }
            catch (Throwable t) {
                logger.error((Object)("Cannot rollback change to " + persistedPropertiesEntry.getPropertyName() + " to value " + persistedPropertiesEntry.getRollbackValue()), t);
            }
        }
    }

    private void rollbackCreations() {
        Collections.reverse(this.persistedObjectsRollbackList);
        for (PersistedObjectEntry entry : this.persistedObjectsRollbackList) {
            try {
                if (entry.getParentId() == null) continue;
                SPObject parent = this.findByUuid(this.root, entry.getParentId(), SPObject.class);
                SPObject child = this.findByUuid(this.root, entry.getChildId(), SPObject.class);
                parent.removeChild(child);
            }
            catch (Throwable t) {
                logger.error((Object)("Cannot rollback " + entry.getChildId() + " child creation"), t);
            }
        }
    }

    private boolean exists(String uuid) {
        if (this.persistedObjectsMap.get(uuid) != null) {
            return true;
        }
        SPObject spo = this.findByUuid(this.root, uuid, SPObject.class);
        if (spo != null) {
            List<SPObject> ancestors = SQLPowerUtils.getAncestorList(spo);
            ancestors.add(spo);
            for (SPObject ancestor : ancestors) {
                if (!this.objectsToRemove.containsKey(ancestor.getUUID())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isHeadingToWisconsin() {
        return this.headingToWisconsin;
    }

    public boolean isUpdatingWorkspace() {
        if (this.transactionCount > 0) {
            return true;
        }
        if (this.transactionCount == 0) {
            return false;
        }
        this.rollback();
        throw new IllegalStateException("This persister is in an illegal state. transactionCount was :" + this.transactionCount);
    }

    public void enforceThreadSafety() {
        if (this.currentThread == null) {
            this.currentThread = Thread.currentThread();
        } else if (this.currentThread != Thread.currentThread()) {
            this.rollback(true);
            throw new RuntimeException("A call from two different threads was detected. Callers of a sessionPersister should synchronize prior to opening transactions. The thread " + Thread.currentThread().getName() + " tried to access the persister while the thread " + this.currentThread.getName() + " was already using it.");
        }
    }

    public void setGodMode(boolean godMode) {
        this.godMode = godMode;
    }

    private void setObjectsToRemoveRollbackList(LinkedHashMap<String, RemovedObjectEntry> objectsToRemoveRollbackList) {
        this.objectsToRemoveRollbackList = objectsToRemoveRollbackList;
    }

    private void setPersistedObjectsRollbackList(List<PersistedObjectEntry> persistedObjectsRollbackList) {
        this.persistedObjectsRollbackList = persistedObjectsRollbackList;
    }

    private void setPersistedPropertiesRollbackList(List<PersistedPropertiesEntry> persistedPropertiesRollbackList) {
        this.persistedPropertiesRollbackList = persistedPropertiesRollbackList;
    }

    public void setWorkspaceContainer(WorkspaceContainer workspaceContainer) {
        this.workspaceContainer = workspaceContainer;
    }

    public WorkspaceContainer getWorkspaceContainer() {
        return this.workspaceContainer;
    }

    public static void undoForSession(SPObject root, List<PersistedObjectEntry> creations, List<PersistedPropertiesEntry> properties, LinkedHashMap<String, RemovedObjectEntry> removals, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SPSessionPersister persister = new SPSessionPersister("undoer", root, converter){

            @Override
            protected void refreshRootNode(PersistedSPObject pso) {
            }
        };
        persister.setWorkspaceContainer(root.getWorkspaceContainer());
        persister.setGodMode(true);
        super.setObjectsToRemoveRollbackList(removals);
        super.setPersistedObjectsRollbackList(creations);
        super.setPersistedPropertiesRollbackList(properties);
        persister.rollback(true);
    }

    public static void undoForSession(SPObject root, List<PersistedSPObject> creations, Multimap<String, PersistedSPOProperty> properties, List<RemovedObjectEntry> removals, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        LinkedList<PersistedObjectEntry> c = new LinkedList<PersistedObjectEntry>();
        LinkedList<PersistedPropertiesEntry> p = new LinkedList<PersistedPropertiesEntry>();
        LinkedHashMap<String, RemovedObjectEntry> r = new LinkedHashMap<String, RemovedObjectEntry>();
        for (PersistedSPObject pso : creations) {
            c.add(new PersistedObjectEntry(pso.getParentUUID(), pso.getUUID()));
        }
        for (PersistedSPOProperty property : properties.values()) {
            p.add(new PersistedPropertiesEntry(property.getUUID(), property.getPropertyName(), property.getDataType(), property.getOldValue()));
        }
        for (RemovedObjectEntry removal : removals) {
            r.put(removal.getRemovedChild().getUUID(), removal);
        }
        SPSessionPersister.undoForSession(root, c, p, r, converter);
    }

    public static void redoForSession(SPObject root, List<PersistedSPObject> creations, Multimap<String, PersistedSPOProperty> properties, List<RemovedObjectEntry> removals, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        SPSessionPersister persister = new SPSessionPersister("redoer", root, converter){

            @Override
            protected void refreshRootNode(PersistedSPObject pso) {
            }
        };
        TreeMap<String, String> objToRmv = new TreeMap<String, String>(persister.removedObjectComparator);
        for (RemovedObjectEntry roe : removals) {
            objToRmv.put(roe.getRemovedChild().getUUID(), roe.getParentUUID());
        }
        persister.setWorkspaceContainer(root.getWorkspaceContainer());
        persister.setGodMode(true);
        super.setPersistedObjects(creations);
        super.setPersistedProperties(properties);
        super.setObjectsToRemove(objToRmv);
        persister.begin();
        persister.commit();
    }

    protected void clearUUIDCache() {
        this.lookupCache.clear();
    }

    protected <T extends SPObject> T findByUuid(SPObject root, String uuid, Class<T> expectedType) {
        if (this.lookupCache.get(uuid) != null) {
            SPObject foundObject = this.lookupCache.get(uuid);
            if (!expectedType.isAssignableFrom(foundObject.getClass())) {
                throw new IllegalStateException("The object " + foundObject + " is not of type " + expectedType + " from the cache.");
            }
            return (T)((SPObject)expectedType.cast(foundObject));
        }
        if (uuid == null || uuid.trim().isEmpty() || !this.lookupCache.isEmpty()) {
            return null;
        }
        this.lookupCache.putAll(SQLPowerUtils.buildIdMap(this.root));
        return (T)((SPObject)expectedType.cast(this.lookupCache.get(uuid)));
    }

    public void setDisableMagic(boolean disableMagic) {
        this.disableMagic = disableMagic;
    }

    public void setRollbackOnCommitError(boolean rollbackOnCommitError) {
        this.rollbackOnCommitError = rollbackOnCommitError;
    }
}

