/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.helper;

import ca.sqlpower.dao.helper.SPPersisterHelper;
import ca.sqlpower.object.SPObject;
import java.util.HashMap;
import java.util.Map;

public class PersisterHelperFinder {
    public static final String GENERATED_PACKAGE_NAME = "generated";
    private static final Map<Class<? extends SPObject>, SPPersisterHelper<? extends SPObject>> cache = new HashMap<Class<? extends SPObject>, SPPersisterHelper<? extends SPObject>>();

    public static SPPersisterHelper<? extends SPObject> findPersister(Class<? extends SPObject> persistClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (cache.get(persistClass) != null) {
            return cache.get(persistClass);
        }
        String className = persistClass.getSimpleName().indexOf("$") == -1 ? persistClass.getSimpleName() : persistClass.getSimpleName().substring(persistClass.getSimpleName().lastIndexOf("$") + 1);
        String persisterClassName = persistClass.getPackage().getName() + "." + GENERATED_PACKAGE_NAME + "." + className + "PersisterHelper";
        Class<?> persisterClass = PersisterHelperFinder.class.getClassLoader().loadClass(persisterClassName);
        SPPersisterHelper newPersister = (SPPersisterHelper)persisterClass.newInstance();
        cache.put(persistClass, newPersister);
        return newPersister;
    }

    public static SPPersisterHelper<? extends SPObject> findPersister(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String persisterClassName = PersisterHelperFinder.getPersisterHelperClassName(type);
        Class<?> persisterClass = PersisterHelperFinder.class.getClassLoader().loadClass(persisterClassName);
        return (SPPersisterHelper)persisterClass.newInstance();
    }

    public static String getPersisterHelperClassName(String classNameToPersist) {
        String packageName = classNameToPersist.substring(0, classNameToPersist.lastIndexOf("."));
        String className = classNameToPersist.substring(classNameToPersist.lastIndexOf(".") + 1, classNameToPersist.length());
        if (className.indexOf("$") != -1) {
            className = className.substring(className.lastIndexOf("$") + 1);
        }
        String persisterClassName = packageName + "." + GENERATED_PACKAGE_NAME + "." + className + "PersisterHelper";
        return persisterClassName;
    }

    private PersisterHelperFinder() {
    }
}

