/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.session;

import ca.sqlpower.dao.session.BidirectionalConverter;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class LocaleConverter
implements BidirectionalConverter<String, Locale> {
    private static final String SEPARATOR = "-";

    @Override
    public String convertToSimpleType(Locale convertFrom, Object ... additionalInfo) {
        return convertFrom.getLanguage() + SEPARATOR + convertFrom.getCountry() + SEPARATOR + convertFrom.getVariant();
    }

    @Override
    public Locale convertToComplexType(String convertFrom) throws ConversionException {
        String[] split = convertFrom.split(SEPARATOR);
        if (split.length == 0 || split[0].length() == 0) {
            throw new ConversionException("All locales must have a language");
        }
        if (split.length == 1 || split[1].length() == 0) {
            return new Locale(split[0]);
        }
        if (split.length == 2 || split[2].length() == 0) {
            return new Locale(split[0], split[1]);
        }
        return new Locale(split[0], split[1], split[2]);
    }
}

