/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao.session;

import ca.sqlpower.dao.session.ClassConverter;
import ca.sqlpower.dao.session.ColorConverter;
import ca.sqlpower.dao.session.DateConverter;
import ca.sqlpower.dao.session.DimensionConverter;
import ca.sqlpower.dao.session.EnumConverter;
import ca.sqlpower.dao.session.FileConverter;
import ca.sqlpower.dao.session.FormatConverter;
import ca.sqlpower.dao.session.ListConverter;
import ca.sqlpower.dao.session.LocaleConverter;
import ca.sqlpower.dao.session.Point2DConverter;
import ca.sqlpower.dao.session.QNameConverter;
import ca.sqlpower.dao.session.RectangleConverter;
import ca.sqlpower.dao.session.SPObjectConverter;
import ca.sqlpower.dao.session.StringArrayConverter;
import ca.sqlpower.dao.session.URIConverter;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sql.SpecificDataSourceCollection;
import ca.sqlpower.util.SQLPowerUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;

public class SessionPersisterSuperConverter {
    protected final SPObjectConverter spObjectConverter;
    private final FormatConverter formatConverter = new FormatConverter();
    private final Point2DConverter point2DConverter = new Point2DConverter();
    private final RectangleConverter rectangleConverter = new RectangleConverter();
    private final DimensionConverter dimensionConverter = new DimensionConverter();
    private final ColorConverter colorConverter = new ColorConverter();
    private final DateConverter dateConverter = new DateConverter();
    private final StringArrayConverter stringArrayConverter = new StringArrayConverter();
    private final ClassConverter classConverter = new ClassConverter();
    private final FileConverter fileConverter = new FileConverter();
    private final ListConverter listConverter = new ListConverter();
    private final LocaleConverter localeConverter = new LocaleConverter();
    private final QNameConverter qnameConverter = new QNameConverter();
    private final URIConverter uriConverter = new URIConverter();
    protected final DataSourceCollection<JDBCDataSource> dsCollection;

    public SessionPersisterSuperConverter(DataSourceCollection<? extends SPDataSource> dsCollection, SPObject root) {
        this.spObjectConverter = new SPObjectConverter(root);
        this.dsCollection = new SpecificDataSourceCollection<JDBCDataSource>(dsCollection, JDBCDataSource.class);
    }

    public Object convertToBasicType(Object convertFrom, Object ... additionalInfo) {
        if (convertFrom == null) {
            return null;
        }
        if (convertFrom instanceof SPObject) {
            SPObject spo = (SPObject)convertFrom;
            return this.spObjectConverter.convertToSimpleType(spo, new Object[0]);
        }
        if (convertFrom instanceof String) {
            return convertFrom;
        }
        if (convertFrom instanceof Integer) {
            return convertFrom;
        }
        if (convertFrom instanceof Double) {
            return convertFrom;
        }
        if (convertFrom instanceof Boolean) {
            return convertFrom;
        }
        if (convertFrom instanceof Long) {
            return convertFrom;
        }
        if (convertFrom instanceof Short) {
            return convertFrom;
        }
        if (convertFrom instanceof Float) {
            return convertFrom;
        }
        if (convertFrom instanceof BigDecimal) {
            return ((BigDecimal)convertFrom).toPlainString();
        }
        if (convertFrom instanceof BigInteger) {
            return ((BigInteger)convertFrom).toString();
        }
        if (convertFrom instanceof Timestamp) {
            return ((Timestamp)convertFrom).toString();
        }
        if (convertFrom instanceof Time) {
            return ((Time)convertFrom).toString();
        }
        if (convertFrom instanceof Date) {
            return ((Date)convertFrom).toString();
        }
        if (convertFrom instanceof Character) {
            Character c = (Character)convertFrom;
            String s = new String(new char[]{c.charValue()});
            return s;
        }
        if (convertFrom.getClass().isEnum() || convertFrom.getClass().isAnonymousClass() && convertFrom.getClass().getSuperclass().isEnum()) {
            return new EnumConverter(convertFrom.getClass()).convertToSimpleType((Enum)convertFrom, new Object[0]);
        }
        if (convertFrom instanceof JDBCDataSource) {
            return ((JDBCDataSource)convertFrom).getName();
        }
        if (convertFrom instanceof Format) {
            return this.formatConverter.convertToSimpleType((Format)convertFrom, new Object[0]);
        }
        if (convertFrom instanceof Point2D) {
            Point2D p = (Point2D)convertFrom;
            return this.point2DConverter.convertToSimpleType(p, new Object[0]);
        }
        if (convertFrom instanceof Rectangle) {
            Rectangle r = (Rectangle)convertFrom;
            return this.rectangleConverter.convertToSimpleType(r, new Object[0]);
        }
        if (convertFrom instanceof Dimension) {
            Dimension d = (Dimension)convertFrom;
            return this.dimensionConverter.convertToSimpleType(d, new Object[0]);
        }
        if (convertFrom instanceof Color) {
            Color c = (Color)convertFrom;
            return this.colorConverter.convertToSimpleType(c, new Object[0]);
        }
        if (convertFrom instanceof Class) {
            Class c = (Class)convertFrom;
            return this.classConverter.convertToSimpleType(c, new Object[0]);
        }
        if (convertFrom instanceof java.util.Date) {
            java.util.Date d = (java.util.Date)convertFrom;
            return this.dateConverter.convertToSimpleType(d, new Object[0]);
        }
        if (convertFrom instanceof File) {
            File file = (File)convertFrom;
            return this.fileConverter.convertToSimpleType(file, new Object[0]);
        }
        if (convertFrom instanceof String[]) {
            String[] array = (String[])convertFrom;
            return this.stringArrayConverter.convertToSimpleType(array, new Object[0]);
        }
        if (convertFrom instanceof Exception) {
            String exceptionString = SQLPowerUtils.exceptionStackToString((Exception)convertFrom);
            exceptionString = exceptionString.replace(Exception.class.getName() + ": ", "");
            return exceptionString;
        }
        if (convertFrom instanceof List) {
            return this.listConverter.convertToSimpleType((List)convertFrom, new Object[0]);
        }
        if (convertFrom instanceof Locale) {
            return this.localeConverter.convertToSimpleType((Locale)convertFrom, new Object[0]);
        }
        if (convertFrom instanceof QName) {
            return this.qnameConverter.convertToSimpleType((QName)convertFrom, new Object[0]);
        }
        if (convertFrom instanceof URI) {
            return this.uriConverter.convertToSimpleType((URI)convertFrom, new Object[0]);
        }
        throw new IllegalArgumentException("Cannot convert " + convertFrom + " of type " + convertFrom.getClass());
    }

    public Object convertToComplexType(Object o, Class<? extends Object> type) {
        if (o == null) {
            return null;
        }
        if (SPObject.class.isAssignableFrom(type)) {
            return this.spObjectConverter.convertToComplexType((String)o);
        }
        if (String.class.isAssignableFrom(type)) {
            return (String)o;
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (Integer)o;
        }
        if (Double.class.isAssignableFrom(type)) {
            if (o instanceof BigDecimal) {
                return ((BigDecimal)o).doubleValue();
            }
            return (Double)o;
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (Boolean)o;
        }
        if (Long.class.isAssignableFrom(type)) {
            return (Long)o;
        }
        if (Short.class.isAssignableFrom(type)) {
            return (Short)o;
        }
        if (Float.class.isAssignableFrom(type)) {
            return (Float)o;
        }
        if (Character.class.isAssignableFrom(type)) {
            return Character.valueOf(((String)o).charAt(0));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new BigDecimal((String)o);
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigInteger((String)o);
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return Timestamp.valueOf((String)o);
        }
        if (Time.class.isAssignableFrom(type)) {
            return Time.valueOf((String)o);
        }
        if (Date.class.isAssignableFrom(type)) {
            return Date.valueOf((String)o);
        }
        if (Enum.class.isAssignableFrom(type)) {
            if (type.isAnonymousClass() && Enum.class.isAssignableFrom(type.getSuperclass())) {
                return new EnumConverter<Object>(type.getSuperclass()).convertToComplexType((String)o);
            }
            return new EnumConverter<Object>(type).convertToComplexType((String)o);
        }
        if (JDBCDataSource.class.isAssignableFrom(type)) {
            if (((String)o).equals("PlayPen Database")) {
                return new JDBCDataSource(this.dsCollection);
            }
            return this.dsCollection.getDataSource((String)o, JDBCDataSource.class);
        }
        if (Format.class.isAssignableFrom(type)) {
            return this.formatConverter.convertToComplexType((String)o);
        }
        if (Point.class.isAssignableFrom(type)) {
            Point2D p2d = this.point2DConverter.convertToComplexType((String)o);
            return new Point((int)p2d.getX(), (int)p2d.getY());
        }
        if (Point2D.class.isAssignableFrom(type)) {
            return this.point2DConverter.convertToComplexType((String)o);
        }
        if (Rectangle.class.isAssignableFrom(type)) {
            return this.rectangleConverter.convertToComplexType((String)o);
        }
        if (Color.class.isAssignableFrom(type)) {
            return this.colorConverter.convertToComplexType((String)o);
        }
        if (Class.class.isAssignableFrom(type)) {
            return this.classConverter.convertToComplexType((String)o);
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return this.dateConverter.convertToComplexType((String)o);
        }
        if (File.class.isAssignableFrom(type)) {
            return this.fileConverter.convertToComplexType((String)o);
        }
        if (Dimension.class.isAssignableFrom(type)) {
            return this.dimensionConverter.convertToComplexType((String)o);
        }
        if (String[].class.isAssignableFrom(type)) {
            return this.stringArrayConverter.convertToComplexType((String)o);
        }
        if (Exception.class.isAssignableFrom(type)) {
            return new Exception((String)o);
        }
        if (List.class.isAssignableFrom(type)) {
            return this.listConverter.convertToComplexType((String)o);
        }
        if (Locale.class.isAssignableFrom(type)) {
            return this.localeConverter.convertToComplexType((String)o);
        }
        if (QName.class.isAssignableFrom(type)) {
            return this.qnameConverter.convertToComplexType((String)o);
        }
        if (URI.class.isAssignableFrom(type)) {
            return this.uriConverter.convertToComplexType((String)o);
        }
        throw new IllegalArgumentException("Cannot convert " + o + " of type " + o.getClass() + " to the type " + type);
    }

    public void setUUIDCache(Map<String, SPObject> lookupCache) {
        this.spObjectConverter.setUUIDCache(lookupCache);
    }

    public void removeUUIDCache() {
        this.spObjectConverter.removeUUIDCache();
    }
}

