/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.json.SPJSONMessageDecoder;
import ca.sqlpower.enterprise.JSONMessage;
import ca.sqlpower.enterprise.JSONResponseHandler;
import ca.sqlpower.enterprise.TransactionInformation;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.security.AccessDeniedException;

public class ClientSideSessionUtils {
    public static final String REST_TAG = "rest";
    public static final String SYSTEM_UUID = "system";

    public static HttpClient createHttpClient(SPServerInfo serviceInfo, CookieStore cookieStore) {
        return ClientSideSessionUtils.createHttpClient(serviceInfo.getServerAddress(), serviceInfo.getUsername(), serviceInfo.getPassword(), cookieStore);
    }

    public static HttpClient createHttpClient(String host, String username, String password, CookieStore cookieStore) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)2000);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
        httpClient.setCookieStore(cookieStore);
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectLocation createNewServerSession(SPServerInfo serviceInfo, String name, CookieStore cookieStore, UserPrompterFactory userPrompterFactory) throws URISyntaxException, ClientProtocolException, IOException, JSONException {
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
        try {
            HttpGet request = new HttpGet(ClientSideSessionUtils.getServerURI(serviceInfo, "/rest/jcr/projects/new", "name=" + name));
            JSONMessage message = (JSONMessage)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
            JSONObject response = new JSONObject(message.getBody());
            ProjectLocation projectLocation = new ProjectLocation(response.getString("uuid"), response.getString("name"), serviceInfo);
            return projectLocation;
        }
        catch (AccessDeniedException e) {
            userPrompterFactory.createUserPrompter("You do not have sufficient privileges to create a new workspace.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser("");
            ProjectLocation projectLocation = null;
            return projectLocation;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static URI getServerURI(SPServerInfo serviceInfo, String contextRelativePath) throws URISyntaxException {
        return ClientSideSessionUtils.getServerURI(serviceInfo, contextRelativePath, null);
    }

    public static URI getServerURI(SPServerInfo serviceInfo, String contextRelativePath, String query) throws URISyntaxException {
        String contextPath = serviceInfo.getPath();
        URI serverURI = new URI(serviceInfo.getScheme(), null, serviceInfo.getServerAddress(), serviceInfo.getPort(), contextPath + contextRelativePath, query, null);
        return serverURI;
    }

    public static List<TransactionInformation> decodeJSONRevisionList(String json) throws JSONException, ParseException {
        JSONArray jsonArray = new JSONArray(json);
        ArrayList<TransactionInformation> transactions = new ArrayList<TransactionInformation>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonItem = jsonArray.getJSONObject(i);
            TransactionInformation transaction = new TransactionInformation(jsonItem.getLong("number"), jsonItem.getLong("time"), jsonItem.getString("author"), jsonItem.getString("description"), jsonItem.getString("simpleDescription"));
            transactions.add(transaction);
        }
        return transactions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteServerWorkspace(ProjectLocation projectLocation, CookieStore cookieStore, UserPrompterFactory userPrompterFactory) throws URISyntaxException, ClientProtocolException, IOException {
        SPServerInfo serviceInfo = projectLocation.getServiceInfo();
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
        try {
            ClientSideSessionUtils.executeServerRequest(httpClient, projectLocation.getServiceInfo(), "/rest/jcr/" + projectLocation.getUUID() + "/delete", new JSONResponseHandler());
        }
        catch (AccessDeniedException e) {
            userPrompterFactory.createUserPrompter("You do not have sufficient privileges to delete the selected workspace.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser("");
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static <T> T executeServerRequest(HttpClient httpClient, SPServerInfo serviceInfo, String contextRelativePath, ResponseHandler<T> responseHandler) throws IOException, URISyntaxException {
        return ClientSideSessionUtils.executeServerRequest(httpClient, serviceInfo, contextRelativePath, null, responseHandler);
    }

    public static <T> T executeServerRequest(HttpClient httpClient, SPServerInfo serviceInfo, String contextRelativePath, String query, ResponseHandler<T> responseHandler) throws IOException, URISyntaxException {
        HttpGet request = new HttpGet(ClientSideSessionUtils.getServerURI(serviceInfo, contextRelativePath, query));
        return (T)httpClient.execute((HttpUriRequest)request, responseHandler);
    }

    public static List<ProjectLocation> getWorkspaceNames(SPServerInfo serviceInfo, CookieStore cookieStore, UserPrompterFactory upf) throws IOException, URISyntaxException, JSONException {
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
        try {
            HttpGet request = new HttpGet(ClientSideSessionUtils.getServerURI(serviceInfo, "/rest/jcr/projects"));
            JSONMessage message = (JSONMessage)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
            if (message.getStatusCode() == 412) {
                upf.createUserPrompter(message.getBody(), UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, null, "OK").promptUser(new Object[0]);
            }
            ArrayList<ProjectLocation> workspaces = new ArrayList<ProjectLocation>();
            JSONArray response = new JSONArray(message.getBody());
            for (int i = 0; i < response.length(); ++i) {
                JSONObject workspace = (JSONObject)response.get(i);
                workspaces.add(new ProjectLocation(workspace.getString("uuid"), workspace.getString("name"), serviceInfo));
            }
            ArrayList<ProjectLocation> arrayList = workspaces;
            return arrayList;
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void persistRevisionFromServer(ProjectLocation projectLocation, int revisionNo, SPJSONMessageDecoder decoder, CookieStore cookieStore) throws IOException, URISyntaxException, SPPersistenceException, IllegalArgumentException {
        block4: {
            SPServerInfo serviceInfo = projectLocation.getServiceInfo();
            HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
            try {
                JSONMessage response = ClientSideSessionUtils.executeServerRequest(httpClient, serviceInfo, "/rest/project/" + projectLocation.getUUID() + "/" + revisionNo, new JSONResponseHandler());
                if (response.isSuccessful()) {
                    decoder.decode(response.getBody());
                    break block4;
                }
                throw new IllegalArgumentException("The server rejected the revision number (it must be greater than 0, and no greater than the current revision number)");
            }
            finally {
                httpClient.getConnectionManager().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int revertServerWorkspace(ProjectLocation projectLocation, int revisionNo, CookieStore cookieStore) throws IOException, URISyntaxException, JSONException {
        SPServerInfo serviceInfo = projectLocation.getServiceInfo();
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
        try {
            JSONMessage message = ClientSideSessionUtils.executeServerRequest(httpClient, projectLocation.getServiceInfo(), "/rest/project/" + projectLocation.getUUID() + "/revert", "revisionNo=" + revisionNo, new JSONResponseHandler());
            if (message.isSuccessful()) {
                int n = new JSONObject(message.getBody()).getInt("currentRevision");
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectLocation uploadProject(SPServerInfo serviceInfo, String name, File project, UserPrompterFactory session, CookieStore cookieStore) throws URISyntaxException, ClientProtocolException, IOException, JSONException {
        HttpClient httpClient = ClientSideSessionUtils.createHttpClient(serviceInfo, cookieStore);
        try {
            MultipartEntity entity = new MultipartEntity();
            FileBody fileBody = new FileBody(project);
            StringBody nameBody = new StringBody(name);
            entity.addPart("file", (ContentBody)fileBody);
            entity.addPart("name", (ContentBody)nameBody);
            HttpPost request = new HttpPost(ClientSideSessionUtils.getServerURI(serviceInfo, "/rest/jcr", "name=" + name));
            request.setEntity((HttpEntity)entity);
            JSONMessage message = (JSONMessage)httpClient.execute((HttpUriRequest)request, (ResponseHandler)new JSONResponseHandler());
            JSONObject response = new JSONObject(message.getBody());
            ProjectLocation projectLocation = new ProjectLocation(response.getString("uuid"), response.getString("name"), serviceInfo);
            return projectLocation;
        }
        catch (AccessDeniedException e) {
            session.createUserPrompter("You do not have sufficient privileges to create a new workspace.", UserPrompterFactory.UserPromptType.MESSAGE, UserPrompter.UserPromptOptions.OK, UserPrompter.UserPromptResponse.OK, "OK", "OK").promptUser("");
            ProjectLocation projectLocation = null;
            return projectLocation;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }
}

