/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise;

import ca.sqlpower.dao.FriendlyRuntimeSPPersistenceException;
import ca.sqlpower.dao.FriendlySPPersistenceException;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.enterprise.JSONMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.security.AccessDeniedException;

public class JSONResponseHandler
implements ResponseHandler<JSONMessage> {
    private static final Logger logger = Logger.getLogger(JSONResponseHandler.class);

    public JSONMessage handleResponse(HttpResponse response) {
        try {
            int status = response.getStatusLine().getStatusCode();
            if (status == 401) {
                throw new AccessDeniedException("Access Denied");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            return this.handleResponse(reader, status);
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public JSONMessage handleResponse(String json, int status) {
        return this.handleResponse(new StringReader(json), status);
    }

    public JSONMessage handleResponse(Reader reader, int status) {
        if (status == 404) {
            throw new RuntimeException("Server resource is not available.");
        }
        if (status == 403) {
            throw new AccessDeniedException("Insufficient priviledges");
        }
        JSONTokener tokener = new JSONTokener(reader);
        try {
            JSONObject message;
            try {
                message = (JSONObject)tokener.nextValue();
            }
            catch (ClassCastException ex) {
                StringBuffer sb = new StringBuffer();
                sb.append("Internal server error. Server responded with the following.\n");
                try {
                    int charAsInt = reader.read();
                    while (charAsInt != -1) {
                        sb.append((char)charAsInt);
                        charAsInt = reader.read();
                    }
                    logger.error((Object)sb.toString());
                }
                catch (IOException e) {
                    logger.error((Object)("Failed to parse the root exception. The following was received " + sb.toString()));
                }
                throw new RuntimeException("Server error " + status + ". See logs or server logs for more details.");
            }
            if (message.getString("responseKind").equals("data")) {
                return new JSONMessage(message.getString("data"), status);
            }
            if (message.getString("responseKind").equals("unsuccessful")) {
                return new JSONMessage(message.getString("data"), status);
            }
            if (message.getString("responseKind").equals("exceptionStackTrace")) {
                JSONArray stackTraceStrings = new JSONArray(message.getString("data"));
                StringBuffer stackTraceMessage = new StringBuffer();
                if (stackTraceStrings.length() > 0) {
                    String firstLine = stackTraceStrings.getString(0);
                    String userMessage = null;
                    if (firstLine.contains(FriendlyRuntimeSPPersistenceException.class.getName())) {
                        userMessage = firstLine.substring(firstLine.indexOf(FriendlyRuntimeSPPersistenceException.class.getName()) + FriendlyRuntimeSPPersistenceException.class.getName().length() + 2);
                    } else if (firstLine.contains(FriendlySPPersistenceException.class.getName())) {
                        userMessage = firstLine.substring(firstLine.indexOf(FriendlySPPersistenceException.class.getName()) + FriendlySPPersistenceException.class.getName().length() + 2);
                    }
                    if (userMessage != null) {
                        for (int i = 0; i < stackTraceStrings.length(); ++i) {
                            stackTraceMessage.append("\n").append(stackTraceStrings.get(i));
                        }
                        logger.info((Object)stackTraceMessage.toString());
                        throw new FriendlyRuntimeSPPersistenceException(userMessage);
                    }
                }
                for (int i = 0; i < stackTraceStrings.length(); ++i) {
                    stackTraceMessage.append("\n").append(stackTraceStrings.get(i));
                }
                throw new SPPersistenceException(null, stackTraceMessage.toString());
            }
            throw new Exception("Unable to parse response ");
        }
        catch (JSONException ex) {
            StringBuffer sb = new StringBuffer();
            sb.append("Internal server error. Server responded with the following.\n");
            try {
                int charAsInt = reader.read();
                while (charAsInt != -1) {
                    sb.append(charAsInt);
                    charAsInt = reader.read();
                }
                logger.error((Object)sb.toString());
            }
            catch (IOException e) {
                logger.error((Object)("Failed to parse the root exception. The following was received " + sb.toString()));
            }
            throw new RuntimeException("Server error. See logs or server logs for more details.");
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            if (message.contains("\n")) {
                String[] messages;
                for (String serverMsg : messages = message.split("\n")) {
                    if (serverMsg.trim().length() <= 0) continue;
                    message = serverMsg.trim();
                    break;
                }
            }
            throw new RuntimeException("Server returned status " + status + "\n" + message, ex);
        }
    }
}

