/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise.client;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.Immutable;
import javax.jmdns.ServiceInfo;

@Immutable
public class SPServerInfo {
    private final String scheme;
    private final String name;
    private final String serverAddress;
    private final int port;
    private final String path;
    private final String username;
    private final String password;
    private final boolean passwordAllowed;
    private Boolean removeKeyStore = false;

    public SPServerInfo(String name, String serverAddress, int port, String path, String username, String password) {
        this.scheme = "http";
        this.name = name;
        this.serverAddress = serverAddress;
        this.port = port;
        this.path = path;
        this.username = username;
        this.password = password;
        this.passwordAllowed = true;
        if (path == null || path.length() < 1 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must begin with a /");
        }
    }

    public SPServerInfo(String scheme, String name, String serverAddress, int port, String path, String username) {
        this.scheme = scheme;
        this.name = name;
        this.serverAddress = serverAddress;
        this.port = port;
        this.path = path;
        this.username = username;
        this.password = "";
        this.passwordAllowed = false;
        if (path == null || path.length() < 1 || path.charAt(0) != '/') {
            throw new IllegalArgumentException("path must begin with a /");
        }
    }

    public SPServerInfo(SPServerInfo info, String password) {
        this.scheme = info.scheme;
        this.name = info.name;
        this.serverAddress = info.serverAddress;
        this.port = info.port;
        this.path = info.path;
        this.username = info.username;
        this.password = password;
        this.passwordAllowed = true;
    }

    public SPServerInfo(ServiceInfo si) {
        this.scheme = "http";
        this.name = si.getName();
        this.serverAddress = si.getHostAddress();
        this.port = si.getPort();
        this.path = si.getPropertyString("path");
        this.username = null;
        this.password = null;
        this.passwordAllowed = true;
    }

    public String getName() {
        return this.name;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URI toURI() throws URISyntaxException {
        return new URI("http", null, this.serverAddress, this.port, this.path, null, null);
    }

    public String toString() {
        return this.name + " (" + this.serverAddress + ":" + this.port + this.path + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SPServerInfo other = (SPServerInfo)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.serverAddress == null ? other.serverAddress != null : !this.serverAddress.equals(other.serverAddress));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isPasswordAllowed() {
        return this.passwordAllowed;
    }

    public String getScheme() {
        return this.scheme;
    }
}

