/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.enterprise.client;

import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.ServerListEvent;
import ca.sqlpower.enterprise.client.ServerListListener;
import ca.sqlpower.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SPServerInfoManager {
    private final List<SPServerInfo> servers = new ArrayList<SPServerInfo>();
    private final List<ServerListListener> listeners = new ArrayList<ServerListListener>();
    private final Preferences serverPrefs;
    private final Version clientVersion;
    private final SPServerInfo defaultSettings;

    public SPServerInfoManager(Preferences prefs, Version clientVersion, SPServerInfo defaultSettings) throws BackingStoreException {
        this.serverPrefs = prefs;
        this.clientVersion = clientVersion;
        this.defaultSettings = defaultSettings;
        for (String nodeName : this.serverPrefs.childrenNames()) {
            Preferences serverNode = this.serverPrefs.node(nodeName);
            if (defaultSettings.isPasswordAllowed()) {
                this.servers.add(new SPServerInfo(serverNode.get("name", null), serverNode.get("serverAddress", null), serverNode.getInt("port", 0), serverNode.get("path", null), serverNode.get("username", ""), serverNode.get("password", "")));
                continue;
            }
            this.servers.add(new SPServerInfo(serverNode.get("scheme", "https"), serverNode.get("name", null), serverNode.get("serverAddress", null), serverNode.getInt("port", 0), serverNode.get("path", null), serverNode.get("username", "")));
        }
    }

    public void add(SPServerInfo server) {
        this.servers.add(server);
        Preferences thisServer = this.serverPrefs.node(server.getName());
        thisServer.put("scheme", server.getScheme());
        thisServer.put("name", server.getName());
        thisServer.put("serverAddress", server.getServerAddress());
        thisServer.putInt("port", server.getPort());
        thisServer.put("path", server.getPath());
        thisServer.put("username", server.getUsername());
        thisServer.put("password", server.getPassword());
        for (ServerListListener s : this.listeners) {
            s.serverAdded(new ServerListEvent(server));
        }
    }

    public void remove(SPServerInfo server) {
        this.servers.remove(server);
        try {
            this.serverPrefs.node(server.getName()).removeNode();
        }
        catch (BackingStoreException ex) {
            throw new RuntimeException("Failed to remove server from list", ex);
        }
        for (ServerListListener s : this.listeners) {
            s.serverRemoved(new ServerListEvent(server));
        }
    }

    public List<SPServerInfo> getServers(boolean getDiscoveredServers) {
        return Collections.unmodifiableList(this.servers);
    }

    public void addServerListListener(ServerListListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeServerListListener(ServerListListener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public Version getClientVersion() {
        return this.clientVersion;
    }

    public SPServerInfo getDefaultSettings() {
        return this.defaultSettings;
    }
}

