/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractPoolingSPListener
implements SPListener {
    private static final Logger logger = Logger.getLogger(AbstractPoolingSPListener.class);
    private final Map<SPObject, Integer> inTransactionMap = new IdentityHashMap<SPObject, Integer>();
    private long creationCounter = 0L;
    private final Map<SPObject, List<EventObject>> eventMap = new IdentityHashMap<SPObject, List<EventObject>>();
    private final Multimap<SPObject, SPObject> ancestorTransactionMap = ArrayListMultimap.create();
    private final boolean errorOnDanglingCommit;

    private long getCurrentCreationTime() {
        ++this.creationCounter;
        return this.creationCounter;
    }

    @Override
    public final void transactionEnded(TransactionEvent e) {
        SPObject source = (SPObject)e.getSource();
        if (this.errorOnDanglingCommit && this.inTransactionMap.get(source) == null) {
            throw new IllegalStateException("An end transaction for object " + source + " of type " + source.getClass() + " was called while it was " + "not in a transaction.");
        }
        if (!this.errorOnDanglingCommit && this.inTransactionMap.get(source) == null) {
            return;
        }
        Integer lastTransactionCount = this.inTransactionMap.get(source);
        logger.debug((Object)("Transaction count on " + this + " for:" + source + ": " + this.inTransactionMap.get(source)));
        Integer nestedTransactionCount = lastTransactionCount - 1;
        if (nestedTransactionCount < 0) {
            throw new IllegalStateException("The transaction count was not removed properly.");
        }
        if (nestedTransactionCount > 0) {
            this.inTransactionMap.put(source, nestedTransactionCount);
            this.transactionEndedImpl(e);
        } else {
            this.inTransactionMap.remove(source);
            if (!this.ancestorInTransaction(source)) {
                this.handlePooledEvents(source);
                this.transactionEndedImpl(e);
            } else {
                this.addEventToMap(e, source);
            }
            this.finalCommitImpl(e);
        }
    }

    private void handlePooledEvents(SPObject source) {
        List<EventObject> eventsForSource = this.collectPooledEvents(source);
        Collections.sort(eventsForSource, new Comparator<EventObject>(){

            @Override
            public int compare(EventObject e1, EventObject e2) {
                return Long.valueOf(e1.getCreationTime()).compareTo(e2.getCreationTime());
            }
        });
        for (EventObject event : eventsForSource) {
            Object evt = event.getEvent();
            if (evt instanceof PropertyChangeEvent) {
                this.propertyChangeImpl((PropertyChangeEvent)evt);
                continue;
            }
            if (evt instanceof SPChildEvent) {
                SPChildEvent childEvent = (SPChildEvent)evt;
                if (childEvent.getType().equals((Object)SPChildEvent.EventType.ADDED)) {
                    this.childAddedImpl(childEvent);
                    continue;
                }
                if (childEvent.getType().equals((Object)SPChildEvent.EventType.REMOVED)) {
                    this.childRemovedImpl(childEvent);
                    continue;
                }
                throw new IllegalStateException("Unknown child event of type " + (Object)((Object)childEvent.getType()));
            }
            if (evt instanceof TransactionEvent) {
                TransactionEvent transEvt = (TransactionEvent)evt;
                if (transEvt.getState().equals((Object)TransactionEvent.TransactionState.END)) {
                    this.transactionEndedImpl(transEvt);
                    continue;
                }
                throw new IllegalStateException("Unknown transaction event of type " + (Object)((Object)transEvt.getState()));
            }
            throw new IllegalStateException("Unknown event type " + evt.getClass());
        }
    }

    private List<EventObject> collectPooledEvents(SPObject source) {
        ArrayList<EventObject> eventsForSource = new ArrayList<EventObject>();
        if (this.eventMap.get(source) != null) {
            eventsForSource.addAll((Collection)this.eventMap.get(source));
            this.eventMap.remove(source);
        }
        if (this.ancestorTransactionMap.get((Object)source) != null) {
            for (SPObject childSource : this.ancestorTransactionMap.get((Object)source)) {
                if (this.isInTransaction(childSource)) continue;
                eventsForSource.addAll(this.collectPooledEvents(childSource));
            }
            this.ancestorTransactionMap.removeAll((Object)source);
        }
        return eventsForSource;
    }

    public AbstractPoolingSPListener() {
        this.errorOnDanglingCommit = true;
    }

    public AbstractPoolingSPListener(boolean errorOnDanglingCommit) {
        this.errorOnDanglingCommit = errorOnDanglingCommit;
    }

    protected void transactionEndedImpl(TransactionEvent e) {
    }

    protected void finalCommitImpl(TransactionEvent e) {
    }

    @Override
    public final void transactionRollback(TransactionEvent e) {
        this.removePooledEvents((SPObject)e.getSource());
        this.transactionRollbackImpl(e);
    }

    private void removePooledEvents(SPObject source) {
        this.inTransactionMap.remove(source);
        if (this.eventMap.get(source) != null) {
            this.eventMap.remove(source);
        }
        if (this.ancestorTransactionMap.get((Object)source) != null) {
            for (SPObject childSource : this.ancestorTransactionMap.get((Object)source)) {
                if (this.isInTransaction(childSource)) continue;
                this.removePooledEvents(childSource);
            }
            this.ancestorTransactionMap.removeAll((Object)source);
        }
    }

    private boolean ancestorInTransaction(SPObject obj) {
        List<SPObject> ancestors = SQLPowerUtils.getAncestorList(obj);
        for (SPObject ancestor : ancestors) {
            if (!this.isInTransaction(ancestor)) continue;
            return true;
        }
        return false;
    }

    private boolean isInTransaction(SPObject ancestor) {
        return this.inTransactionMap.get(ancestor) != null && this.inTransactionMap.get(ancestor) > 0;
    }

    private void addAncestorTransaction(SPObject obj) {
        List<SPObject> ancestors = SQLPowerUtils.getAncestorList(obj);
        Collections.reverse(ancestors);
        for (SPObject ancestor : ancestors) {
            if (!this.isInTransaction(ancestor)) continue;
            this.ancestorTransactionMap.put((Object)ancestor, (Object)obj);
            return;
        }
    }

    protected void transactionRollbackImpl(TransactionEvent e) {
    }

    @Override
    public final void transactionStarted(TransactionEvent e) {
        Integer transactionCount = this.inTransactionMap.get(e.getSource());
        SPObject source = (SPObject)e.getSource();
        if (transactionCount == null) {
            this.inTransactionMap.put(source, 1);
        } else {
            this.inTransactionMap.put(source, transactionCount + 1);
        }
        if (this.ancestorInTransaction(source)) {
            this.addAncestorTransaction(source);
        }
        logger.debug((Object)("Transaction count on " + this + " for:" + e.getSource() + ": " + this.inTransactionMap.get(source)));
        this.transactionStartedImpl(e);
    }

    protected void transactionStartedImpl(TransactionEvent e) {
    }

    @Override
    public final void childAdded(SPChildEvent e) {
        SPObject source = e.getSource();
        boolean ancestorTrans = this.ancestorInTransaction(source);
        if (ancestorTrans || this.isInTransaction(source)) {
            if (ancestorTrans) {
                this.addAncestorTransaction(source);
            }
            this.addEventToMap(e, source);
        } else {
            this.childAddedImpl(e);
        }
    }

    protected void childAddedImpl(SPChildEvent e) {
    }

    @Override
    public final void childRemoved(SPChildEvent e) {
        SPObject source = e.getSource();
        boolean ancestorTrans = this.ancestorInTransaction(source);
        if (ancestorTrans || this.isInTransaction(source)) {
            if (ancestorTrans) {
                this.addAncestorTransaction(source);
            }
            this.addEventToMap(e, source);
        } else {
            this.childRemovedImpl(e);
        }
    }

    private void addEventToMap(Object e, SPObject source) {
        List<EventObject> events = this.eventMap.get(source);
        if (events == null) {
            events = new ArrayList<EventObject>();
            this.eventMap.put(source, events);
        }
        events.add(new EventObject(e));
    }

    protected void childRemovedImpl(SPChildEvent e) {
    }

    @Override
    public final void propertyChanged(PropertyChangeEvent evt) {
        SPObject source = (SPObject)evt.getSource();
        boolean ancestorTrans = this.ancestorInTransaction(source);
        if (ancestorTrans || this.isInTransaction(source)) {
            if (ancestorTrans) {
                this.addAncestorTransaction(source);
            }
            this.addEventToMap(evt, source);
        } else {
            this.propertyChangeImpl(evt);
        }
    }

    protected void propertyChangeImpl(PropertyChangeEvent evt) {
    }

    private class EventObject {
        private final Object event;
        private final long creationTime;

        public EventObject(Object event) {
            this.event = event;
            this.creationTime = AbstractPoolingSPListener.this.getCurrentCreationTime();
        }

        public Object getEvent() {
            return this.event;
        }

        public long getCreationTime() {
            return this.creationTime;
        }
    }
}

