/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.dao.VetoableSPListener;
import ca.sqlpower.object.CleanupExceptions;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Persistable;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.util.RunnableDispatcher;
import ca.sqlpower.util.SessionNotFoundException;
import ca.sqlpower.util.TransactionEvent;
import ca.sqlpower.util.WorkspaceContainer;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;

@Persistable
public abstract class AbstractSPObject
implements SPObject {
    private static final Logger logger = Logger.getLogger(AbstractSPObject.class);
    protected final List<SPListener> listeners = Collections.synchronizedList(new ArrayList());
    private SPObject parent;
    private String name;
    private int magicDisableCount = 0;
    protected String uuid;

    @Constructor
    public AbstractSPObject() {
        this(null);
    }

    public AbstractSPObject(String uuid) {
        if (uuid == null) {
            this.generateNewUUID();
        } else {
            this.uuid = uuid;
        }
    }

    @Override
    public boolean allowsChildType(Class<? extends SPObject> type) {
        for (Class<? extends SPObject> child : this.getAllowedChildTypes()) {
            if (!child.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void addChild(SPObject child, int index) throws IllegalArgumentException {
        if (!this.allowsChildType(child.getClass())) {
            throw new IllegalArgumentException(child.getClass() + " is not a valid child type of " + this.getClass());
        }
        child.setParent(this);
        this.addChildImpl(child, index);
    }

    public void addChild(SPObject child) throws IllegalArgumentException {
        Class<? extends SPObject> childClass;
        if (!this.allowsChildType(child.getClass())) {
            throw new IllegalArgumentException(child.getClass() + " is not a valid child type of " + this.getClass());
        }
        child.setParent(this);
        try {
            childClass = PersisterUtils.getParentAllowedChildType(child.getClass(), this.getClass());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The allowedChildTypes field must be accessible", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("The allowedChildTypes field must exist", e);
        }
        this.addChild(child, this.getChildren(childClass).size());
    }

    protected void addChildImpl(SPObject child, int index) {
        throw new UnsupportedOperationException("This SPObject item cannot have children. This class is " + this.getClass() + " and trying to add " + child.getName() + " of type " + child.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSPListener(SPListener l) {
        if (l == null) {
            throw new NullPointerException("Cannot add child listeners that are null.");
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                logger.debug((Object)("Listener " + l + " was added twice! Ignoring second add"));
            } else {
                this.listeners.add(l);
            }
        }
    }

    @Override
    public CleanupExceptions cleanup() {
        return new CleanupExceptions();
    }

    @Override
    public void generateNewUUID() {
        this.uuid = UUID.randomUUID().toString();
    }

    @Override
    @NonProperty
    public <T extends SPObject> List<T> getChildren(Class<T> type) {
        return this.getChildren(type, this.getChildren());
    }

    protected <T extends SPObject> List<T> getChildren(Class<T> type, List<? extends SPObject> childList) {
        ArrayList<T> children = new ArrayList<T>();
        for (SPObject sPObject : childList) {
            if (!type.isAssignableFrom(sPObject.getClass())) continue;
            children.add(type.cast(sPObject));
        }
        return Collections.unmodifiableList(children);
    }

    @Override
    public boolean allowsChildren() {
        return !this.getAllowedChildTypes().isEmpty();
    }

    @Override
    public int childPositionOffset(Class<? extends SPObject> childType) {
        int offset = 0;
        for (Class<? extends SPObject> type : this.getAllowedChildTypes()) {
            if (type.isAssignableFrom(childType)) {
                return offset;
            }
            offset += this.getChildren(type).size();
        }
        throw new IllegalArgumentException(childType.getName() + " is not a valid child type of " + this.getClass().getName());
    }

    @Override
    @Accessor(isInteresting=true)
    public String getName() {
        return this.name;
    }

    @Override
    @Accessor
    public SPObject getParent() {
        return this.parent;
    }

    @Override
    @Accessor
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public boolean removeChild(SPObject child) throws ObjectDependentException, IllegalArgumentException {
        if (!this.getChildren().contains(child)) {
            throw new IllegalArgumentException("Child object " + child.getName() + " of type " + child.getClass() + " is not a child of " + this.getName() + " of type " + this.getClass());
        }
        if (this.removeChildImpl(child)) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    protected abstract boolean removeChildImpl(SPObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSPListener(SPListener l) {
        List<SPListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    @Override
    public void rollback(String message) {
        this.fireTransactionRollback(message);
    }

    @Override
    @Mutator
    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, name);
    }

    @Override
    @Mutator
    public void setParent(SPObject parent) {
        SPObject oldParent = this.parent;
        this.parent = parent;
        this.firePropertyChange("parent", oldParent, parent);
    }

    @Override
    @Mutator
    public void setUUID(String uuid) {
        String oldUUID = this.uuid;
        if (uuid == null) {
            this.generateNewUUID();
        } else {
            this.uuid = uuid;
        }
        this.firePropertyChange("UUID", oldUUID, this.uuid);
    }

    @Override
    @Transient
    @Accessor
    public WorkspaceContainer getWorkspaceContainer() throws SessionNotFoundException {
        if (this.getParent() != null) {
            return this.getParent().getWorkspaceContainer();
        }
        throw new SessionNotFoundException("Root object does not have a workspace container reference");
    }

    @Override
    @Transient
    @Accessor
    public RunnableDispatcher getRunnableDispatcher() throws SessionNotFoundException {
        if (this.getParent() != null) {
            return this.getParent().getRunnableDispatcher();
        }
        throw new SessionNotFoundException("Root object does not have a runnable dispatcher reference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SPChildEvent fireChildAdded(Class<? extends SPObject> type, SPObject child, int index) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Child Added: " + type + " notifying " + this.listeners.size() + " listeners"));
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for adding the child " + child.getName() + " must fired on the foreground thread.");
        }
        SPChildEvent e = new SPChildEvent(this, type, child, index, SPChildEvent.EventType.ADDED);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.childAdded(e);
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SPChildEvent fireChildRemoved(Class<? extends SPObject> type, SPObject child, int index) {
        logger.debug((Object)("Child Removed: " + type + " notifying " + this.listeners.size() + " listeners: " + this.listeners));
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.isEmpty()) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for removing the child " + child.getName() + " must fired on the foreground thread.");
        }
        SPChildEvent e = new SPChildEvent(this, type, child, index, SPChildEvent.EventType.REMOVED);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.childRemoved(e);
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeEvent firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return null;
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for property change " + propertyName + " must fired on the foreground thread.");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.propertyChanged(evt);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeEvent firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return null;
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for property change " + propertyName + " must fired on the foreground thread.");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.propertyChanged(evt);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeEvent firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (oldValue == newValue) {
            return null;
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for property change " + propertyName + " must fired on the foreground thread.");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, Character.valueOf(oldValue), Character.valueOf(newValue));
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.propertyChanged(evt);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyChangeEvent firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return null;
        }
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Firing property change \"" + propertyName + "\" to " + this.listeners.size() + " listeners: " + this.listeners));
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for property change " + propertyName + " must fired on the foreground thread.");
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.propertyChanged(evt);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionEvent fireTransactionStarted(String message) {
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for a transaction start must fired on the foreground thread.");
        }
        logger.debug((Object)(this.getName() + "[" + this.getUUID() + "]: Firing transaction started to " + this.listeners.size() + " listeners"));
        TransactionEvent evt = TransactionEvent.createStartTransactionEvent(this, message);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.transactionStarted(evt);
            }
        }
        return evt;
    }

    protected TransactionEvent fireTransactionEnded() {
        return this.fireTransactionEnded("Transaction Ended; Source: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionEvent fireTransactionEnded(String message) {
        int i;
        ArrayList<SPListener> staticListeners;
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for a transaction end must fired on the foreground thread.");
        }
        logger.debug((Object)(this.getName() + "[" + this.getUUID() + "]: Firing transaction ended to " + this.listeners.size() + " listeners"));
        TransactionEvent evt = TransactionEvent.createEndTransactionEvent(this, message);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            staticListeners = new ArrayList<SPListener>(this.listeners);
            for (i = staticListeners.size() - 1; i >= 0; --i) {
                if (!(staticListeners.get(i) instanceof VetoableSPListener)) continue;
                VetoableSPListener vetoableListener = (VetoableSPListener)staticListeners.get(i);
                try {
                    vetoableListener.vetoableChange();
                    continue;
                }
                catch (Exception e) {
                    this.rollback(e.getMessage());
                    throw new RuntimeException(e);
                }
            }
        }
        list2 = this.listeners;
        synchronized (list2) {
            staticListeners = new ArrayList<SPListener>(this.listeners);
            for (i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.transactionEnded(evt);
            }
        }
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransactionEvent fireTransactionRollback(String message) {
        List<SPListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.size() == 0) {
                return null;
            }
        }
        if (!this.isForegroundThread()) {
            throw new IllegalStateException("Event for a transaction rollback must fired on the foreground thread.");
        }
        logger.debug((Object)(this.getName() + "[" + this.getUUID() + "]: Firing transaction rollback to " + this.listeners.size() + " listeners"));
        TransactionEvent evt = TransactionEvent.createRollbackTransactionEvent(this, message);
        List<SPListener> list2 = this.listeners;
        synchronized (list2) {
            ArrayList<SPListener> staticListeners = new ArrayList<SPListener>(this.listeners);
            for (int i = staticListeners.size() - 1; i >= 0; --i) {
                SPListener listener = (SPListener)staticListeners.get(i);
                listener.transactionRollback(evt);
            }
        }
        return evt;
    }

    @Override
    public void begin(String message) {
        this.fireTransactionStarted(message);
    }

    @Override
    public void commit() {
        this.fireTransactionEnded();
    }

    @Override
    public void commit(String message) {
        this.fireTransactionEnded(message);
    }

    protected boolean isForegroundThread() {
        try {
            return this.getRunnableDispatcher().isForegroundThread();
        }
        catch (SessionNotFoundException e) {
            return true;
        }
    }

    protected void runInBackground(Runnable runner) {
        try {
            this.getRunnableDispatcher().runInBackground(runner);
        }
        catch (SessionNotFoundException e) {
            runner.run();
        }
    }

    protected void runInForeground(Runnable runner) {
        try {
            this.getRunnableDispatcher().runInForeground(runner);
        }
        catch (SessionNotFoundException e) {
            runner.run();
        }
    }

    @Override
    @NonBound
    public boolean isMagicEnabled() {
        return this.magicDisableCount == 0 && (this.getParent() == null || this.getParent().isMagicEnabled());
    }

    @Override
    @NonBound
    public synchronized void setMagicEnabled(boolean enable) {
        if (enable) {
            if (this.magicDisableCount == 0) {
                throw new IllegalArgumentException("Cannot enable magic because it is already enabled.");
            }
            --this.magicDisableCount;
        } else {
            ++this.magicDisableCount;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SPObject && this.getUUID().equals(((SPObject)obj).getUUID());
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public String toString() {
        return super.toString() + ", " + this.getName() + ":" + this.getUUID();
    }
}

