/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object;

import ca.sqlpower.dao.PersistedSPOProperty;
import ca.sqlpower.dao.PersistedSPObject;
import ca.sqlpower.dao.PersisterUtils;
import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.diff.DiffChunk;
import ca.sqlpower.diff.DiffChunkTreeNode;
import ca.sqlpower.diff.DiffInfo;
import ca.sqlpower.diff.DiffType;
import ca.sqlpower.diff.PropertyChange;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.util.MonitorableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Differ
implements SPPersister {
    private static final Logger logger = Logger.getLogger(Differ.class);
    private List<PersistedSPObject> spObjectListToPopulate;
    private List<PersistedSPOProperty> spoPropertyListToPopulate;
    private HashMap<String, PersistedSPObject> oldObjectMap;
    private HashMap<String, PersistedSPObject> newObjectMap;
    private HashMap<String, PersistedSPOProperty> oldPropertyMap;
    private HashMap<String, PersistedSPOProperty> newPropertyMap;
    private DifferPersistCalls persistCalls;
    private Set<String> needToAddProperties = new HashSet<String>();
    private HashMap<String, PersistedObjectTreeNode> treeMap = null;
    private boolean diffCalculated = false;

    public Differ() {
        this.persistCalls = new DifferPersistCalls();
    }

    public synchronized void calcDiff(List<PersistedSPObject> oldPersistedSPOs, List<PersistedSPObject> newPersistedSPOs, List<PersistedSPOProperty> oldPersistedSPOPs, List<PersistedSPOProperty> newPersistedSPOPs) {
        this.calcDiff(oldPersistedSPOs, newPersistedSPOs, oldPersistedSPOPs, newPersistedSPOPs, null);
    }

    public synchronized void calcDiff(List<PersistedSPObject> oldPersistedSPOs, List<PersistedSPObject> newPersistedSPOs, List<PersistedSPOProperty> oldPersistedSPOPs, List<PersistedSPOProperty> newPersistedSPOPs, MonitorableImpl monitor) {
        if (this.diffCalculated) {
            throw new IllegalStateException("This differ has already calculated its diff. Calling this method again will cause the previous diff to enter an invalid state.");
        }
        this.diffCalculated = true;
        this.oldObjectMap = this.makeObjectHashMap(oldPersistedSPOs);
        this.newObjectMap = this.makeObjectHashMap(newPersistedSPOs);
        this.oldPropertyMap = this.makePropertyHashMap(oldPersistedSPOPs);
        this.newPropertyMap = this.makePropertyHashMap(newPersistedSPOPs);
        HashSet<String> objectKeys = new HashSet<String>();
        objectKeys.addAll(this.oldObjectMap.keySet());
        objectKeys.addAll(this.newObjectMap.keySet());
        HashSet<String> propertyKeys = new HashSet<String>();
        propertyKeys.addAll(this.oldPropertyMap.keySet());
        propertyKeys.addAll(this.newPropertyMap.keySet());
        if (monitor != null) {
            monitor.setJobSize(objectKeys.size() + propertyKeys.size());
            monitor.setProgress(0);
        }
        this.calcObjectDiff(this.oldObjectMap, this.newObjectMap, objectKeys, monitor);
        this.calcPropertyDiff(oldPersistedSPOPs, newPersistedSPOPs, this.oldPropertyMap, this.newPropertyMap, propertyKeys, monitor);
        if (monitor != null) {
            monitor.setJobSize(null);
            monitor.setProgress(0);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Differ found " + oldPersistedSPOs.size() + " objects in old revision, " + newPersistedSPOs.size() + " objects in new revision"));
            logger.debug((Object)("\t" + this.persistCalls.persistedSPOsToAdd.size() + " objects must be added, and " + this.persistCalls.persistedSPOsToRemove.size() + " must be removed"));
        }
    }

    private HashMap<String, PersistedSPObject> makeObjectHashMap(List<PersistedSPObject> objects) {
        HashMap<String, PersistedSPObject> map = new HashMap<String, PersistedSPObject>();
        for (int i = 0; i < objects.size(); ++i) {
            PersistedSPObject object = objects.get(i);
            map.put(object.getUUID(), object);
        }
        return map;
    }

    private HashMap<String, PersistedSPOProperty> makePropertyHashMap(List<PersistedSPOProperty> properties) {
        HashMap<String, PersistedSPOProperty> map = new HashMap<String, PersistedSPOProperty>();
        for (int i = 0; i < properties.size(); ++i) {
            PersistedSPOProperty property = properties.get(i);
            map.put(property.getUUID() + property.getPropertyName(), property);
        }
        return map;
    }

    private PersistedObjectTreeNode getTreeNode(String uuid) {
        if (this.treeMap == null) {
            this.createObjectTreeMap();
        }
        return this.treeMap.get(uuid);
    }

    private void createObjectTreeMap() {
        this.treeMap = new HashMap();
        PersistedSPObject root = this.newObjectMap.values().iterator().next();
        while (root.getParentUUID() != null && !root.getParentUUID().equals("") && this.newObjectMap.get(root.getParentUUID()) != null) {
            logger.debug((Object)root.getParentUUID());
            root = this.newObjectMap.get(root.getParentUUID());
        }
        this.treeMap.put(root.getUUID(), new PersistedObjectTreeNode(root));
        for (PersistedSPObject o : this.newObjectMap.values()) {
            this.addObjectToTree(o);
        }
    }

    private void addObjectToTree(PersistedSPObject object) {
        LinkedList<PersistedSPObject> ancestors = new LinkedList<PersistedSPObject>();
        PersistedSPObject ancestor = object;
        while (ancestor != null && !this.treeMap.containsKey(ancestor.getUUID())) {
            ancestors.add(0, ancestor);
            ancestor = this.newObjectMap.get(ancestor.getParentUUID());
        }
        for (PersistedSPObject o : ancestors) {
            PersistedObjectTreeNode node = new PersistedObjectTreeNode(o);
            if (this.treeMap.get(o.getParentUUID()) != null) {
                this.treeMap.get(o.getParentUUID()).addNode(node);
            }
            this.treeMap.put(o.getUUID(), node);
        }
    }

    private void calcObjectDiff(HashMap<String, PersistedSPObject> oldObjectMap, HashMap<String, PersistedSPObject> newObjectMap, HashSet<String> objectKeys, MonitorableImpl monitor) {
        String uuid;
        int i;
        Iterator<String> keyIterator = objectKeys.iterator();
        HashMap<String, PersistedSPObject> objectsToRemove = new HashMap<String, PersistedSPObject>();
        for (i = 0; i < objectKeys.size(); ++i) {
            uuid = keyIterator.next();
            PersistedSPObject oldObject = oldObjectMap.get(uuid);
            PersistedSPObject newObject = newObjectMap.get(uuid);
            if (oldObject == null) {
                if (!this.persistCalls.persistedSPOsToAdd.contains(newObject)) {
                    this.persistCalls.persistedSPOsToAdd.add(newObject);
                }
            } else if (newObject == null) {
                objectsToRemove.put(oldObject.getUUID(), oldObject);
            } else if (!oldObject.equals(newObject)) {
                this.persistCalls.persistedSPOsToRemove.add(oldObject);
                HashSet<String> descendants = new HashSet<String>();
                this.getObjectsRecursively(newObject, descendants);
                for (String descendant : descendants) {
                    if (this.persistCalls.persistedSPOsToAdd.contains(newObjectMap.get(descendant))) continue;
                    this.persistCalls.persistedSPOsToAdd.add(newObjectMap.get(descendant));
                }
                this.needToAddProperties.addAll(descendants);
            }
            if (monitor == null) continue;
            monitor.incrementProgress();
        }
        keyIterator = objectsToRemove.keySet().iterator();
        for (i = 0; i < objectsToRemove.size(); ++i) {
            uuid = keyIterator.next();
            if (objectsToRemove.containsKey(((PersistedSPObject)objectsToRemove.get(uuid)).getParentUUID())) continue;
            this.persistCalls.persistedSPOsToRemove.add((PersistedSPObject)objectsToRemove.get(uuid));
        }
    }

    private void getObjectsRecursively(PersistedSPObject object, Set<String> descendants) {
        descendants.add(object.getUUID());
        PersistedObjectTreeNode node = this.getTreeNode(object.getUUID());
        for (PersistedObjectTreeNode child : node.children) {
            this.getObjectsRecursively(child.object, descendants);
        }
    }

    private void calcPropertyDiff(List<PersistedSPOProperty> oldPersistedSPOPs, List<PersistedSPOProperty> newPersistedSPOPs, HashMap<String, PersistedSPOProperty> oldPropertyMap, HashMap<String, PersistedSPOProperty> newPropertyMap, HashSet<String> propertyKeys, MonitorableImpl monitor) {
        Iterator<String> keyIterator = propertyKeys.iterator();
        for (int i = 0; i < propertyKeys.size(); ++i) {
            String key = keyIterator.next();
            PersistedSPOProperty oldProperty = oldPropertyMap.get(key);
            PersistedSPOProperty newProperty = newPropertyMap.get(key);
            if (oldProperty == null) {
                this.persistCalls.propertyDiffPersists.add(new PersistedSPOProperty(newProperty.getUUID(), newProperty.getPropertyName(), newProperty.getDataType(), null, newProperty.getNewValue(), true));
            } else if (newProperty == null) {
                if (this.newObjectMap.containsKey(oldProperty.getUUID())) {
                    this.persistCalls.propertyDiffPersists.add(new PersistedSPOProperty(oldProperty.getUUID(), oldProperty.getPropertyName(), oldProperty.getDataType(), oldProperty.getNewValue(), null, true));
                }
            } else if (!oldProperty.equals(newProperty)) {
                this.persistCalls.propertyDiffPersists.add(new PersistedSPOProperty(oldProperty.getUUID(), oldProperty.getPropertyName(), oldProperty.getDataType(), oldProperty.getNewValue(), newProperty.getNewValue(), true));
            } else if (this.needToAddProperties.contains(newProperty.getUUID())) {
                this.persistCalls.propertyDiffPersists.add(new PersistedSPOProperty(newProperty.getUUID(), newProperty.getPropertyName(), newProperty.getDataType(), newProperty.getNewValue(), newProperty.getNewValue(), true));
            }
            if (monitor == null) continue;
            monitor.incrementProgress();
        }
    }

    public List<PersistedSPObject> getPersistedSPOsToAdd() {
        return this.persistCalls.persistedSPOsToAdd;
    }

    public List<PersistedSPObject> getPersistedSPOsToRemove() {
        return this.persistCalls.persistedSPOsToRemove;
    }

    public List<PersistedSPOProperty> getPropertyDiffPersists() {
        return this.persistCalls.propertyDiffPersists;
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public void persistObject(String parentUUID, String type, String uuid, int index) throws SPPersistenceException {
        this.spObjectListToPopulate.add(new PersistedSPObject(parentUUID, type, uuid, index));
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object oldValue, Object newValue) throws SPPersistenceException {
        this.spoPropertyListToPopulate.add(new PersistedSPOProperty(uuid, propertyName, propertyType, newValue, newValue, false));
    }

    @Override
    public void persistProperty(String uuid, String propertyName, SPPersister.DataType propertyType, Object newValue) throws SPPersistenceException {
        this.spoPropertyListToPopulate.add(new PersistedSPOProperty(uuid, propertyName, propertyType, newValue, newValue, false));
    }

    @Override
    public void removeObject(String parentUUID, String uuid) throws SPPersistenceException {
        throw new IllegalStateException("JCR Persistor is wanting to remove objects when it is creating revision.");
    }

    @Override
    public void rollback() {
        logger.error((Object)"JCR Persistor rolled back when creating revision.");
    }

    public void persistTo(SPPersister p) throws SPPersistenceException {
        this.persistTo(p, true);
    }

    public void persistTo(SPPersister p, boolean justNew) throws SPPersistenceException {
        PersistedSPObject object;
        int i;
        p.begin();
        for (i = 0; i < this.persistCalls.persistedSPOsToRemove.size(); ++i) {
            object = this.persistCalls.persistedSPOsToRemove.get(i);
            p.removeObject(object.getParentUUID(), object.getUUID());
        }
        for (i = 0; i < this.persistCalls.persistedSPOsToAdd.size(); ++i) {
            object = this.persistCalls.persistedSPOsToAdd.get(i);
            p.persistObject(object.getParentUUID(), object.getType(), object.getUUID(), object.getIndex());
        }
        for (i = 0; i < this.persistCalls.propertyDiffPersists.size(); ++i) {
            PersistedSPOProperty property = this.persistCalls.propertyDiffPersists.get(i);
            if (justNew) {
                p.persistProperty(property.getUUID(), property.getPropertyName(), property.getDataType(), property.getNewValue());
                continue;
            }
            p.persistProperty(property.getUUID(), property.getPropertyName(), property.getDataType(), property.getOldValue(), property.getNewValue());
        }
        p.commit();
    }

    public boolean hasDifferences() {
        return !this.persistCalls.persistedSPOsToRemove.isEmpty() || !this.persistCalls.persistedSPOsToAdd.isEmpty() || !this.persistCalls.propertyDiffPersists.isEmpty();
    }

    public void sortPersistedObjects() {
        Collections.sort(this.persistCalls.persistedSPOsToAdd, new PersistedObjectComparator(this.persistCalls.persistedSPOsToAdd));
    }

    public HashMap<String, PersistedSPOProperty> getOldPropertyMap() {
        return this.oldPropertyMap;
    }

    public Object getOldPropertyValue(String uuid, String pName) {
        return this.oldPropertyMap.get(uuid + pName).getNewValue();
    }

    public Object getNewPropertyValue(String uuid, String pName) {
        return this.newPropertyMap.get(uuid + pName).getNewValue();
    }

    public boolean omitRootObject(String workspaceUUID, String newRootUUID) {
        int i;
        String rootUUID = "";
        for (i = 0; i < this.persistCalls.persistedSPOsToAdd.size(); ++i) {
            if (!this.persistCalls.persistedSPOsToAdd.get(i).getParentUUID().equals(workspaceUUID)) continue;
            rootUUID = this.persistCalls.persistedSPOsToAdd.get(i).getUUID();
            this.persistCalls.persistedSPOsToAdd.remove(i);
            break;
        }
        if (rootUUID.equals("")) {
            return false;
        }
        for (i = 0; i < this.persistCalls.propertyDiffPersists.size(); ++i) {
            if (!this.persistCalls.propertyDiffPersists.get(i).getUUID().equals(rootUUID)) continue;
            this.persistCalls.propertyDiffPersists.remove(i);
            --i;
        }
        if (!newRootUUID.equals("")) {
            for (i = 0; i < this.persistCalls.persistedSPOsToAdd.size(); ++i) {
                PersistedSPObject child = this.persistCalls.persistedSPOsToAdd.get(i);
                if (!child.getParentUUID().equals(rootUUID)) continue;
                this.persistCalls.persistedSPOsToAdd.add(new PersistedSPObject(newRootUUID, child.getType(), child.getUUID(), child.getIndex()));
                this.persistCalls.persistedSPOsToAdd.remove(i);
                --i;
            }
        }
        return true;
    }

    public HashMap<String, PersistedSPObject> getOldObjectMap() {
        return this.oldObjectMap;
    }

    public HashMap<String, PersistedSPObject> getNewObjectMap() {
        return this.newObjectMap;
    }

    public String getObjectType(String uuid) throws SQLObjectException {
        if (this.oldObjectMap.get(uuid) != null) {
            return this.oldObjectMap.get(uuid).getSimpleType();
        }
        if (this.newObjectMap.get(uuid) != null) {
            return this.newObjectMap.get(uuid).getSimpleType();
        }
        throw new SQLObjectException("Could not find object in map");
    }

    public String getOldObjectName(String uuid) {
        return (String)this.getOldPropertyValue(uuid, "name");
    }

    public String getNewObjectName(String uuid) {
        return (String)this.getNewPropertyValue(uuid, "name");
    }

    public List<DiffChunk<DiffInfo>> getDiffChunks(String rootUUID) throws SQLObjectException {
        DiffInfo d;
        String uuid;
        HashMap<String, DiffChunk<DiffInfo>> diffChunks = new HashMap<String, DiffChunk<DiffInfo>>();
        HashMap<String, String> parentMap = new HashMap<String, String>();
        for (PersistedSPObject o : this.persistCalls.persistedSPOsToRemove) {
            uuid = o.getUUID();
            this.getObjectType(uuid);
            this.getOldObjectName(uuid);
            d = new DiffInfo(this.getObjectType(uuid), this.getOldObjectName(uuid));
            diffChunks.put(uuid, new DiffChunk<DiffInfo>(d, DiffType.LEFTONLY));
            this.addAncestorsToMap(uuid, rootUUID, this.oldObjectMap, parentMap);
        }
        for (PersistedSPObject o : this.persistCalls.persistedSPOsToAdd) {
            uuid = o.getUUID();
            d = new DiffInfo(this.getObjectType(uuid), this.getNewObjectName(uuid));
            diffChunks.put(uuid, new DiffChunk<DiffInfo>(d, DiffType.RIGHTONLY));
            this.addAncestorsToMap(uuid, rootUUID, this.newObjectMap, parentMap);
        }
        for (PersistedSPOProperty p : this.persistCalls.propertyDiffPersists) {
            uuid = p.getUUID();
            if (!diffChunks.containsKey(uuid)) {
                d = new DiffInfo(this.getObjectType(uuid), this.getOldObjectName(uuid));
                diffChunks.put(uuid, new DiffChunk<DiffInfo>(d, DiffType.MODIFIED));
                this.addAncestorsToMap(uuid, rootUUID, this.oldObjectMap, parentMap);
            }
            if (((DiffChunk)diffChunks.get(uuid)).getType() != DiffType.MODIFIED) continue;
            try {
                Set<String> interestingProperties = PersisterUtils.getInterestingPropertyNames(this.oldObjectMap.get(uuid).getType());
                if (!interestingProperties.contains(p.getPropertyName())) continue;
                String oldValue = String.valueOf(p.getOldValue());
                String newValue = String.valueOf(p.getNewValue());
                if (p.getDataType() == SPPersister.DataType.STRING) {
                    if (p.getOldValue() != null) {
                        oldValue = "\"" + oldValue + "\"";
                    }
                    if (p.getNewValue() != null) {
                        newValue = "\"" + newValue + "\"";
                    }
                }
                PropertyChange change = new PropertyChange(p.getPropertyName(), oldValue, newValue);
                ((DiffChunk)diffChunks.get(p.getUUID())).addPropertyChange(change);
                logger.debug((Object)("Added change: " + change));
            }
            catch (Exception e) {
                throw new SQLObjectException("Error looking up interesting property names", e);
            }
        }
        diffChunks.remove(rootUUID);
        parentMap.remove(rootUUID);
        for (String leafUUID : parentMap.keySet()) {
            String nextUUID = (String)parentMap.get(leafUUID);
            logger.debug((Object)("Leaf " + this.getObjectType(leafUUID) + ": " + leafUUID));
            while (!nextUUID.equals(rootUUID) && !diffChunks.containsKey(nextUUID)) {
                logger.debug((Object)nextUUID);
                d = new DiffInfo(this.getObjectType(nextUUID), this.getOldObjectName(nextUUID));
                diffChunks.put(nextUUID, new DiffChunk<DiffInfo>(d, DiffType.SAME));
                parentMap.put(nextUUID, this.oldObjectMap.get(nextUUID).getParentUUID());
                nextUUID = (String)parentMap.get(nextUUID);
            }
        }
        DiffChunkTreeNode root = new DiffChunkTreeNode(rootUUID, null);
        root.constructTree(diffChunks, parentMap);
        return root.buildOrderedList();
    }

    private void addAncestorsToMap(String uuid, String rootUUID, Map<String, PersistedSPObject> objectMap, Map<String, String> parentMap) {
        String nextUUID = uuid;
        while (!nextUUID.equals(rootUUID) && !parentMap.containsKey(nextUUID)) {
            parentMap.put(nextUUID, objectMap.get(nextUUID).getParentUUID());
            nextUUID = objectMap.get(nextUUID).getParentUUID();
        }
    }

    private static class PersistedObjectTreeNode {
        private final PersistedSPObject object;
        private final List<PersistedObjectTreeNode> children = new LinkedList<PersistedObjectTreeNode>();

        public PersistedObjectTreeNode(PersistedSPObject object) {
            this.object = object;
        }

        private void addNode(PersistedObjectTreeNode child) {
            this.children.add(child);
        }
    }

    private class PersistedObjectComparator
    implements Comparator<PersistedSPObject> {
        private HashSet<String> uuidsToAdd = new HashSet();
        private HashMap<String, Integer> depthMap = new HashMap();

        public PersistedObjectComparator(List<PersistedSPObject> objectsToAdd) {
            for (PersistedSPObject o : ((Differ)Differ.this).persistCalls.persistedSPOsToAdd) {
                this.uuidsToAdd.add(o.getUUID());
            }
        }

        @Override
        public int compare(PersistedSPObject o1, PersistedSPObject o2) {
            if (this.getDepth(o1) < this.getDepth(o2)) {
                return -1;
            }
            if (this.getDepth(o1) > this.getDepth(o2)) {
                return 1;
            }
            return o1.getIndex() - o2.getIndex();
        }

        private int getDepth(PersistedSPObject o) {
            if (!this.depthMap.containsKey(o.getUUID())) {
                if (this.uuidsToAdd.contains(o.getParentUUID())) {
                    this.depthMap.put(o.getUUID(), this.getDepth((PersistedSPObject)Differ.this.newObjectMap.get(o.getParentUUID())) + 1);
                } else {
                    this.depthMap.put(o.getUUID(), 0);
                }
            }
            return this.depthMap.get(o.getUUID());
        }
    }

    private class DifferPersistCalls {
        protected final List<PersistedSPObject> persistedSPOsToAdd = new ArrayList<PersistedSPObject>();
        protected final List<PersistedSPObject> persistedSPOsToRemove = new ArrayList<PersistedSPObject>();
        protected final List<PersistedSPOProperty> propertyDiffPersists = new ArrayList<PersistedSPOProperty>();

        protected DifferPersistCalls() {
        }
    }
}

