/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.object.generated;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.helper.AbstractSPPersisterHelper;
import ca.sqlpower.dao.session.SessionPersisterSuperConverter;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSPObjectPersisterHelper<T extends AbstractSPObject>
extends AbstractSPPersisterHelper<T> {
    private List<String> persistedPropertiesList = null;

    @Override
    public void commitProperty(SPObject o, String propertyName, Object newValue, SPPersister.DataType dataType, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        AbstractSPObject castedObject = (AbstractSPObject)o;
        if (propertyName.equals("parent")) {
            castedObject.setParent((SPObject)converter.convertToComplexType(newValue, SPObject.class));
        } else if (propertyName.equals("name")) {
            castedObject.setName((String)converter.convertToComplexType(newValue, String.class));
        } else if (propertyName.equals("UUID")) {
            castedObject.setUUID((String)converter.convertToComplexType(newValue, String.class));
        } else {
            throw new SPPersistenceException(castedObject.getUUID(), AbstractSPObjectPersisterHelper.createSPPersistenceExceptionMessage(castedObject, propertyName));
        }
    }

    @Override
    public Object findProperty(SPObject o, String propertyName, SessionPersisterSuperConverter converter) throws SPPersistenceException {
        AbstractSPObject castedObject = (AbstractSPObject)o;
        if (propertyName.equals("parent")) {
            return converter.convertToBasicType(castedObject.getParent(), new Object[0]);
        }
        if (propertyName.equals("name")) {
            return converter.convertToBasicType(castedObject.getName(), new Object[0]);
        }
        if (propertyName.equals("UUID")) {
            return converter.convertToBasicType(castedObject.getUUID(), new Object[0]);
        }
        throw new SPPersistenceException(castedObject.getUUID(), AbstractSPObjectPersisterHelper.createSPPersistenceExceptionMessage(castedObject, propertyName));
    }

    @Override
    public void persistObjectProperties(SPObject o, SPPersister persister, SessionPersisterSuperConverter converter, List<String> staticPreProcessedProps) throws SPPersistenceException {
        ArrayList<String> preProcessedProps = new ArrayList<String>(staticPreProcessedProps);
        String uuid = o.getUUID();
        AbstractSPObject castedObject = (AbstractSPObject)o;
        try {
            SPPersister.DataType dataType;
            if (!preProcessedProps.contains("parent")) {
                dataType = SPPersister.DataType.REFERENCE;
                persister.persistProperty(uuid, "parent", dataType, converter.convertToBasicType(castedObject.getParent(), new Object[0]));
                preProcessedProps.add("parent");
            }
            if (!preProcessedProps.contains("name")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "name", dataType, converter.convertToBasicType(castedObject.getName(), new Object[0]));
                preProcessedProps.add("name");
            }
            if (!preProcessedProps.contains("UUID")) {
                dataType = SPPersister.DataType.STRING;
                persister.persistProperty(uuid, "UUID", dataType, converter.convertToBasicType(castedObject.getUUID(), new Object[0]));
                preProcessedProps.add("UUID");
            }
        }
        catch (Exception e) {
            throw new SPPersistenceException(uuid, e);
        }
    }

    @Override
    public List<String> getPersistedProperties() throws SPPersistenceException {
        if (this.persistedPropertiesList != null) {
            return this.persistedPropertiesList;
        }
        String[] persistedPropertiesArray = new String[]{"parent", "name", "UUID"};
        this.persistedPropertiesList = new ArrayList<String>(Arrays.asList(persistedPropertiesArray));
        return this.persistedPropertiesList;
    }
}

