/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPVariableResolver;
import ca.sqlpower.object.SPVariableResolverProvider;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonBound;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.sqlobject.DuplicateColumnException;
import ca.sqlpower.sqlobject.SQLCheckConstraint;
import ca.sqlpower.sqlobject.SQLCheckConstraintContainer;
import ca.sqlpower.sqlobject.SQLCheckConstraintVariableResolver;
import ca.sqlpower.sqlobject.SQLEnumeration;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.sqlobject.SQLTypePhysicalProperties;
import ca.sqlpower.sqlobject.SQLTypePhysicalPropertiesProvider;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import ca.sqlpower.swingui.ModalDialogListUserPrompter;
import ca.sqlpower.util.UserPrompter;
import ca.sqlpower.util.UserPrompterFactory;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class SQLColumn
extends SQLObject
implements Serializable,
SPVariableResolverProvider,
SQLCheckConstraintContainer {
    private static Logger logger = Logger.getLogger(SQLColumn.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.singletonList(UserDefinedSQLType.class);
    protected final UserDefinedSQLType userDefinedSQLType;
    protected String platform;
    protected SQLColumn sourceColumn;
    protected String remarks = "";
    private String autoIncrementSequenceName;
    private String etlTransformationLogic;
    private String etlDefaultValue;
    private Boolean etlAuditable;
    private String etlNotes;
    private static String defaultName;
    private static int defaultType;
    private static int defaultPrec;
    private static int defaultScale;
    private static boolean defaultInPK;
    private static boolean defaultNullable;
    private static boolean defaultAutoInc;
    private static String defaultRemarks;
    private static String defaultForDefaultValue;
    protected int referenceCount;
    private final SQLCheckConstraintVariableResolver variableResolver = new SQLCheckConstraintVariableResolver(this);

    public SQLColumn() {
        this.userDefinedSQLType = new UserDefinedSQLType();
        this.userDefinedSQLType.setParent(this);
        this.setPlatform("GENERIC");
        logger.debug((Object)("NEW COLUMN (noargs) @" + this.hashCode()));
        logger.debug((Object)"SQLColumn() set ref count to 1");
        this.referenceCount = 1;
        this.setName(defaultName);
        this.setPhysicalName("");
        this.userDefinedSQLType.setType(defaultType);
        this.userDefinedSQLType.setPrecision(this.platform, defaultPrec);
        if (defaultPrec > 0) {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        this.userDefinedSQLType.setScale(this.platform, defaultScale);
        if (defaultScale > 0) {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        if (defaultNullable) {
            this.userDefinedSQLType.setMyNullability(1);
        } else {
            this.userDefinedSQLType.setMyNullability(0);
        }
        this.userDefinedSQLType.setMyAutoIncrement(defaultAutoInc);
        this.userDefinedSQLType.setDefaultValue(this.platform, defaultForDefaultValue);
        this.remarks = defaultRemarks;
        this.setPopulated(true);
    }

    public SQLColumn(UserDefinedSQLType startingType) {
        this.userDefinedSQLType = new UserDefinedSQLType();
        this.userDefinedSQLType.setParent(this);
        this.userDefinedSQLType.setUpstreamType(startingType);
        this.setPlatform("GENERIC");
        this.setName(defaultName);
        this.setPhysicalName("");
        this.setRemarks(defaultRemarks);
        this.referenceCount = 1;
        this.setPopulated(true);
    }

    public SQLColumn(SQLTable parentTable, String colName, int dataType, String nativeType, int precision, int scale, int nullable, String remarks, String defaultValue, boolean isAutoIncrement) {
        if (parentTable != null) {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " parent " + parentTable.getName() + "@" + parentTable.hashCode()));
        } else {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " (null parent)"));
        }
        if (parentTable != null) {
            this.setParent(parentTable);
        }
        this.userDefinedSQLType = new UserDefinedSQLType();
        this.userDefinedSQLType.setParent(this);
        this.setPlatform("GENERIC");
        this.setName(colName);
        this.setPopulated(true);
        this.userDefinedSQLType.setType(dataType);
        this.userDefinedSQLType.setScale(this.platform, scale);
        if (scale > 0) {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        this.userDefinedSQLType.setPrecision(this.platform, precision);
        if (precision > 0) {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        this.userDefinedSQLType.setMyNullability(nullable);
        this.userDefinedSQLType.setDefaultValue(this.platform, defaultValue);
        this.userDefinedSQLType.setMyAutoIncrement(isAutoIncrement);
        this.userDefinedSQLType.setName(nativeType);
        this.remarks = remarks;
        logger.debug((Object)"SQLColumn(.....) set ref count to 1");
        this.referenceCount = 1;
    }

    public SQLColumn(SQLTable parentTable, String colName, UserDefinedSQLType type, int precision, int scale, boolean isAutoIncrement) {
        if (parentTable != null) {
            this.setParent(parentTable);
        }
        this.userDefinedSQLType = new UserDefinedSQLType("UserDefinedSQLType", 1, isAutoIncrement, null, type, new SQLTypePhysicalProperties("GENERIC"));
        this.userDefinedSQLType.setParent(this);
        this.setPlatform("GENERIC");
        this.setName(colName);
        this.setPopulated(true);
        this.userDefinedSQLType.setScale(this.platform, scale);
        if (scale > 0) {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setScaleType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        this.userDefinedSQLType.setPrecision(this.platform, precision);
        if (precision > 0) {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else {
            this.userDefinedSQLType.setPrecisionType(this.platform, SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE);
        }
        this.userDefinedSQLType.setMyNullability(1);
        logger.debug((Object)"SQLColumn(.....) set ref count to 1");
        this.referenceCount = 1;
    }

    @Constructor
    public SQLColumn(@ConstructorParameter(propertyName="parent") SQLTable parentTable, @ConstructorParameter(propertyName="name") String colName, @ConstructorParameter(propertyName="sourceDataTypeName") String nativeType, @ConstructorParameter(propertyName="remarks") String remarks, @ConstructorParameter(parameterType=ConstructorParameter.ParameterType.CHILD, propertyName="userDefinedSQLType") UserDefinedSQLType userDefinedSQLType) {
        if (parentTable != null) {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " parent " + parentTable.getName() + "@" + parentTable.hashCode()));
        } else {
            logger.debug((Object)("NEW COLUMN " + colName + "@" + this.hashCode() + " (null parent)"));
        }
        if (parentTable != null) {
            this.setParent(parentTable);
        }
        this.userDefinedSQLType = userDefinedSQLType;
        userDefinedSQLType.setParent(this);
        this.setPlatform("GENERIC");
        this.setName(colName);
        this.setPopulated(true);
        this.remarks = remarks;
        logger.debug((Object)"SQLColumn(.....) set ref count to 1");
        this.referenceCount = 1;
    }

    public SQLColumn(SQLTable parent, String colName, int type, int precision, int scale) {
        this(parent, colName, type, null, precision, scale, 1, null, null, false);
    }

    public SQLColumn(SQLColumn col) {
        this.userDefinedSQLType = new UserDefinedSQLType();
        this.userDefinedSQLType.setParent(this);
        this.setPlatform("GENERIC");
        this.setPopulated(true);
        SQLColumn.copyProperties(this, col);
        logger.debug((Object)("SQLColumn(SQLColumn col [" + col + " " + col.hashCode() + "]) set ref count to 1"));
        this.referenceCount = 1;
    }

    public SQLColumn createInheritingInstance(SQLTable addTo) {
        logger.debug((Object)"derived instance SQLColumn constructor invocation.");
        SQLColumn c = new SQLColumn();
        SQLColumn.copyProperties(c, this);
        c.setParent(addTo);
        c.sourceColumn = SQLObjectUtils.isInSameSession(c, this) ? this : null;
        logger.debug((Object)"getDerivedInstance set ref count to 1");
        c.referenceCount = 1;
        return c;
    }

    public SQLColumn createCopy(SQLTable addTo, boolean preserveSource) {
        logger.debug((Object)"derived instance SQLColumn constructor invocation.");
        SQLColumn c = new SQLColumn();
        SQLColumn.copyProperties(c, this);
        c.setParent(addTo);
        if (preserveSource) {
            c.sourceColumn = this.getSourceColumn();
        }
        logger.debug((Object)"getDerivedInstance set ref count to 1");
        c.referenceCount = 1;
        return c;
    }

    private static final void copyProperties(final SQLColumn target, final SQLColumn source) {
        target.runInForeground(new Runnable(){

            @Override
            public void run() {
                target.begin("Copying SQLColumn.");
                target.setPlatform(source.getPlatform());
                target.setName(source.getName());
                target.setPhysicalName(source.getPhysicalName());
                target.setRemarks(source.remarks);
                target.setAutoIncrementSequenceName(source.autoIncrementSequenceName);
                target.setEtlAuditable(source.getEtlAuditable());
                target.setEtlDefaultValue(source.getEtlDefaultValue());
                target.setEtlNotes(source.getEtlNotes());
                target.setEtlTransformationLogic(source.getEtlTransformationLogic());
                UserDefinedSQLType.copyProperties(target.getUserDefinedSQLType(), source.getUserDefinedSQLType());
                target.commit();
            }
        });
    }

    @Override
    public void updateToMatch(SQLObject source) {
        SQLColumn.copyProperties(this, (SQLColumn)source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ListMultimap<String, SQLColumn> fetchColumnsForTable(String catalog, String schema, String table, DatabaseMetaData dbmd) throws SQLException, DuplicateColumnException, SQLObjectException {
        ResultSet rs = null;
        ArrayListMultimap multimap = ArrayListMultimap.create();
        try {
            logger.debug((Object)("SQLColumn.addColumnsToTables: catalog=" + catalog + "; schema=" + schema));
            rs = dbmd.getColumns(catalog, schema, table, "%");
            int autoIncCol = SQL.findColumnIndex(rs, "is_autoincrement");
            logger.debug((Object)("Auto-increment info column: " + autoIncCol));
            while (rs.next()) {
                logger.debug((Object)"addColumnsToTable SQLColumn constructor invocation.");
                String tableName = rs.getString(3);
                boolean autoIncrement = autoIncCol > 0 ? "yes".equalsIgnoreCase(rs.getString(autoIncCol)) : false;
                String nativeTypeName = rs.getString(6);
                if (nativeTypeName.indexOf(40) >= 0) {
                    nativeTypeName = nativeTypeName.substring(0, nativeTypeName.indexOf(40));
                }
                SQLColumn col = new SQLColumn(null, rs.getString(4), rs.getInt(5), nativeTypeName, rs.getInt(7), rs.getInt(9), rs.getInt(11), rs.getString(12) == null ? "" : rs.getString(12), rs.getString(13), autoIncrement);
                logger.debug((Object)("Precision for the column " + rs.getString(4) + " is " + rs.getInt(7)));
                String dbTableName = rs.getString(3);
                if (dbTableName != null) {
                    if (!dbTableName.equalsIgnoreCase(tableName)) {
                        logger.warn((Object)("Got column " + col.getName() + " from " + dbTableName + " in metadata for " + tableName + "; not adding this column."));
                        continue;
                    }
                } else {
                    logger.warn((Object)"Table name not specified in metadata.  Continuing anyway...");
                }
                logger.debug((Object)("Adding column " + col.getName()));
                multimap.put((Object)dbTableName, (Object)col);
            }
            ArrayListMultimap arrayListMultimap = multimap;
            return arrayListMultimap;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"Couldn't close result set", (Throwable)ex);
            }
        }
    }

    public static void assignTypes(List<SQLColumn> columns, DataSourceCollection<? extends SPDataSource> dsCollection, String fromPlatform, UserPrompterFactory upf) {
        if (fromPlatform == null) {
            return;
        }
        List<UserDefinedSQLType> types = dsCollection.getSQLTypes();
        HashMap<String, UserDefinedSQLType> typeMapByReverseName = new HashMap<String, UserDefinedSQLType>();
        LinkedListMultimap typeMapByForwardName = LinkedListMultimap.create();
        LinkedListMultimap typeMapByCode = LinkedListMultimap.create();
        for (UserDefinedSQLType type : types) {
            typeMapByReverseName.put(type.getName().toLowerCase(), type);
            typeMapByForwardName.put((Object)type.getPhysicalProperties(fromPlatform).getName().toLowerCase(), (Object)type);
            typeMapByCode.put((Object)type.getType(), (Object)type);
        }
        HashMap<String, UserPrompter> userPrompters = new HashMap<String, UserPrompter>();
        for (SQLColumn column : columns) {
            UserDefinedSQLType upstreamType;
            if (column.getUserDefinedSQLType().getUpstreamType() != null) continue;
            String nativeType = column.getSourceDataTypeName();
            if (nativeType != null) {
                nativeType = nativeType.toLowerCase();
            }
            logger.info((Object)("Column has type " + nativeType));
            if (typeMapByReverseName.containsKey(nativeType)) {
                upstreamType = (UserDefinedSQLType)typeMapByReverseName.get(nativeType);
            } else {
                List upstreamTypes = nativeType == null ? typeMapByForwardName.get((Object)"") : typeMapByForwardName.get((Object)nativeType.toLowerCase());
                if (upstreamTypes.size() == 0) {
                    int jdbcCode = column.getType();
                    upstreamTypes = typeMapByCode.get((Object)jdbcCode);
                    if (upstreamTypes.size() == 0) {
                        upstreamType = dsCollection.getNewSQLType(nativeType, jdbcCode);
                        typeMapByForwardName.put((Object)nativeType, (Object)upstreamType);
                        typeMapByCode.put((Object)jdbcCode, (Object)upstreamType);
                    } else if (upstreamTypes.size() == 1) {
                        upstreamType = (UserDefinedSQLType)upstreamTypes.get(0);
                    } else {
                        UserPrompter prompt;
                        if (userPrompters.get(nativeType) != null) {
                            prompt = (UserPrompter)userPrompters.get(nativeType);
                        } else {
                            prompt = upf.createListUserPrompter("Choose a type for " + column.getShortDisplayName(), upstreamTypes, upstreamTypes.get(0));
                            userPrompters.put(nativeType, prompt);
                        }
                        prompt.promptUser(new Object[0]);
                        upstreamType = (UserDefinedSQLType)prompt.getUserSelectedResponse();
                    }
                } else if (upstreamTypes.size() == 1) {
                    upstreamType = (UserDefinedSQLType)upstreamTypes.get(0);
                } else {
                    UserPrompter prompt;
                    if (userPrompters.containsKey(nativeType)) {
                        prompt = (UserPrompter)userPrompters.get(nativeType);
                        if (prompt instanceof ModalDialogListUserPrompter) {
                            ((ModalDialogListUserPrompter)prompt).setQuestionField("Choose a type for " + column.getShortDisplayName());
                        }
                    } else {
                        prompt = upf.createListUserPrompter("Choose a type for " + column.getShortDisplayName(), upstreamTypes, upstreamTypes.get(0));
                        userPrompters.put(nativeType, prompt);
                    }
                    prompt.promptUser(new Object[0]);
                    upstreamType = (UserDefinedSQLType)prompt.getUserSelectedResponse();
                }
            }
            UserDefinedSQLType type = column.getUserDefinedSQLType();
            if (upstreamType == null) continue;
            type.setScaleType(fromPlatform, upstreamType.getScaleType(fromPlatform));
            type.setPrecisionType(fromPlatform, upstreamType.getPrecisionType(fromPlatform));
            if (upstreamType.getScale(fromPlatform) == type.getScale(fromPlatform) || upstreamType.getScaleType(fromPlatform) == SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
                type.setScale(fromPlatform, null);
            }
            if (upstreamType.getPrecision(fromPlatform) == type.getPrecision(fromPlatform) || upstreamType.getPrecisionType(fromPlatform) == SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
                type.setPrecision(fromPlatform, null);
            }
            if (upstreamType.getNullability() != null && upstreamType.getNullability().equals(type.getNullability())) {
                type.setMyNullability(null);
            }
            if (upstreamType.getDefaultValue(fromPlatform) != null && upstreamType.getDefaultValue(fromPlatform).equals(type.getDefaultValue(fromPlatform))) {
                type.setDefaultValue(fromPlatform, null);
            }
            if (upstreamType.getAutoIncrement() != null && upstreamType.getAutoIncrement().equals(type.getAutoIncrement())) {
                type.setMyAutoIncrement(null);
            }
            type.setUpstreamType(upstreamType);
        }
    }

    @Override
    public String toString() {
        return this.getShortDisplayName();
    }

    @Override
    protected void populateImpl() throws SQLObjectException {
    }

    @Override
    @Transient
    @Accessor
    public boolean isPopulated() {
        return true;
    }

    @Transient
    @Accessor
    public String getTypeName() {
        StringBuilder name;
        UserDefinedSQLType upstreamType = this.userDefinedSQLType.getUpstreamType();
        if (upstreamType == null) {
            if (this.userDefinedSQLType.getName() == null) {
                return "";
            }
            name = new StringBuilder(this.userDefinedSQLType.getName());
        } else {
            name = new StringBuilder(upstreamType.getName());
        }
        String defaultPlatform = "GENERIC";
        int precision = this.userDefinedSQLType.getPrecision(defaultPlatform);
        int scale = this.userDefinedSQLType.getScale(defaultPlatform);
        SQLTypePhysicalPropertiesProvider.PropertyType precisionType = this.userDefinedSQLType.getPrecisionType(defaultPlatform);
        SQLTypePhysicalPropertiesProvider.PropertyType scaleType = this.userDefinedSQLType.getScaleType(defaultPlatform);
        if (precisionType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && scaleType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && precision > 0 && scale > 0) {
            name.append("(" + this.userDefinedSQLType.getPrecision(defaultPlatform) + ", " + this.userDefinedSQLType.getScale(defaultPlatform) + ")");
        } else if (precisionType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && precision > 0) {
            name.append("(" + this.userDefinedSQLType.getPrecision(defaultPlatform) + ")");
        } else if (scaleType != SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE && scale > 0) {
            name.append("(" + this.userDefinedSQLType.getScale(defaultPlatform) + ")");
        }
        return name.toString();
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName() + ": " + this.getTypeName();
    }

    @Accessor(isInteresting=true)
    public String getPlatform() {
        return this.platform;
    }

    @Mutator
    public void setPlatform(String newPlatform) {
        String oldPlatform = this.platform;
        this.platform = newPlatform;
        this.begin("Setting platform");
        this.firePropertyChange("platform", oldPlatform, newPlatform);
        if (this.userDefinedSQLType.getPhysicalProperties(newPlatform) == null) {
            this.userDefinedSQLType.putPhysicalProperties(newPlatform, new SQLTypePhysicalProperties(newPlatform));
        }
        this.commit();
    }

    @Accessor
    public UserDefinedSQLType getUserDefinedSQLType() {
        return this.userDefinedSQLType;
    }

    @Override
    @NonBound
    public List<SQLCheckConstraint> getCheckConstraints() {
        return Collections.unmodifiableList(this.userDefinedSQLType.getCheckConstraints(this.getPlatform()));
    }

    @Override
    public void addCheckConstraint(SQLCheckConstraint checkConstraint) {
        this.userDefinedSQLType.addCheckConstraint(this.getPlatform(), checkConstraint);
    }

    @Override
    public boolean removeCheckConstraint(SQLCheckConstraint checkConstraint) {
        return this.userDefinedSQLType.removeCheckConstraint(this.getPlatform(), checkConstraint);
    }

    @Transient
    @Accessor(isInteresting=true)
    public SQLTypePhysicalProperties.SQLTypeConstraint getConstraintType() {
        return this.userDefinedSQLType.getConstraintType(this.getPlatform());
    }

    @Transient
    @Mutator
    public void setConstraintType(SQLTypePhysicalProperties.SQLTypeConstraint constraint) {
        this.userDefinedSQLType.setConstraintType(this.getPlatform(), constraint);
    }

    @NonBound
    public List<SQLEnumeration> getEnumerations() {
        return this.userDefinedSQLType.getEnumerations(this.getPlatform());
    }

    public void addEnumeration(SQLEnumeration enumeration) {
        this.userDefinedSQLType.addEnumeration(this.getPlatform(), enumeration);
    }

    public void removeEnumeration(SQLEnumeration enumeration) {
        this.userDefinedSQLType.removeEnumeration(this.getPlatform(), enumeration);
    }

    @Transient
    @Accessor(isInteresting=true)
    public SQLTypePhysicalPropertiesProvider.PropertyType getPrecisionType() {
        return this.userDefinedSQLType.getPrecisionType(this.getPlatform());
    }

    @Transient
    @Mutator
    public void setPrecisionType(SQLTypePhysicalPropertiesProvider.PropertyType precisionType) {
        this.userDefinedSQLType.setPrecisionType(this.getPlatform(), precisionType);
    }

    @Transient
    @Accessor(isInteresting=true)
    public SQLTypePhysicalPropertiesProvider.PropertyType getScaleType() {
        return this.userDefinedSQLType.getScaleType(this.getPlatform());
    }

    @Transient
    @Mutator
    public void setScaleType(SQLTypePhysicalPropertiesProvider.PropertyType scaleType) {
        this.userDefinedSQLType.setScaleType(this.getPlatform(), scaleType);
    }

    @Accessor
    public SQLColumn getSourceColumn() {
        return this.sourceColumn;
    }

    @Mutator
    public void setSourceColumn(SQLColumn col) {
        this.begin("Setting source column.");
        SQLColumn oldCol = this.sourceColumn;
        this.sourceColumn = col;
        this.firePropertyChange("sourceColumn", oldCol, col);
        this.commit();
    }

    @Transient
    @Accessor(isInteresting=true)
    public int getType() {
        return this.userDefinedSQLType.getType();
    }

    @Transient
    @Mutator
    public void setType(UserDefinedSQLType type) {
        this.userDefinedSQLType.setUpstreamType(type);
    }

    @Transient
    @Mutator
    public void setType(int type) {
        this.userDefinedSQLType.setType(type);
    }

    @Transient
    @Accessor
    public String getSourceDataTypeName() {
        return this.userDefinedSQLType.getName();
    }

    @Transient
    @Mutator
    public void setSourceDataTypeName(String n) {
        this.userDefinedSQLType.setName(n);
    }

    @Transient
    @Accessor(isInteresting=true)
    public int getScale() {
        return this.userDefinedSQLType.getScale(this.getPlatform());
    }

    @Transient
    @Mutator
    public void setScale(int argScale) {
        this.begin("Set scale");
        this.userDefinedSQLType.setScale(this.getPlatform(), argScale);
        if (argScale > 0 && this.getScaleType() == SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
            this.setScaleType(SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else if (argScale == 0 && this.getScaleType() == SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) {
            this.setScaleType(null);
        }
        this.commit();
    }

    @Transient
    @Accessor(isInteresting=true)
    public int getPrecision() {
        return this.userDefinedSQLType.getPrecision(this.getPlatform());
    }

    @Transient
    @Mutator
    public void setPrecision(int argPrecision) {
        this.begin("Set precision");
        this.userDefinedSQLType.setPrecision(this.getPlatform(), argPrecision);
        if (argPrecision > 0 && this.getPrecisionType() == SQLTypePhysicalPropertiesProvider.PropertyType.NOT_APPLICABLE) {
            this.setPrecisionType(SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE);
        } else if (argPrecision == 0 && this.getPrecisionType() == SQLTypePhysicalPropertiesProvider.PropertyType.VARIABLE) {
            this.setPrecisionType(null);
        }
        this.commit();
    }

    @NonBound
    public boolean isDefinitelyNullable() {
        return this.getNullable() == 1;
    }

    @Transient
    @Accessor(isInteresting=true)
    public boolean isPrimaryKey() {
        return this.getParent().isInPrimaryKey(this);
    }

    @NonBound
    public SQLTable getReferencedTable() {
        if (this.getParent() == null) {
            return null;
        }
        try {
            for (SQLRelationship.SQLImportedKey k : this.getParent().getImportedKeys()) {
                if (!k.getRelationship().containsFkColumn(this)) continue;
                return k.getRelationship().getParent();
            }
            return null;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @NonBound
    public boolean isForeignKey() {
        return this.getReferencedTable() != null;
    }

    @NonBound
    public boolean isExported() {
        if (this.getParent() == null) {
            return false;
        }
        try {
            for (SQLRelationship r : this.getParent().getExportedKeys()) {
                if (!r.containsPkColumn(this)) continue;
                return true;
            }
            return false;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @NonBound
    public boolean isIndexed() {
        if (this.getParent() == null) {
            return false;
        }
        try {
            for (SQLIndex ind : this.getParent().getIndices()) {
                for (SQLIndex.Column col : ind.getChildren(SQLIndex.Column.class)) {
                    if (!this.equals(col.getColumn())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @NonBound
    public boolean isUniqueIndexed() {
        if (this.getParent() == null) {
            return false;
        }
        try {
            for (SQLIndex ind : this.getParent().getIndices()) {
                if (!ind.isUnique()) continue;
                for (SQLIndex.Column col : ind.getChildren(SQLIndex.Column.class)) {
                    if (!this.equals(col.getColumn())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SQLObjectException ex) {
            throw new SQLObjectRuntimeException(ex);
        }
    }

    @Override
    @Accessor
    public SQLTable getParent() {
        return (SQLTable)super.getParent();
    }

    @Mutator
    public void setParent(SQLTable parent) {
        super.setParent(parent);
    }

    @Transient
    @Accessor(isInteresting=true)
    public int getNullable() {
        logger.debug((Object)this.userDefinedSQLType);
        return this.userDefinedSQLType.getNullability();
    }

    @Transient
    @Mutator
    public void setNullable(int argNullable) {
        this.userDefinedSQLType.setMyNullability(argNullable);
    }

    public static String getDefaultName() {
        return defaultName;
    }

    public static void setDefaultName(String defaultName) {
        SQLColumn.defaultName = defaultName;
    }

    public static int getDefaultType() {
        return defaultType;
    }

    public static void setDefaultType(int defaultType) {
        SQLColumn.defaultType = defaultType;
    }

    public static int getDefaultPrec() {
        return defaultPrec;
    }

    public static void setDefaultPrec(int defaultPrec) {
        SQLColumn.defaultPrec = defaultPrec;
    }

    public static int getDefaultScale() {
        return defaultScale;
    }

    public static void setDefaultScale(int defaultScale) {
        SQLColumn.defaultScale = defaultScale;
    }

    public static boolean isDefaultInPK() {
        return defaultInPK;
    }

    public static void setDefaultInPK(boolean defaultInPK) {
        SQLColumn.defaultInPK = defaultInPK;
    }

    public static boolean isDefaultNullable() {
        return defaultNullable;
    }

    public static void setDefaultNullable(boolean defaultNullable) {
        SQLColumn.defaultNullable = defaultNullable;
    }

    public static boolean isDefaultAutoInc() {
        return defaultAutoInc;
    }

    public static void setDefaultAutoInc(boolean defaultAutoInc) {
        SQLColumn.defaultAutoInc = defaultAutoInc;
    }

    public static String getDefaultRemarks() {
        return defaultRemarks;
    }

    public static void setDefaultRemarks(String defaultRemarks) {
        SQLColumn.defaultRemarks = defaultRemarks;
    }

    public static String getDefaultForDefaultValue() {
        return defaultForDefaultValue;
    }

    public static void setDefaultForDefaultValue(String defaultForDefaultValue) {
        SQLColumn.defaultForDefaultValue = defaultForDefaultValue;
    }

    @Accessor(isInteresting=true)
    public String getRemarks() {
        return this.remarks;
    }

    @Mutator
    public void setRemarks(String argRemarks) {
        String oldRemarks = this.remarks;
        this.remarks = argRemarks;
        this.firePropertyChange("remarks", oldRemarks, argRemarks);
    }

    @NonProperty
    public String getDefaultValue() {
        return this.userDefinedSQLType.getDefaultValue(this.getPlatform());
    }

    @NonProperty
    public void setDefaultValue(String argDefaultValue) {
        this.userDefinedSQLType.setDefaultValue(this.getPlatform(), argDefaultValue);
    }

    @Transient
    @Accessor(isInteresting=true)
    public boolean isAutoIncrement() {
        return this.userDefinedSQLType.getAutoIncrement();
    }

    @Transient
    @Mutator
    public void setAutoIncrement(boolean argAutoIncrement) {
        this.userDefinedSQLType.setMyAutoIncrement(argAutoIncrement);
    }

    @Accessor
    public String getAutoIncrementSequenceName() {
        if (this.autoIncrementSequenceName == null) {
            return this.makeAutoIncrementSequenceName();
        }
        return this.autoIncrementSequenceName;
    }

    public String makeAutoIncrementSequenceName() {
        String tableName = this.getParent() == null ? "" : (this.getParent().getPhysicalName() != null && !this.getPhysicalName().trim().equals("") ? this.getParent().getPhysicalName() + "_" : this.getParent().getName() + "_");
        return tableName + this.getPhysicalName() + "_seq";
    }

    public String discoverSequenceNameFormat(String tableName, String colName) {
        String seqNameSuffix;
        String seqNamePrefix;
        String seqName = this.getAutoIncrementSequenceName();
        String newName = "";
        int prefixEnd = seqName.indexOf(colName);
        if (prefixEnd != -1 && seqName.substring(prefixEnd + colName.length()).indexOf(colName) == -1) {
            seqNamePrefix = seqName.substring(0, prefixEnd);
            seqNameSuffix = seqName.substring(prefixEnd + colName.length());
        } else if (seqName.equals(tableName + "_" + colName + "_seq")) {
            seqNamePrefix = tableName + "_";
            seqNameSuffix = "_seq";
        } else {
            seqNamePrefix = null;
            seqNameSuffix = null;
        }
        if (seqNamePrefix != null && seqNameSuffix != null) {
            newName = seqNamePrefix + colName + seqNameSuffix;
        }
        return newName;
    }

    @Mutator
    public void setAutoIncrementSequenceName(String autoIncrementSequenceName) {
        String oldName = this.getAutoIncrementSequenceName();
        if (!oldName.equals(autoIncrementSequenceName)) {
            this.begin("Setting autoIncrementSequenceName.");
            this.autoIncrementSequenceName = autoIncrementSequenceName;
            this.firePropertyChange("autoIncrementSequenceName", oldName, autoIncrementSequenceName);
            this.commit();
        }
    }

    @NonProperty
    public boolean isAutoIncrementSequenceNameSet() {
        return this.autoIncrementSequenceName != null;
    }

    public void addReference() {
        int oldReference = this.referenceCount++;
        logger.debug((Object)("incremented reference count to: " + this.referenceCount));
        this.firePropertyChange("referenceCount", oldReference, this.referenceCount);
    }

    public void removeReference() {
        if (logger.isDebugEnabled()) {
            String parentName = "<no parent table>";
            if (this.getParent() != null && this.getParent() != null) {
                parentName = this.getParent().getName();
            }
            logger.debug((Object)("Trying to remove reference from " + parentName + "." + this.getName() + " " + this.hashCode()));
        }
        if (this.referenceCount == 0) {
            logger.debug((Object)("Reference count of " + this.getParent() + "." + this + " was already 0"));
            throw new IllegalStateException("Reference count of is already 0; can't remove any references!");
        }
        int oldReference = this.referenceCount--;
        logger.debug((Object)("decremented reference count to: " + this.referenceCount));
        if (this.referenceCount == 0) {
            if (this.getParent() != null) {
                logger.debug((Object)"reference count is 0, deleting column from parent.");
                try {
                    this.getParent().removeChild(this);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                catch (ObjectDependentException e) {
                    throw new RuntimeException(e);
                }
            } else {
                logger.debug((Object)"Already removed from parent");
            }
        }
        this.firePropertyChange("referenceCount", oldReference, this.referenceCount);
    }

    @Transient
    @Accessor
    public int getReferenceCount() {
        return this.referenceCount;
    }

    @Deprecated
    @NonBound
    public void setReferenceCount(int referenceCount) {
        this.referenceCount = referenceCount;
    }

    @Override
    @NonProperty
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        return Collections.singletonList(this.userDefinedSQLType);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    @Override
    @NonProperty
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return allowedChildTypes;
    }

    @Override
    @NonProperty
    public SPVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    @Override
    public void addCheckConstraint(SQLCheckConstraint checkConstraint, int index) {
        this.userDefinedSQLType.addCheckConstraint(this.getPlatform(), checkConstraint, index);
    }

    @Override
    @Mutator
    public void setName(String name) {
        try {
            this.begin("Setting name and possibly physical or primary key name.");
            String oldName = this.getName();
            super.setName(name);
            if (this.isMagicEnabled()) {
                this.updatePhysicalNameToMatch(oldName, name);
            }
            this.commit();
        }
        catch (Throwable t) {
            this.rollback(t.getMessage());
            throw new RuntimeException(t);
        }
    }

    @Accessor(isInteresting=true)
    public String getEtlTransformationLogic() {
        return this.etlTransformationLogic;
    }

    @Mutator
    public void setEtlTransformationLogic(String etlTransformationLogic) {
        String oldTransformationLogic = this.etlTransformationLogic;
        this.etlTransformationLogic = etlTransformationLogic;
        this.firePropertyChange("etlTransformationLogic", oldTransformationLogic, etlTransformationLogic);
    }

    @Accessor(isInteresting=true)
    public String getEtlDefaultValue() {
        return this.etlDefaultValue;
    }

    @Mutator
    public void setEtlDefaultValue(String etlDefaultValue) {
        String oldDefaultValue = this.etlDefaultValue;
        this.etlDefaultValue = etlDefaultValue;
        this.firePropertyChange("etlDefaultValue", oldDefaultValue, etlDefaultValue);
    }

    @Accessor(isInteresting=true)
    public Boolean getEtlAuditable() {
        return this.etlAuditable;
    }

    @Mutator
    public void setEtlAuditable(Boolean etlAuditable) {
        Boolean oldAuditable = this.etlAuditable;
        this.etlAuditable = etlAuditable;
        this.firePropertyChange("etlAuditable", oldAuditable, etlAuditable);
    }

    @Accessor(isInteresting=true)
    public String getEtlNotes() {
        return this.etlNotes;
    }

    @Mutator
    public void setEtlNotes(String etlNotes) {
        String oldNotes = this.etlNotes;
        this.etlNotes = etlNotes;
        this.firePropertyChange("etlNotes", oldNotes, etlNotes);
    }

    public static class ColumnNameComparator
    implements Comparator<SQLColumn> {
        @Override
        public int compare(SQLColumn c1, SQLColumn c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }
}

